/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.client.screen.component;

import com.p1nero.dialog_lib.DialogueLibConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;

public class DialogueAnswerComponent {
    private final List<NpcDialogueElement> splitLines = new ArrayList<NpcDialogueElement>();
    private final List<NpcDialogueElement> fullSplitLines = new ArrayList<NpcDialogueElement>();
    private Component message;
    private final Component name;
    public int height;
    public int index;
    public int max;
    public int maxWidth;
    private boolean shouldRenderOption = false;

    public DialogueAnswerComponent(Component name) {
        this.name = name;
        this.updateDialogue((Component)Component.m_237119_());
    }

    public boolean shouldRenderOption() {
        if (!((Boolean)DialogueLibConfig.ENABLE_TYPEWRITER_EFFECT.get()).booleanValue()) {
            return true;
        }
        return this.shouldRenderOption;
    }

    public Component getMessage() {
        return this.message;
    }

    public void render(GuiGraphics guiGraphics) {
        this.splitLines.forEach(element -> element.render(guiGraphics));
    }

    public void reposition(int width, int height, int yOffset) {
        int j = 0;
        for (int i = 0; i < this.splitLines.size(); ++i) {
            NpcDialogueElement dialogue = this.splitLines.get(i);
            dialogue.width = Minecraft.m_91087_().f_91062_.m_92724_(dialogue.text) + 2;
            dialogue.x = (Boolean)DialogueLibConfig.ENABLE_TYPEWRITER_EFFECT.get() != false && i != 0 ? width / 2 - this.maxWidth / 2 : width / 2 - dialogue.width / 2;
            dialogue.y = height / 2 + j * 12 + yOffset;
            ++j;
        }
        this.height = this.splitLines.size() * 12;
    }

    public int getStartY() {
        if (this.splitLines.isEmpty()) {
            return 0;
        }
        return this.splitLines.get((int)0).y;
    }

    public void updateDialogue(Component message) {
        this.updateSplitLines(this.splitLines, message);
    }

    private void updateSplitLines(List<NpcDialogueElement> pSplitLine, Component message) {
        pSplitLine.clear();
        List list = Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)this.name.m_6881_().m_7220_(message), 300);
        this.height = list.size() * 12;
        list.forEach(text -> pSplitLine.add(new NpcDialogueElement(0, 0, 0, (FormattedCharSequence)text)));
    }

    public void updateTypewriterDialogue(Component message) {
        this.message = message;
        this.updateSplitLines(this.fullSplitLines, message);
        this.maxWidth = 0;
        for (NpcDialogueElement element : this.fullSplitLines) {
            this.maxWidth = Math.max(Minecraft.m_91087_().f_91062_.m_92724_(element.text) + 2, this.maxWidth);
        }
        this.shouldRenderOption = false;
        this.index = 0;
        this.max = message.getString().length();
        this.updateTypewriterDialogue();
    }

    public void updateTypewriterDialogue() {
        Style style = this.message.m_7383_();
        this.updateDialogue((Component)Component.m_237113_((String)this.message.m_130668_(this.index)).m_130948_(style));
        this.index += ((Integer)DialogueLibConfig.TYPEWRITER_EFFECT_SPEED.get()).intValue();
        if (this.index > this.max) {
            this.index = this.max;
            this.shouldRenderOption = true;
        }
    }

    public static class NpcDialogueElement {
        private final FormattedCharSequence text;
        private int x;
        private int y;
        private int width;

        public NpcDialogueElement(int x, int y, int width, FormattedCharSequence text) {
            this.text = text;
            this.x = x;
            this.y = y;
            this.width = width;
        }

        public void render(GuiGraphics guiGraphics) {
            if (((Boolean)DialogueLibConfig.ENABLE_ANS_BACKGROUND.get()).booleanValue()) {
                guiGraphics.m_280024_(this.x, this.y, this.x + this.width, this.y + 12, 0x66000000, 0x66000000);
            }
            guiGraphics.m_280648_(Minecraft.m_91087_().f_91062_, this.text, this.x + 1, this.y + 1, 0xFFFFFF);
        }
    }
}

