/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.client.screen;

import com.p1nero.dialog_lib.DialogueLibConfig;
import com.p1nero.dialog_lib.client.screen.component.DialogueAnswerComponent;
import com.p1nero.dialog_lib.client.screen.component.DialogueOptionComponent;
import com.p1nero.dialog_lib.mixin.MobInvoker;
import com.p1nero.dialog_lib.network.DialoguePacketHandler;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.dialog_lib.network.packet.serverbound.HandleCustomInteractPacket;
import com.p1nero.dialog_lib.network.packet.serverbound.HandleNpcBlockPlayerInteractPacket;
import com.p1nero.dialog_lib.network.packet.serverbound.HandleNpcEntityPlayerInteractPacket;
import java.util.Iterator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogueScreen
extends Screen {
    protected String modId = "";
    protected ResourceLocation PICTURE_LOCATION = null;
    public static final int BACKGROUND_COLOR = -872415232;
    public static final int BORDER_COLOR = -1;
    private int picHeight = 144;
    private int picWidth = 256;
    private int picShowHeight = 144;
    private int picShowWidth = 256;
    private int yOffset = 0;
    private float rate;
    private boolean isSilent;
    private int currentOptionsCount;
    protected DialogueAnswerComponent dialogueAnswer;
    @Nullable
    protected Entity entity;
    @Nullable
    protected BlockPos pos;
    public final int typewriterInterval;
    private int typewriterTimer = 0;

    public DialogueScreen(String modId) {
        super((Component)Component.m_237119_());
        this.modId = modId;
        this.typewriterInterval = (Integer)DialogueLibConfig.TYPEWRITER_EFFECT_INTERVAL.get();
        this.dialogueAnswer = new DialogueAnswerComponent((Component)Component.m_237119_());
    }

    public void setEntity(@NotNull Entity entity) {
        this.dialogueAnswer = new DialogueAnswerComponent((Component)this.buildDialogueAnswerName(entity.m_5446_()).m_130946_(": "));
        this.entity = entity;
    }

    public void setBlockState(BlockState blockState, BlockPos pos) {
        this.dialogueAnswer = new DialogueAnswerComponent((Component)this.buildDialogueAnswerName((Component)blockState.m_60734_().m_49954_()).m_130946_(": "));
        this.pos = pos;
    }

    public void setCustomTitle(Component customTitle) {
        this.dialogueAnswer = new DialogueAnswerComponent(customTitle);
    }

    public void setModId(String modId) {
        this.modId = modId;
    }

    public MutableComponent buildDialogueAnswerName(Component component) {
        return Component.m_237113_((String)"[").m_7220_((Component)component.m_6881_().m_130940_(ChatFormatting.GOLD)).m_130946_("]");
    }

    protected void m_7856_() {
        this.positionDialogue();
    }

    public void setPicture(ResourceLocation resourceLocation) {
        this.PICTURE_LOCATION = resourceLocation;
        if (Minecraft.m_91087_().f_91073_ != null && Minecraft.m_91087_().f_91074_ != null) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            Minecraft.m_91087_().f_91073_.m_7785_(player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11713_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public void setSilent(boolean silent) {
        this.isSilent = silent;
    }

    public void setYOffset(int yOffset) {
        this.yOffset = yOffset;
    }

    public void setPicHeight(int picHeight) {
        this.picHeight = picHeight;
    }

    public void setPicWidth(int picWidth) {
        this.picWidth = picWidth;
    }

    public void setPicShowHeight(int picShowHeight) {
        this.picShowHeight = picShowHeight;
    }

    public void setPicShowWidth(int picShowWidth) {
        this.picShowWidth = picShowWidth;
    }

    public void setupDialogueOptions(List<DialogueOptionComponent> options) {
        this.currentOptionsCount = options.size();
        this.m_169413_();
        for (DialogueOptionComponent option : options) {
            this.m_142416_((GuiEventListener)option);
        }
        this.positionDialogue();
    }

    protected void positionDialogue() {
        if (((Boolean)DialogueLibConfig.OPTION_IN_CENTER.get()).booleanValue()) {
            this.positionDialogue1();
        } else {
            this.positionDialogue2();
        }
    }

    protected void positionDialogue1() {
        this.rate = 1.25f;
        this.dialogueAnswer.reposition(this.f_96543_, (int)((float)this.f_96544_ * this.rate), this.yOffset);
        int lineNumber = this.dialogueAnswer.height / 12 + 1;
        Iterator iterator = this.f_169369_.iterator();
        while (iterator.hasNext()) {
            Renderable renderable = (Renderable)iterator.next();
            if (!(renderable instanceof DialogueOptionComponent)) continue;
            DialogueOptionComponent option = (DialogueOptionComponent)renderable;
            option.m_252865_(this.f_96543_ / 2 - option.m_5711_() / 2);
            int y = (int)((double)this.f_96544_ / 2.0 * (double)this.rate + (double)(12 * lineNumber) + (double)this.yOffset);
            option.m_253211_(y);
            ++lineNumber;
            int h = option.m_93694_() + 2;
            if (iterator.hasNext() || y + h <= this.f_96544_ || this.typewriterTimer >= 0) continue;
            this.yOffset -= h;
            this.dialogueAnswer.reposition(this.f_96543_, (int)((float)this.f_96544_ * this.rate), this.yOffset);
            y = (int)((double)this.f_96544_ / 2.0 * (double)this.rate + (double)(12 * lineNumber) + (double)this.yOffset);
            option.m_253211_(y);
        }
    }

    protected void positionDialogue2() {
        this.rate = 1.4f;
        this.dialogueAnswer.reposition(this.f_96543_, (int)((float)this.f_96544_ * this.rate), this.yOffset);
        int answerBottomY = this.dialogueAnswer.getStartY() + this.dialogueAnswer.height;
        if (answerBottomY + 10 > this.f_96544_ && this.typewriterTimer < 0) {
            this.yOffset -= 10;
        }
        int lineNumber = 0;
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof DialogueOptionComponent)) continue;
            DialogueOptionComponent option = (DialogueOptionComponent)renderable;
            option.m_252865_(this.f_96543_ / 2 + this.f_96543_ / 6);
            int y = (int)((double)this.f_96544_ / 2.0 * (double)this.rate + (double)(12 * lineNumber) + (double)this.yOffset - (double)(this.currentOptionsCount * 12));
            option.m_253211_(y);
            ++lineNumber;
        }
    }

    public void setDialogueAnswer(Component component) {
        if (((Boolean)DialogueLibConfig.ENABLE_TYPEWRITER_EFFECT.get()).booleanValue()) {
            this.dialogueAnswer.updateTypewriterDialogue(component);
        } else {
            this.dialogueAnswer.updateDialogue(component);
        }
    }

    public void finishChat(int interactionID) {
        if (this.pos != null) {
            DialoguePacketRelay.sendToServer(DialoguePacketHandler.INSTANCE, new HandleNpcBlockPlayerInteractPacket(this.pos, interactionID));
        }
        if (this.entity == null) {
            DialoguePacketRelay.sendToServer(DialoguePacketHandler.INSTANCE, new HandleCustomInteractPacket(this.modId, interactionID));
        } else {
            DialoguePacketRelay.sendToServer(DialoguePacketHandler.INSTANCE, new HandleNpcEntityPlayerInteractPacket(this.entity.m_19879_(), interactionID));
        }
        this.PICTURE_LOCATION = null;
        this.yOffset = 0;
        this.picHeight = 144;
        this.picWidth = 256;
        this.picShowHeight = 256;
        this.picShowWidth = 144;
        super.m_7379_();
    }

    public void playSound() {
        Mob mob;
        if (this.isSilent || this.entity == null) {
            return;
        }
        Entity entity = this.entity;
        if (entity instanceof Mob && ((MobInvoker)(mob = (Mob)entity)).dialog_lib$invokeGetAmbientSound() != null) {
            mob.m_9236_().m_7785_(mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), ((MobInvoker)mob).dialog_lib$invokeGetAmbientSound(), mob.m_5720_(), 1.0f, 1.0f, false);
        }
    }

    public void execute(int interactionID) {
        DialoguePacketRelay.sendToServer(DialoguePacketHandler.INSTANCE, new HandleNpcEntityPlayerInteractPacket(this.entity == null ? -1 : this.entity.m_19879_(), interactionID));
    }

    public boolean m_6375_(double v, double v1, int i) {
        if (this.dialogueAnswer.index < this.dialogueAnswer.max - 3) {
            this.dialogueAnswer.index = this.dialogueAnswer.max - 3;
        }
        return super.m_6375_(v, v1, i);
    }

    public boolean shouldRenderOption() {
        if (((Boolean)DialogueLibConfig.ENABLE_TYPEWRITER_EFFECT.get()).booleanValue()) {
            return this.dialogueAnswer.shouldRenderOption();
        }
        return true;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.renderPicture(guiGraphics);
        if (((Boolean)DialogueLibConfig.ENABLE_TYPEWRITER_EFFECT.get()).booleanValue() && this.typewriterTimer < 0) {
            this.dialogueAnswer.updateTypewriterDialogue();
            this.positionDialogue();
            this.typewriterTimer = this.typewriterInterval;
        } else {
            --this.typewriterTimer;
        }
        this.dialogueAnswer.render(guiGraphics);
        for (Renderable renderable : this.f_169369_) {
            if (renderable instanceof DialogueOptionComponent && !this.dialogueAnswer.shouldRenderOption()) continue;
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    protected void renderPicture(GuiGraphics guiGraphics) {
        if (this.PICTURE_LOCATION != null) {
            guiGraphics.m_280411_(this.PICTURE_LOCATION, this.f_96543_ / 2 - this.picShowWidth / 2, (int)((float)this.f_96544_ / 2.0f - (float)this.picShowHeight / 1.3f), this.picShowWidth, this.picShowHeight, 0.0f, 0.0f, this.picWidth, this.picHeight, this.picWidth, this.picHeight);
        }
    }

    public void m_280273_(@NotNull GuiGraphics guiGraphics) {
        if (((Boolean)DialogueLibConfig.ENABLE_BACKGROUND.get()).booleanValue()) {
            int tooltipHeight = this.dialogueAnswer.height + 10;
            if (((Boolean)DialogueLibConfig.OPTION_IN_CENTER.get()).booleanValue()) {
                tooltipHeight += (this.currentOptionsCount + 1) * 12;
            }
            int posY = (int)((double)this.f_96544_ / 2.0 * (double)this.rate + (double)this.yOffset - 5.0);
            int tooltipWidth = 340;
            int posX = this.f_96543_ / 2 - tooltipWidth / 2;
            if (((Boolean)DialogueLibConfig.FADED_BACKGROUND.get()).booleanValue()) {
                int gradientHeight = this.f_96544_ - posY;
                for (int i = 0; i < gradientHeight; ++i) {
                    float progress = (float)i / (float)gradientHeight;
                    float curve = progress * progress;
                    int alpha = (int)(160.0f * (1.0f - curve));
                    int color = alpha << 24;
                    if (alpha <= 0) continue;
                    int currentY = this.f_96544_ - i;
                    guiGraphics.m_280509_(0, currentY, this.f_96543_, currentY + 1, color);
                }
            } else {
                guiGraphics.m_280509_(posX, posY, posX + tooltipWidth, posY + tooltipHeight, -872415232);
                guiGraphics.m_280637_(posX, posY, tooltipWidth, tooltipHeight, -1);
            }
        }
    }

    public void m_6574_(@NotNull Minecraft minecraft, int width, int height) {
        this.f_96543_ = width;
        this.f_96544_ = height;
        this.positionDialogue();
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7379_() {
        this.finishChat(0);
    }
}

