/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.api.entity;

import com.p1nero.dialog_lib.DialogueLib;
import com.p1nero.dialog_lib.api.entity.EntityDialogueExtension;
import com.p1nero.dialog_lib.capability.DialogueLibCapabilities;
import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import com.p1nero.dialog_lib.client.screen.builder.StreamDialogueScreenBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public interface IEntityDialogueExtension<T extends Entity> {
    default public String getModId() {
        return this.getClass().getAnnotation(EntityDialogueExtension.class).modId();
    }

    public EntityType<T> getEntityType();

    public boolean canInteractWith(Player var1, T var2);

    default public boolean shouldLookAtPlayer(ServerPlayer player, T currentTalking) {
        return true;
    }

    default public int maxTalkDistance() {
        return 5;
    }

    @Nullable
    default public InteractionResult shouldCancelInteract(Player player, T currentTalking, InteractionHand hand) {
        return null;
    }

    default public void onPlayerInteract(Player player, T currentTalking, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.getConservingPlayer(currentTalking) == null) {
                DialogueLib.sendDialog(currentTalking, this.getServerData(serverPlayer, currentTalking, hand, new CompoundTag()), serverPlayer);
                this.setConservingPlayer(serverPlayer, currentTalking);
            }
        }
    }

    default public CompoundTag getServerData(ServerPlayer player, T currentTalking, InteractionHand hand, CompoundTag senderData) {
        return senderData;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void openDialogScreen(LocalPlayer localPlayer, T currentTalking, CompoundTag senderData) {
        StreamDialogueScreenBuilder dialogueScreenBuilder = new StreamDialogueScreenBuilder((Entity)currentTalking, this.getModId());
        DialogueScreen screen = this.getDialogScreen(dialogueScreenBuilder, localPlayer, currentTalking, senderData);
        if (screen != null) {
            Minecraft.m_91087_().m_91152_((Screen)screen);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public DialogueScreen getDialogScreen(StreamDialogueScreenBuilder var1, LocalPlayer var2, T var3, CompoundTag var4);

    public void handleNpcInteraction(T var1, ServerPlayer var2, int var3);

    default public void setConservingPlayer(ServerPlayer player, T currentTalking) {
        DialogueLibCapabilities.getDialogPatch(currentTalking).setConservingPlayer((Player)player);
    }

    default public void onTalkingTick(ServerPlayer player, T currentTalking) {
    }

    default public void removeConservingPlayer(T currentTalking) {
        DialogueLibCapabilities.setConservingPlayer(currentTalking, null);
    }

    default public Entity getConservingPlayer(T currentTalking) {
        return DialogueLibCapabilities.getDialogPatch(currentTalking).getCurrentTalkingPlayer();
    }
}

