/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.api.component;

import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.state.BlockState;

public class DialogueComponentBuilder {
    protected final String name;
    protected String modId;

    public DialogueComponentBuilder(EntityType<?> entityType, String modId) {
        this.name = entityType.toString();
        this.modId = modId;
    }

    public DialogueComponentBuilder(Entity entity, String modId) {
        this.name = entity.m_6095_().toString();
        this.modId = modId;
    }

    public DialogueComponentBuilder(BlockState blockState, String modId) {
        this.name = blockState.m_60734_().m_7705_();
        this.modId = modId;
    }

    public DialogueComponentBuilder(String name, String modId) {
        this.name = name;
        this.modId = modId;
    }

    public String modId() {
        return this.modId;
    }

    public static DialogueComponentBuilder defaultBuilder(String name, String modId) {
        return new DialogueComponentBuilder(name, modId);
    }

    public MutableComponent buildDialogue(Entity entity, Component content) {
        return Component.m_237113_((String)"[").m_7220_((Component)entity.m_5446_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_("]:").m_7220_(content);
    }

    public MutableComponent buildDialogue(EntityType<?> entity, Component content) {
        return Component.m_237113_((String)"[").m_7220_((Component)entity.m_20676_().m_6881_().m_130940_(ChatFormatting.YELLOW)).m_130946_("]:").m_7220_(content);
    }

    public MutableComponent buildDialogue(Entity entity, Component content, ChatFormatting ... nameChatFormatting) {
        return Component.m_237113_((String)"[").m_7220_((Component)entity.m_5446_().m_6881_().m_130944_(nameChatFormatting)).m_130946_("]:").m_7220_(content).m_130944_(new ChatFormatting[0]);
    }

    public MutableComponent opt(EntityType<?> entityType, String key) {
        return Component.m_237115_((String)(String.valueOf(entityType) + "." + this.modId() + ".option." + key));
    }

    public MutableComponent optWithBrackets(EntityType<?> entityType, String key) {
        return Component.m_237113_((String)"[").m_7220_((Component)this.opt(entityType, key)).m_130946_("]");
    }

    public MutableComponent opt(EntityType<?> entityType, int i) {
        return Component.m_237115_((String)(String.valueOf(entityType) + "." + this.modId() + ".option" + i));
    }

    public MutableComponent optWithBrackets(EntityType<?> entityType, int i) {
        return Component.m_237113_((String)"[").m_7220_((Component)this.opt(entityType, i)).m_130946_("]");
    }

    public MutableComponent opt(String key) {
        return Component.m_237115_((String)(this.name + "." + this.modId() + ".option." + key));
    }

    public MutableComponent opt(String key, Object ... params) {
        return Component.m_237110_((String)(this.name + "." + this.modId() + ".option" + key), (Object[])params);
    }

    public MutableComponent opt(int i) {
        return Component.m_237115_((String)(this.name + "." + this.modId() + ".option" + i));
    }

    public MutableComponent optWithBrackets(int i) {
        return Component.m_237113_((String)"[").m_7220_((Component)this.opt(i)).m_130946_("]");
    }

    public MutableComponent opt(int i, Object ... params) {
        return Component.m_237110_((String)(this.name + "." + this.modId() + ".option" + i), (Object[])params);
    }

    public MutableComponent optWithBrackets(int i, Object ... params) {
        return Component.m_237113_((String)"[").m_7220_((Component)this.opt(i, params)).m_130946_("]");
    }

    public MutableComponent ans(EntityType<?> entityType, int i, boolean newLine) {
        MutableComponent component = Component.m_237115_((String)(String.valueOf(entityType) + "." + this.modId() + ".answer" + i));
        return Component.m_237113_((String)(newLine ? "\n" : "")).m_7220_((Component)component);
    }

    public MutableComponent appendLine(String key, Object ... objects) {
        MutableComponent component = Component.m_237110_((String)key, (Object[])objects);
        return Component.m_237113_((String)"\n").m_7220_((Component)component);
    }

    public MutableComponent ans(EntityType<?> entityType, int i, Object ... objects) {
        MutableComponent component = Component.m_237110_((String)(String.valueOf(entityType) + "." + this.modId() + ".answer" + i), (Object[])objects);
        return Component.m_237113_((String)"\n").m_7220_((Component)component);
    }

    public MutableComponent ans(EntityType<?> entityType, int i, String s) {
        MutableComponent component = Component.m_237110_((String)(String.valueOf(entityType) + "." + this.modId() + ".answer" + i), (Object[])new Object[]{s});
        return Component.m_237113_((String)"\n").m_7220_((Component)component);
    }

    public MutableComponent ans(int i, boolean newLine) {
        MutableComponent component = Component.m_237115_((String)(this.name + "." + this.modId() + ".answer" + i));
        return Component.m_237113_((String)(newLine ? "\n" : "")).m_7220_((Component)component);
    }

    public MutableComponent ans(String s) {
        MutableComponent component = Component.m_237115_((String)(this.name + "." + this.modId() + ".answer" + s));
        return Component.m_237113_((String)"\n").m_7220_((Component)component);
    }

    public MutableComponent ans(int i) {
        MutableComponent component = Component.m_237115_((String)(this.name + "." + this.modId() + ".answer" + i));
        return Component.m_237113_((String)"\n").m_7220_((Component)component);
    }

    public MutableComponent ans(int i, Object ... param) {
        MutableComponent component = Component.m_237110_((String)(this.name + "." + this.modId() + ".answer" + i), (Object[])param);
        return Component.m_237113_((String)"\n").m_7220_((Component)component);
    }

    public MutableComponent buildEntityAnswer(int i) {
        MutableComponent component = Component.m_237115_((String)(this.name + "." + this.modId() + ".answer" + i));
        return Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)this.name).m_130940_(ChatFormatting.YELLOW)).m_7220_((Component)Component.m_237113_((String)"]: ").m_7220_((Component)component));
    }

    public MutableComponent ans(int skinID, int i, boolean newLine) {
        MutableComponent component = Component.m_237115_((String)(this.name + "." + this.modId() + ".answer" + skinID + "_" + i));
        return Component.m_237113_((String)(newLine ? "\n" : "")).m_7220_((Component)component);
    }

    public MutableComponent ans(int i, String s) {
        MutableComponent component = Component.m_237110_((String)(this.name + "." + this.modId() + ".answer" + i), (Object[])new Object[]{s});
        return Component.m_237113_((String)"\n").m_7220_((Component)component);
    }
}

