/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib.api.component;

import com.p1nero.dialog_lib.client.screen.DialogueScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public class DialogNode {
    public static final int NOT_EXECUTE = -114514;
    protected Component answer;
    protected Component option = Component.m_237119_();
    @Nullable
    protected Consumer<DialogueScreen> screenConsumer;
    protected int executeValue = -114514;
    protected List<DialogNode> options = new ArrayList<DialogNode>();

    public int getExecuteValue() {
        return this.executeValue;
    }

    public DialogNode(Component answer) {
        this.answer = answer;
    }

    public DialogNode(Component answer, Component option) {
        this.answer = answer;
        this.option = option;
    }

    public DialogNode(Component answer, Component option, Consumer<DialogueScreen> screenConsumer) {
        this(answer, option, -114514, screenConsumer);
    }

    public DialogNode(Component answer, Component option, int executeValue) {
        this(answer, option, executeValue, null);
    }

    public DialogNode(Component answer, Component option, int executeValue, Consumer<DialogueScreen> screenConsumer) {
        this.answer = answer;
        this.option = option;
        this.executeValue = executeValue;
        this.screenConsumer = screenConsumer;
    }

    public DialogNode addLeaf(Component option, int returnValue) {
        this.options.add(new FinalNode(option, returnValue));
        return this;
    }

    public DialogNode addLeaf(Component option) {
        this.options.add(new FinalNode(option, -1));
        return this;
    }

    public DialogNode addChild(Component answer, Component option, int executeValue, Consumer<DialogueScreen> execute) {
        DialogNode node = new DialogNode(answer, option);
        node.addExecutable(execute);
        node.addExecutable(executeValue);
        this.options.add(node);
        return this;
    }

    public DialogNode addChild(Component answer, Component option, Consumer<DialogueScreen> execute) {
        DialogNode node = new DialogNode(answer, option);
        node.addExecutable(execute);
        this.options.add(node);
        return this;
    }

    public DialogNode addChild(Component answer, Component option, int executeValue) {
        DialogNode node = new DialogNode(answer, option);
        node.addExecutable(executeValue);
        this.options.add(node);
        return this;
    }

    public DialogNode addChild(Component answer, Component option) {
        this.options.add(new DialogNode(answer, option));
        return this;
    }

    public DialogNode addChild(DialogNode node) {
        this.options.add(node);
        return this;
    }

    public DialogNode foreachAdd(DialogNode node) {
        this.options.forEach(dialogNode -> dialogNode.addChild(node));
        return this;
    }

    public DialogNode addExecutable(Consumer<DialogueScreen> runnable) {
        this.screenConsumer = runnable;
        return this;
    }

    public DialogNode addExecutable(int executeValue) {
        this.executeValue = executeValue;
        return this;
    }

    public void execute(DialogueScreen screen) {
        if (this.screenConsumer != null) {
            this.screenConsumer.accept(screen);
        }
    }

    public boolean canExecute() {
        return this.screenConsumer != null;
    }

    public boolean canExecuteCode() {
        return this.executeValue != -114514;
    }

    public Component getAnswer() {
        return this.answer;
    }

    public Component getOption() {
        return this.option;
    }

    public List<DialogNode> getChildren() {
        return this.options;
    }

    public static class FinalNode
    extends DialogNode {
        private final int returnValue;

        public FinalNode(Component finalOption, int returnValue) {
            super((Component)Component.m_237119_());
            this.option = finalOption;
            this.returnValue = returnValue;
        }

        public FinalNode(Component finalOption, int returnValue, Consumer<DialogueScreen> consumer) {
            this(finalOption, returnValue);
            this.screenConsumer = consumer;
        }

        public int getReturnValue() {
            return this.returnValue;
        }
    }
}

