/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.dialog_lib;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import com.p1nero.dialog_lib.DialogueLibConfig;
import com.p1nero.dialog_lib.api.block.IBlockDialogueExtension;
import com.p1nero.dialog_lib.api.entity.IEntityDialogueExtension;
import com.p1nero.dialog_lib.api.entity.custom.IEntityNpc;
import com.p1nero.dialog_lib.capability.DialogEntityPatch;
import com.p1nero.dialog_lib.capability.DialogueLibCapabilities;
import com.p1nero.dialog_lib.network.DialoguePacketHandler;
import com.p1nero.dialog_lib.network.DialoguePacketRelay;
import com.p1nero.dialog_lib.network.packet.clientbound.NPCBlockDialoguePacket;
import com.p1nero.dialog_lib.network.packet.clientbound.NPCEntityDialoguePacket;
import com.p1nero.dialog_lib.util.AnnotatedInstanceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="p1nero_dl")
public class DialogueLib {
    public static final String MOD_ID = "p1nero_dl";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static List<IEntityDialogueExtension> ENTITY_EXTENSIONS = Lists.newArrayList();
    public static Map<EntityType<?>, List<IEntityDialogueExtension>> ENTITY_EXTENSIONS_MAP = new HashMap();
    public static List<IBlockDialogueExtension> BLOCK_EXTENSIONS = Lists.newArrayList();
    public static Map<Block, List<IBlockDialogueExtension>> BLOCK_EXTENSIONS_MAP = new HashMap<Block, List<IBlockDialogueExtension>>();

    public DialogueLib(FMLJavaModLoadingContext context) {
        context.getModEventBus().addListener(this::dialog_lib$commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::dialog_lib$onEntityInteract);
        MinecraftForge.EVENT_BUS.addListener(this::dialog_lib$onBlockInteract);
        MinecraftForge.EVENT_BUS.addListener(this::dialog_lib$onLivingTick);
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)DialogueLibConfig.SPEC);
    }

    private void dialog_lib$commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(DialoguePacketHandler::register);
        event.enqueueWork(() -> {
            ENTITY_EXTENSIONS = AnnotatedInstanceUtil.getModEntityExtensions();
            for (IEntityDialogueExtension iEntityDialogueExtension : ENTITY_EXTENSIONS) {
                EntityType entityType = iEntityDialogueExtension.getEntityType();
                ENTITY_EXTENSIONS_MAP.computeIfAbsent(entityType, k -> new ArrayList()).add(iEntityDialogueExtension);
            }
            BLOCK_EXTENSIONS = AnnotatedInstanceUtil.getModBlockExtensions();
            for (IBlockDialogueExtension iBlockDialogueExtension : BLOCK_EXTENSIONS) {
                Object block = iBlockDialogueExtension.getBlock();
                BLOCK_EXTENSIONS_MAP.computeIfAbsent((Block)block, (Function<Block, List<IBlockDialogueExtension>>)((Function<Block, List>)k -> new ArrayList())).add(iBlockDialogueExtension);
            }
        });
    }

    private void dialog_lib$onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        DialogueLib.runIfEntityExtensionExist(event.getEntity(), event.getTarget(), iEntityDialogueExtension -> {
            iEntityDialogueExtension.onPlayerInteract(event.getEntity(), event.getTarget(), event.getHand());
            InteractionResult interactionResult = iEntityDialogueExtension.shouldCancelInteract(event.getEntity(), event.getTarget(), event.getHand());
            if (interactionResult != null) {
                event.setCancellationResult(interactionResult);
                event.setCanceled(true);
            }
        });
    }

    private void dialog_lib$onBlockInteract(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos = event.getPos();
        BlockState blockState = event.getLevel().m_8055_(pos);
        DialogueLib.runIfBlockExtensionExist(event.getEntity(), blockState, pos, iBlockDialogueExtension -> {
            iBlockDialogueExtension.onPlayerInteract(event.getEntity(), blockState, pos, event.getHand());
            if (iBlockDialogueExtension.shouldCancelInteract(event.getEntity(), blockState, pos, event.getHand())) {
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        });
    }

    private void dialog_lib$onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        IEntityNpc npc;
        DialogEntityPatch patch;
        LivingEntity player;
        if (ENTITY_EXTENSIONS_MAP.containsKey(event.getEntity().m_6095_()) && (player = (patch = DialogueLibCapabilities.getDialogPatch((Entity)event.getEntity())).getCurrentTalkingPlayer()) instanceof ServerPlayer) {
            DialogueLib.runIfEntityExtensionExist((Player)player, (Entity)event.getEntity(), arg_0 -> DialogueLib.lambda$dialog_lib$onLivingTick$5(event, (Player)player, patch, arg_0));
        }
        if ((player = event.getEntity()) instanceof IEntityNpc && (npc = (IEntityNpc)player).getConversingPlayer() != null && npc.shouldLookAtConservingPlayer() && (livingEntity = event.getEntity()) instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.m_21563_().m_148051_((Entity)npc.getConversingPlayer());
            mob.m_21573_().m_26573_();
        }
    }

    public static void runIfEntityExtensionExist(Player player, Entity self, Consumer<IEntityDialogueExtension> extensionConsumer) {
        if (self == null) {
            return;
        }
        if (ENTITY_EXTENSIONS_MAP.containsKey(self.m_6095_())) {
            ENTITY_EXTENSIONS_MAP.get(self.m_6095_()).forEach(dialogueExtension -> {
                if (dialogueExtension.canInteractWith(player, self)) {
                    extensionConsumer.accept((IEntityDialogueExtension)dialogueExtension);
                }
            });
        }
    }

    public static void runIfBlockExtensionExist(Player player, BlockState self, BlockPos pos, Consumer<IBlockDialogueExtension> extensionConsumer) {
        if (self == null) {
            return;
        }
        if (BLOCK_EXTENSIONS_MAP.containsKey(self.m_60734_())) {
            BLOCK_EXTENSIONS_MAP.get(self.m_60734_()).forEach(dialogueExtension -> {
                if (dialogueExtension.canInteractWith(player, self, pos)) {
                    extensionConsumer.accept((IBlockDialogueExtension)dialogueExtension);
                }
            });
        }
    }

    public static void sendDialog(BlockPos pos, CompoundTag data, ServerPlayer player) {
        DialoguePacketRelay.sendToPlayer(DialoguePacketHandler.INSTANCE, new NPCBlockDialoguePacket(pos, data), player);
    }

    public static void sendDialog(BlockPos pos, ServerPlayer player) {
        DialoguePacketRelay.sendToPlayer(DialoguePacketHandler.INSTANCE, new NPCBlockDialoguePacket(pos, new CompoundTag()), player);
    }

    public static void sendDialog(Entity self, CompoundTag data, ServerPlayer player) {
        DialoguePacketRelay.sendToPlayer(DialoguePacketHandler.INSTANCE, new NPCEntityDialoguePacket(self.m_19879_(), data), player);
    }

    public static void sendDialog(Entity self, ServerPlayer player) {
        DialoguePacketRelay.sendToPlayer(DialoguePacketHandler.INSTANCE, new NPCEntityDialoguePacket(self.m_19879_(), new CompoundTag()), player);
    }

    private static /* synthetic */ void lambda$dialog_lib$onLivingTick$5(LivingEvent.LivingTickEvent event, Player player, DialogEntityPatch patch, IEntityDialogueExtension iEntityDialogueExtension) {
        LivingEntity patt5659$temp;
        if (event.getEntity().m_20270_((Entity)player) > (float)iEntityDialogueExtension.maxTalkDistance()) {
            patch.setConservingPlayer(null);
        }
        if ((patt5659$temp = event.getEntity()) instanceof Mob) {
            Mob mob = (Mob)patt5659$temp;
            mob.m_21563_().m_148051_((Entity)player);
            mob.m_21573_().m_26573_();
        }
    }
}

