/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.event;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.merlin204.mimic.client.gui.BossBar;
import org.merlin204.mimic.entity.MimicEntity;
import org.merlin204.mimic.entity.proteus.ProteusEntity;
import org.merlin204.mimic.entity.shadow.ShadowMimicEntity;
import org.merlin204.mimic.item.MimicItems;
import org.merlin204.mimic.network.PacketHandler;
import org.merlin204.mimic.network.PacketRelay;
import org.merlin204.mimic.network.packet.client.SyncBossBarPacket;
import org.merlin204.mimic.util.DimensionResourceCopier;
import org.merlin204.mimic.worldgen.WraithonDimensions;

@Mod.EventBusSubscriber(modid="mimic")
public class ForgeEvents {
    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BossBar.BOSSES.forEach((uuid, integer) -> PacketRelay.sendToPlayer(PacketHandler.INSTANCE, new SyncBossBarPacket((UUID)uuid, (int)integer), serverPlayer));
        }
    }

    @SubscribeEvent
    public static void onLivingDrops(LivingDropsEvent event) {
        if (event.getEntity() instanceof MimicEntity) {
            event.getDrops().clear();
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof ProteusEntity) {
                ProteusEntity proteus = (ProteusEntity)livingEntity;
                ItemStack itemStack = new ItemStack((ItemLike)MimicItems.PROTEUS_COMMENDATION.get());
                itemStack.m_41764_(1);
                CompoundTag tag = new CompoundTag();
                proteus.saveCopy(tag);
                itemStack.m_41784_().m_128365_("copy_info", (Tag)tag);
                double x = event.getEntity().m_20185_();
                double y = event.getEntity().m_20186_();
                double z = event.getEntity().m_20189_();
                ItemEntity itemEntity = new ItemEntity(event.getEntity().m_9236_(), x, y, z, itemStack);
                event.getDrops().add(itemEntity);
            }
        }
    }

    @SubscribeEvent
    public static void hurtEvent(LivingHurtEvent event) {
        ShadowMimicEntity shadowMimicEntity;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof ShadowMimicEntity && (shadowMimicEntity = (ShadowMimicEntity)entity).getOwner() == event.getEntity()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        DimensionResourceCopier.copyDimensionToSaves(event.getServer());
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.EntityPlaceEvent event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == WraithonDimensions.THE_LETHEAN_SEA_LEVEL_KEY) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == WraithonDimensions.THE_LETHEAN_SEA_LEVEL_KEY) {
            event.setCanceled(true);
        }
    }
}

