/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.epicfight;

import com.merlin204.avalon.epicfight.animations.AvalonMovementAnimation;
import com.merlin204.avalon.util.AvalonEventUtils;
import com.merlin204.avalon.util.AvalonParticleUtils;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.merlin204.mimic.entity.proteus.ProteusEntity;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;

@Mod.EventBusSubscriber(modid="mimic", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MimicAnimations {
    public static final Function<DamageSource, AttackResult.ResultType> DODGEABLE_SOURCE_VALIDATOR = damagesource -> damagesource.m_7639_() != null && !damagesource.m_269533_(DamageTypeTags.f_268415_) && !damagesource.m_276093_(DamageTypes.f_268515_) && !damagesource.m_269533_(DamageTypeTags.f_268490_) && !damagesource.m_269533_(DamageTypeTags.f_268738_) && !damagesource.m_269533_(EpicFightDamageTypeTags.BYPASS_DODGE) ? AttackResult.ResultType.MISSED : AttackResult.ResultType.SUCCESS;
    public static AnimationManager.AnimationAccessor<StaticAnimation> IDLE;
    public static AnimationManager.AnimationAccessor<AvalonMovementAnimation> WALK;
    public static AnimationManager.AnimationAccessor<StaticAnimation> IDLE_END;
    public static AnimationManager.AnimationAccessor<AvalonMovementAnimation> WALK_END;
    public static AnimationManager.AnimationAccessor<StaticAnimation> DEATH;
    public static AnimationManager.AnimationAccessor<ActionAnimation> SKILL_1;
    public static AnimationManager.AnimationAccessor<ActionAnimation> SKILL_2;
    public static AnimationManager.AnimationAccessor<ActionAnimation> SKILL_3;
    public static AnimationManager.AnimationAccessor<ActionAnimation> PHASE_2;
    public static AnimationManager.AnimationAccessor<ActionAnimation> COME;

    public static void buildAnimations(AnimationManager.AnimationBuilder builder) {
        Armatures.ArmatureAccessor armature = Armatures.BIPED;
        IDLE = builder.nextAccessor("idle", accessor -> new StaticAnimation(0.1f, true, accessor, (AssetAccessor)armature));
        WALK = builder.nextAccessor("walk", accessor -> new AvalonMovementAnimation(0.1f, true, accessor, (AssetAccessor)armature, 1.9f));
        IDLE_END = builder.nextAccessor("idle_end", accessor -> new StaticAnimation(0.1f, true, accessor, (AssetAccessor)armature));
        WALK_END = builder.nextAccessor("walk_end", accessor -> new AvalonMovementAnimation(0.1f, true, accessor, (AssetAccessor)armature, 1.9f));
        DEATH = builder.nextAccessor("death", accessor -> new StaticAnimation(0.1f, false, accessor, (AssetAccessor)armature).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)0.16666667f, (float)1.5f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.1, (double)0.2, (int)50), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InPeriodEvent.create((float)1.5f, (float)3.0f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.2, (double)0.5, (int)50), (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}));
        SKILL_1 = builder.nextAccessor("skill_1", accessor -> (ActionAnimation)new ActionAnimation(0.1f, accessor, (AssetAccessor)armature).newTimePair(0.0f, 0.5f).addState(EntityState.ATTACK_RESULT, DODGEABLE_SOURCE_VALIDATOR).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.16666667f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.1, (double)0.2, (int)100), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.9166667f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.1, (double)0.2, (int)100), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.5f, (entityPatch, self, params) -> {
            LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
            if (entityPatch.getTarget() != null) {
                Vec3 target = entityPatch.getTarget().m_20182_();
                ((LivingEntity)entityPatch.getOriginal()).m_6034_(target.f_82479_ + (double)(3.0f * (entity.m_217043_().m_188501_() - 0.5f)), target.f_82480_, target.f_82481_ + (double)(3.0f * (entity.m_217043_().m_188501_() - 0.5f)));
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), 360.0f, true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        SKILL_2 = builder.nextAccessor("skill_2", accessor -> (ActionAnimation)new ActionAnimation(0.1f, accessor, (AssetAccessor)armature).addEvents(new AnimationEvent[]{AnimationEvent.InTimeEvent.create((float)0.0f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.1, (double)0.2, (int)100), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.41666666f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.1, (double)0.2, (int)100), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.5f, (entityPatch, self, params) -> {
            if (entityPatch.getTarget() != null) {
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), 360.0f, true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        SKILL_3 = builder.nextAccessor("skill_3", accessor -> (ActionAnimation)new ActionAnimation(0.1f, accessor, (AssetAccessor)armature).newTimePair(0.0f, 0.8333333f).addState(EntityState.ATTACK_RESULT, DODGEABLE_SOURCE_VALIDATOR).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleGroundSplit((int)50, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)5.0f, (boolean)false), AnimationEvent.InTimeEvent.create((float)0.0f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.2, (double)0.4, (int)100), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.75f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.2, (double)0.4, (int)100), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.8333333f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)1.0, (double)0.3, (double)0.3, (int)100), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.33333334f, (entityPatch, self, params) -> {
            LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
            if (entityPatch.getTarget() != null) {
                Vec3 target = entityPatch.getTarget().m_20182_();
                ((LivingEntity)entityPatch.getOriginal()).m_6034_(target.f_82479_ + (double)(1.0f * (entity.m_217043_().m_188501_() - 0.5f)), target.f_82480_, target.f_82481_ + (double)(1.0f * (entity.m_217043_().m_188501_() - 0.5f)));
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), 360.0f, true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER)}));
        PHASE_2 = builder.nextAccessor("phase_2", accessor -> (ActionAnimation)new ActionAnimation(0.1f, accessor, (AssetAccessor)armature).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.ATTACK_RESULT, DODGEABLE_SOURCE_VALIDATOR).addEvents(new AnimationEvent[]{AvalonEventUtils.simpleGroundSplit((int)265, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (float)8.0f, (boolean)false), AnimationEvent.InTimeEvent.create((float)0.0f, (entityPatch, self, params) -> {
            Entity patt10298$temp = entityPatch.getOriginal();
            if (patt10298$temp instanceof ProteusEntity) {
                ProteusEntity proteus = (ProteusEntity)patt10298$temp;
                proteus.setPhase(2);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH), AnimationEvent.InTimeEvent.create((float)3.0f, (entityPatch, self, params) -> {
            ProteusEntity proteus;
            Entity patt10635$temp = entityPatch.getOriginal();
            if (patt10635$temp instanceof ProteusEntity && (proteus = (ProteusEntity)patt10635$temp).getPhase() == 2) {
                entityPatch.getAnimator().getPlayerFor(null).setElapsedTime(2.0f);
                if (proteus.m_9236_().f_46443_) {
                    AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)1.0, (double)0.2, (double)0.2, (int)100);
                } else if (proteus.m_5448_() != null && proteus.m_5448_().m_20182_().m_82554_(proteus.m_20182_()) > 30.0) {
                    proteus.m_5448_().m_146884_(proteus.m_20182_());
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH), AnimationEvent.InTimeEvent.create((float)4.4166665f, (entityPatch, self, params) -> {
            LocalPlayer player;
            if (((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_ && (player = Minecraft.m_91087_().f_91074_) instanceof LocalPlayer) {
                MutableComponent title = Component.m_237115_((String)"entity.mimic.proteus_3").m_130940_(ChatFormatting.DARK_RED);
                Minecraft.m_91087_().f_91065_.m_168714_((Component)title);
                Minecraft.m_91087_().f_91065_.m_168684_(20, 60, 20);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)4.5f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)2.0, (double)0.5, (double)0.5, (int)300), (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}));
        COME = builder.nextAccessor("come", accessor -> (ActionAnimation)new ActionAnimation(0.1f, accessor, (AssetAccessor)armature).newTimePair(0.0f, Float.MAX_VALUE).addState(EntityState.ATTACK_RESULT, DODGEABLE_SOURCE_VALIDATOR).addEvents(new AnimationEvent[]{AnimationEvent.InPeriodEvent.create((float)0.0f, (float)2.8333333f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.1, (double)0.2, (int)50), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InPeriodEvent.create((float)2.8333333f, (float)3.0f, (entityPatch, self, params) -> AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)entityPatch, (Joint)((HumanoidArmature)armature.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)0.1, (double)0.2, (double)0.5, (int)50), (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.InTimeEvent.create((float)0.5f, (entityPatch, self, params) -> {
            LocalPlayer player;
            if (((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_ && (player = Minecraft.m_91087_().f_91074_) instanceof LocalPlayer) {
                MutableComponent title = Component.m_237115_((String)"entity.mimic.proteus_1").m_130940_(ChatFormatting.DARK_RED);
                Minecraft.m_91087_().f_91065_.m_168714_((Component)title);
                Minecraft.m_91087_().f_91065_.m_168684_(20, 60, 20);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)}));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void sendTitle() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player instanceof LocalPlayer) {
            MutableComponent title = Component.m_237113_((String)"").m_130940_(ChatFormatting.DARK_RED);
            MutableComponent subtitle = Component.m_237113_((String)"\u4f60\u7684\u6697\u7ea2\u8272\u6d88\u606f").m_130940_(ChatFormatting.DARK_RED);
            player.m_213846_((Component)Component.m_237113_((String)"\u6d88\u606f"));
            Minecraft.m_91087_().f_91065_.m_168714_((Component)title);
            Minecraft.m_91087_().f_91065_.m_168711_((Component)subtitle);
            Minecraft.m_91087_().f_91065_.m_168684_(20, 60, 20);
        }
    }

    @SubscribeEvent
    public static void registerAnimations(AnimationManager.AnimationRegistryEvent event) {
        event.newBuilder("mimic", MimicAnimations::buildAnimations);
    }
}

