/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.entity.proteus;

import com.google.common.collect.Maps;
import com.merlin204.avalon.entity.ai.AvalonAnimatedAttackGoal;
import com.merlin204.avalon.entity.ai.AvalonCombatBehaviors;
import com.merlin204.avalon.epicfight.AvalonFctions;
import com.merlin204.avalon.util.AvalonParticleUtils;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.merlin204.mimic.entity.MimicEntities;
import org.merlin204.mimic.entity.MimicPatch;
import org.merlin204.mimic.entity.ai.MimicCombatBehaviors;
import org.merlin204.mimic.entity.proteus.ProteusEntity;
import org.merlin204.mimic.entity.shadow.ShadowMimicEntity;
import org.merlin204.mimic.epicfight.MimicAnimations;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class ProteusPatch<T extends ProteusEntity>
extends MimicPatch<T> {
    protected Map<Integer, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>> phaseLivingMotions;
    protected Map<Integer, AvalonCombatBehaviors.Builder<MimicPatch<?>>> weaponAttackMotions;
    private int phaseOld;

    @Override
    public Faction getFaction() {
        return AvalonFctions.EMPTY;
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (!((ProteusEntity)this.original).m_9236_().f_46443_) {
            if (this.phaseOld != ((ProteusEntity)this.original).getPhase()) {
                this.setAIAsInfantry();
                this.modifyLivingMotionByPhase(false);
            }
            if (this.getTarget() != null && !this.getTarget().m_6084_()) {
                ((ProteusEntity)this.original).m_146870_();
            }
            if (((ProteusEntity)this.original).m_21223_() <= ((ProteusEntity)this.original).m_21233_() * 0.5f && ((ProteusEntity)this.original).getPhase() <= 1 && !this.getEntityState().inaction()) {
                Vec3 vec3 = ((ProteusEntity)this.original).m_20182_();
                Vec3 spawn1 = new Vec3(vec3.f_82479_ + (double)(5.0f * (((ProteusEntity)this.original).m_217043_().m_188501_() - 0.5f)), vec3.f_82480_, vec3.f_82481_ + (double)(5.0f * (((ProteusEntity)this.original).m_217043_().m_188501_() - 0.5f)));
                Vec3 spawn2 = new Vec3(vec3.f_82479_ + (double)(5.0f * (((ProteusEntity)this.original).m_217043_().m_188501_() - 0.5f)), vec3.f_82480_, vec3.f_82481_ + (double)(5.0f * (((ProteusEntity)this.original).m_217043_().m_188501_() - 0.5f)));
                ShadowMimicEntity shadowMimicEntity1 = new ShadowMimicEntity((EntityType<? extends PathfinderMob>)((EntityType)MimicEntities.SHADOW_MIMIC.get()), ((ProteusEntity)this.original).m_9236_(), (LivingEntity)this.original);
                ShadowMimicEntity shadowMimicEntity2 = new ShadowMimicEntity((EntityType<? extends PathfinderMob>)((EntityType)MimicEntities.SHADOW_MIMIC.get()), ((ProteusEntity)this.original).m_9236_(), (LivingEntity)this.original);
                CompoundTag copyInfo = new CompoundTag();
                ((ProteusEntity)this.original).saveCopy(copyInfo);
                shadowMimicEntity1.m_146884_(spawn1);
                shadowMimicEntity2.m_146884_(spawn2);
                shadowMimicEntity1.loadCopy(copyInfo);
                shadowMimicEntity2.loadCopy(copyInfo);
                ((ProteusEntity)this.original).m_9236_().m_7967_((Entity)shadowMimicEntity1);
                ((ProteusEntity)this.original).m_9236_().m_7967_((Entity)shadowMimicEntity2);
                this.playAnimationSynchronized((AssetAccessor<? extends StaticAnimation>)MimicAnimations.PHASE_2, 0.0f);
            }
        } else if (this.phaseOld < ((ProteusEntity)this.original).getPhase()) {
            ((ProteusEntity)this.original).stopMusic();
            ((ProteusEntity)this.original).startMusic();
            if (((ProteusEntity)this.original).getPhase() == 3) {
                AvalonParticleUtils.createJointSphereParticles((LivingEntityPatch)this, (Joint)((HumanoidArmature)Armatures.BIPED.get()).chest, (ParticleOptions)ParticleTypes.f_123755_, (double)1.0, (double)0.3, (double)0.3, (int)200);
            }
        }
        this.phaseOld = ((ProteusEntity)this.original).getPhase();
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.setAIAsInfantry();
    }

    @Override
    public void onConstructed(T entityIn) {
        super.onConstructed(entityIn);
        this.setPhaseLivingMotions();
        if (!((ProteusEntity)this.original).m_9236_().f_46443_) {
            this.setMaxStunShield(150.0f);
            this.setStunShield(150.0f);
        }
    }

    protected AvalonCombatBehaviors.Builder<MimicPatch<?>> getHoldingItemWeaponMotionBuilder() {
        int phase = ((ProteusEntity)this.original).getPhase();
        if (this.weaponAttackMotions != null && this.weaponAttackMotions.containsKey(phase)) {
            return this.weaponAttackMotions.get(phase);
        }
        return MimicCombatBehaviors.PHASE1;
    }

    public void setAIAsInfantry() {
        AvalonCombatBehaviors.Builder<MimicPatch<?>> builder = this.getHoldingItemWeaponMotionBuilder();
        if (builder != null) {
            ((ProteusEntity)this.original).f_21345_.m_25352_(0, (Goal)new AvalonAnimatedAttackGoal((MobPatch)this, builder.build((MobPatch)this)));
        }
    }

    protected void setPhaseLivingMotions() {
        this.phaseLivingMotions = Maps.newHashMap();
        this.phaseLivingMotions.put(1, Set.of(Pair.of((Object)LivingMotions.IDLE, MimicAnimations.IDLE), Pair.of((Object)LivingMotions.WALK, MimicAnimations.WALK), Pair.of((Object)LivingMotions.DEATH, MimicAnimations.DEATH)));
        this.phaseLivingMotions.put(2, Set.of(Pair.of((Object)LivingMotions.IDLE, MimicAnimations.IDLE), Pair.of((Object)LivingMotions.WALK, MimicAnimations.WALK), Pair.of((Object)LivingMotions.DEATH, MimicAnimations.DEATH)));
        this.phaseLivingMotions.put(3, Set.of(Pair.of((Object)LivingMotions.IDLE, MimicAnimations.IDLE_END), Pair.of((Object)LivingMotions.WALK, MimicAnimations.WALK_END), Pair.of((Object)LivingMotions.DEATH, MimicAnimations.DEATH)));
        this.weaponAttackMotions = Maps.newHashMap();
        this.weaponAttackMotions.put(1, MimicCombatBehaviors.PHASE1);
        this.weaponAttackMotions.put(2, MimicCombatBehaviors.PHASE1);
        this.weaponAttackMotions.put(3, MimicCombatBehaviors.PHASE3);
    }

    public void onStartTracking(ServerPlayer trackingPlayer) {
        this.setPhaseLivingMotions();
        this.modifyLivingMotionByPhase(true);
    }

    protected void serverTick(LivingEvent.LivingTickEvent event) {
        super.serverTick(event);
        Vec3 Pos = ((ProteusEntity)this.getOriginal()).m_20182_();
        Level world = ((ProteusEntity)this.getOriginal()).m_9236_();
        AABB searchArea = new AABB(Pos.f_82479_ - 60.0, Pos.f_82480_ - 2.0, Pos.f_82481_ - 60.0, Pos.f_82479_ + 60.0, Pos.f_82480_ + 2.0, Pos.f_82481_ + 60.0);
        List entities = world.m_6443_(ShadowMimicEntity.class, searchArea, e -> e.m_6084_() && e.getOwner() == this.original);
        if (entities.isEmpty() && ((ProteusEntity)this.original).getPhase() == 2) {
            this.setStunShield(1.0E8f);
            ((ProteusEntity)this.original).setPhase(3);
        }
    }

    @Override
    public void tickNearbyEntity(LivingEntity entity) {
        ProteusEntity proteus;
        super.tickNearbyEntity(entity);
        if (entity instanceof ProteusEntity && (proteus = (ProteusEntity)entity).m_21223_() <= ((ProteusEntity)this.original).m_21223_()) {
            CompoundTag copy = new CompoundTag();
            proteus.saveCopy(copy);
            ((ProteusEntity)this.original).loadCopy(copy);
            proteus.m_146870_();
        }
    }

    public void modifyLivingMotionByPhase(boolean onStartTracking) {
        Map oldLivingAnimations = this.getAnimator().getLivingAnimations();
        HashMap newLivingAnimations = Maps.newHashMap();
        int phase = ((ProteusEntity)this.original).getPhase();
        boolean hasChange = false;
        if (this.phaseLivingMotions != null && this.phaseLivingMotions.containsKey(phase)) {
            Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> animModifierSet = this.phaseLivingMotions.get(phase);
            Iterator iterator = animModifierSet.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                LivingMotion motion = (LivingMotion)pair.getFirst();
                AnimationManager.AnimationAccessor newAnim = (AnimationManager.AnimationAccessor)pair.getSecond();
                if (oldLivingAnimations.containsKey(motion)) {
                    if (oldLivingAnimations.get(motion) != newAnim) {
                        hasChange = true;
                    }
                } else {
                    hasChange = true;
                }
                newLivingAnimations.put(motion, newAnim);
            }
        }
        if (!hasChange) {
            for (LivingMotion oldMotion : oldLivingAnimations.keySet()) {
                if (newLivingAnimations.containsKey(oldMotion)) continue;
                hasChange = true;
                break;
            }
        }
        if (hasChange || onStartTracking) {
            this.getAnimator().resetLivingAnimations();
            newLivingAnimations.forEach((arg_0, arg_1) -> ((Animator)this.getAnimator()).addLivingAnimation(arg_0, arg_1));
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((ProteusEntity)this.original).m_19879_());
            msg.putEntries(newLivingAnimations.entrySet());
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original, (Object[])new Object[0]);
        }
    }
}

