/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.entity.proteus;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlin204.mimic.client.gui.BossBar;
import org.merlin204.mimic.client.sound.ProteusBossMusicManager;
import org.merlin204.mimic.entity.MimicEntity;
import org.merlin204.mimic.entity.ai.MimicTargetSelector;
import org.merlin204.mimic.entity.shadow.ShadowMimicEntity;
import org.merlin204.mimic.network.PacketHandler;
import org.merlin204.mimic.network.PacketRelay;
import org.merlin204.mimic.network.packet.client.SyncBossBarPacket;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class ProteusEntity
extends MimicEntity {
    protected static final EntityDataAccessor<Integer> PHASE = SynchedEntityData.m_135353_(ProteusEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mimic", (String)"textures/entity/mimic.png");
    private final ResourceLocation TEXTURE_L = ResourceLocation.fromNamespaceAndPath((String)"mimic", (String)"textures/entity/mimic_l.png");
    private final ResourceLocation TEXTURE_END = ResourceLocation.fromNamespaceAndPath((String)"mimic", (String)"textures/entity/mimic_end.png");
    private final ResourceLocation TEXTURE_L_END = ResourceLocation.fromNamespaceAndPath((String)"mimic", (String)"textures/entity/mimic_l_end.png");
    protected final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.PURPLE, BossEvent.BossBarOverlay.PROGRESS);
    private boolean musicStarted = false;

    public ProteusEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        if (!this.m_9236_().f_46443_) {
            BossBar.BOSSES.put(this.bossInfo.m_18860_(), this.m_19879_());
            PacketRelay.sendToAll(PacketHandler.INSTANCE, new SyncBossBarPacket(this.bossInfo.m_18860_(), this.m_19879_()));
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            if (!this.musicStarted) {
                this.startMusic();
            }
        } else {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        ShadowMimicEntity shadowMimicEntity;
        if (this.getPhase() == 2) {
            return false;
        }
        if (this.getPhase() == 1 && this.m_21223_() < this.m_21233_() * 0.5f) {
            return false;
        }
        Entity entity = damageSource.m_7639_();
        if (entity instanceof ShadowMimicEntity && (shadowMimicEntity = (ShadowMimicEntity)entity).getOwner() == this) {
            return false;
        }
        if (this.getPhase() == 3) {
            super.m_6469_(damageSource, amount * 0.5f);
        }
        return super.m_6469_(damageSource, amount);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void startMusic() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ProteusBossMusicManager.startBossMusic((Player)player, this);
            this.musicStarted = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void stopMusic() {
        ProteusBossMusicManager.stopBossMusic();
        this.musicStarted = false;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (this.m_9236_().f_46443_) {
            this.stopMusic();
        }
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        if (this.m_9236_().f_46443_) {
            this.stopMusic();
        }
    }

    public void setPhase(int phase) {
        this.f_19804_.m_135381_(PHASE, (Object)phase);
    }

    public int getPhase() {
        return (Integer)this.f_19804_.m_135370_(PHASE);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PHASE, (Object)1);
    }

    @Override
    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("phase", this.getPhase());
    }

    @Override
    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setPhase(tag.m_128451_("phase"));
    }

    protected void m_8024_() {
        super.m_8024_();
        if (!this.m_9236_().m_5776_()) {
            this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new MimicTargetSelector(this));
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public static AttributeSupplier getDefaultAttribute() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 30.0).m_22268_(Attributes.f_22277_, 72.0).m_22268_(Attributes.f_22278_, 1000.0).m_22268_(Attributes.f_22283_, 1.5).m_22268_((Attribute)EpicFightAttributes.IMPACT.get(), 5.0).m_22268_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), 50.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 50.0).m_22268_((Attribute)EpicFightAttributes.WEIGHT.get(), 0.0).m_22265_();
    }

    @Override
    @Nullable
    public ResourceLocation getTexture() {
        if (this.getPhase() == 3) {
            return this.TEXTURE_END;
        }
        return this.TEXTURE;
    }

    @Override
    @Nullable
    public ResourceLocation getLitTexture() {
        if (this.getPhase() == 3) {
            return this.TEXTURE_L_END;
        }
        return this.TEXTURE_L;
    }

    @Override
    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        if (this.getPhase() == 3) {
            return Meshes.MeshAccessor.create((String)"mimic", (String)"entity/mimic_end", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
        }
        return Meshes.MeshAccessor.create((String)"mimic", (String)"entity/mimic", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }
}

