/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.entity.client;

import com.merlin204.avalon.entity.client.model.EmptyEntityModel;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.merlin204.mimic.entity.MimicEntity;
import org.merlin204.mimic.entity.MimicPatch;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class PatchedMimicRenderer
extends PatchedLivingEntityRenderer<MimicEntity, MimicPatch<MimicEntity>, EmptyEntityModel<MimicEntity>, LivingEntityRenderer<MimicEntity, EmptyEntityModel<MimicEntity>>, SkinnedMesh> {
    private AssetAccessor<? extends SkinnedMesh> meshAssetAccessor = null;

    public PatchedMimicRenderer(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
    }

    public void render(MimicEntity entity, MimicPatch entitypatch, LivingEntityRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        Armature armature = entitypatch.getArmature();
        if (entity.getMesh() == null) {
            return;
        }
        this.meshAssetAccessor = entity.getMesh();
        SkinnedMesh mesh = (SkinnedMesh)entity.getMesh().get();
        ResourceLocation texture = entity.getTexture();
        if (armature == null || mesh == null || texture == null) {
            return;
        }
        ResourceLocation litTexture = entity.getLitTexture();
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, (LivingEntity)entity, (LivingEntityPatch)entitypatch, partialTicks);
        this.setArmaturePose((LivingEntityPatch)entitypatch, armature, partialTicks);
        ItemStack offHandStack = entity.m_21206_();
        ItemStack mainHandStack = entity.m_21205_();
        RenderEngine renderEngine = ClientEngine.getInstance().renderEngine;
        if (mainHandStack.m_41720_() != Items.f_41852_) {
            renderEngine.getItemRenderer(mainHandStack).renderItemInHand(mainHandStack, (LivingEntityPatch)entitypatch, InteractionHand.MAIN_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        }
        if (entitypatch.isOffhandItemValid() && offHandStack.m_41720_() != Items.f_41852_) {
            renderEngine.getItemRenderer(offHandStack).renderItemInHand(offHandStack, (LivingEntityPatch)entitypatch, InteractionHand.OFF_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        }
        mesh.draw(poseStack, buffer, RenderType.m_110452_((ResourceLocation)texture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        if (litTexture != null) {
            mesh.draw(poseStack, buffer, RenderType.m_234338_((ResourceLocation)litTexture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entitypatch.getArmature(), armature.getPoseMatrices());
        }
        this.renderLayer(renderer, (LivingEntityPatch)entitypatch, (LivingEntity)entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            entitypatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
    }

    public AssetAccessor<SkinnedMesh> getDefaultMesh() {
        if (this.meshAssetAccessor != null && this.meshAssetAccessor.get() instanceof SkinnedMesh) {
            return this.meshAssetAccessor;
        }
        return Meshes.BOOTS;
    }
}

