/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.entity;

import com.merlin204.avalon.item.IChangeArmatureItem;
import com.merlin204.avalon.item.animationitem.IAvalonAnimationItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import org.merlin204.mimic.copy.CopyAnimationInfo;
import org.merlin204.mimic.entity.MimicEntity;
import org.merlin204.mimic.entity.ai.MimicChaseGoal;
import org.merlin204.mimic.epicfight.MimicAnimations;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;

public class MimicPatch<T extends MimicEntity>
extends MobPatch<T> {
    public Vec3 animationStartPos;
    public float animationStartYRot;
    public final List<AssetAccessor<? extends StaticAnimation>> WHITE_LIST = List.of(MimicAnimations.SKILL_1, MimicAnimations.SKILL_2, MimicAnimations.SKILL_3, MimicAnimations.PHASE_2, MimicAnimations.COME);
    public CopyAnimationInfo copyAnimationInfoNow;
    public Map<AssetAccessor<? extends AttackAnimation>, CopyAnimationInfo> copyMap = new HashMap<AssetAccessor<? extends AttackAnimation>, CopyAnimationInfo>();
    public List<CopyAnimationInfo> comboList = new ArrayList<CopyAnimationInfo>();
    public int combo = 0;
    public int clearTime = 0;

    protected void initAnimator(Animator animator) {
        super.initAnimator(animator);
        animator.addLivingAnimation((LivingMotion)LivingMotions.IDLE, MimicAnimations.IDLE);
        animator.addLivingAnimation((LivingMotion)LivingMotions.WALK, MimicAnimations.WALK);
        animator.addLivingAnimation((LivingMotion)LivingMotions.DEATH, MimicAnimations.DEATH);
    }

    public Faction getFaction() {
        return Factions.WITHER;
    }

    protected void initAI() {
        super.initAI();
        ((MimicEntity)this.original).f_21345_.m_25352_(1, (Goal)new MimicChaseGoal(this, 2.0f));
    }

    public void tryPlayCombo() {
        if (this.comboList.size() >= 5 && this.getEntityState().canBasicAttack()) {
            this.playCopyAnimation(this.copyAnimationInfoNow);
        }
    }

    public void playCopyAnimation(CopyAnimationInfo copyAnimationInfo) {
        this.clearTime = 0;
        if (((DynamicAnimation)this.getAnimator().getPlayerFor(null).getAnimation().get()).isLinkAnimation()) {
            return;
        }
        if (this.copyMap.size() > 15) {
            int number = Math.abs(((MimicEntity)this.getOriginal()).m_217043_().m_188502_() % this.copyMap.values().size());
            Object o = this.copyMap.values().toArray()[number];
            if (o instanceof CopyAnimationInfo) {
                CopyAnimationInfo copyAnimationInfo1 = (CopyAnimationInfo)o;
                this.comboList.add(copyAnimationInfo1);
            }
        }
        if (this.comboList.size() < 5) {
            if (!this.comboList.contains(copyAnimationInfo)) {
                this.comboList.add(copyAnimationInfo);
            }
            copyAnimationInfo.playAnimation();
        } else {
            this.comboList.get(this.combo).playAnimation();
            ++this.combo;
            if (this.combo == 5) {
                this.combo = 0;
                this.comboList.clear();
            }
        }
    }

    public void playCanHitAnimation() {
        ArrayList<CopyAnimationInfo> canAtkInfo = new ArrayList<CopyAnimationInfo>();
        for (CopyAnimationInfo copyAnimationInfo : this.copyMap.values()) {
            copyAnimationInfo.tick();
            if (!copyAnimationInfo.checkCanHit() || copyAnimationInfo == this.copyAnimationInfoNow && this.copyMap.size() >= 4) continue;
            canAtkInfo.add(copyAnimationInfo);
        }
        if (!canAtkInfo.isEmpty()) {
            this.playCopyAnimation((CopyAnimationInfo)canAtkInfo.get(Math.abs(((MimicEntity)this.original).m_217043_().m_188502_() % canAtkInfo.size())));
        }
    }

    public void playRandomAnimation() {
        if (this.copyMap.isEmpty()) {
            return;
        }
        int number = Math.abs(((MimicEntity)this.getOriginal()).m_217043_().m_188502_() % this.copyMap.values().size());
        Object o = this.copyMap.values().toArray()[number];
        if (o instanceof CopyAnimationInfo) {
            CopyAnimationInfo copyAnimationInfo = (CopyAnimationInfo)o;
            this.playCopyAnimation(copyAnimationInfo);
        }
    }

    public void playDodgeAnimation() {
        this.playAnimationSynchronized((AssetAccessor<? extends StaticAnimation>)MimicAnimations.SKILL_2, 0.0f);
    }

    public void playRandomAnimationWithoutCanHit() {
        ArrayList<CopyAnimationInfo> canUes = new ArrayList<CopyAnimationInfo>();
        for (CopyAnimationInfo copyAnimationInfo : this.copyMap.values()) {
            copyAnimationInfo.tick();
            if (!this.getEntityState().canBasicAttack() || copyAnimationInfo.checkCanHit() || copyAnimationInfo == this.copyAnimationInfoNow && this.copyMap.size() >= 4) continue;
            canUes.add(copyAnimationInfo);
        }
        if (!canUes.isEmpty()) {
            this.playCopyAnimation((CopyAnimationInfo)canUes.get(Math.abs(((MimicEntity)this.original).m_217043_().m_188502_() % canUes.size())));
        } else {
            this.playCanHitAnimation();
        }
    }

    public void tick(LivingEvent.LivingTickEvent event) {
        super.tick(event);
        if (((MimicEntity)this.getOriginal()).m_21223_() < 3.0f) {
            return;
        }
        if (!((MimicEntity)this.original).m_9236_().f_46443_) {
            if (!this.getEntityState().inaction()) {
                ++this.clearTime;
                if (this.clearTime == 5) {
                    ((MimicEntity)this.getOriginal()).m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                    ((MimicEntity)this.getOriginal()).m_21008_(InteractionHand.OFF_HAND, ItemStack.f_41583_);
                    this.clearTime = 0;
                }
            }
            Vec3 Pos = ((MimicEntity)this.getOriginal()).m_20182_();
            Level world = ((MimicEntity)this.getOriginal()).m_9236_();
            AABB searchArea = new AABB(Pos.f_82479_ - 30.0, Pos.f_82480_ - 2.0, Pos.f_82481_ - 30.0, Pos.f_82479_ + 30.0, Pos.f_82480_ + 2.0, Pos.f_82481_ + 30.0);
            List entities = world.m_6443_(LivingEntity.class, searchArea, e -> e.m_6084_() && e != this.getOriginal());
            for (LivingEntity livingEntity : entities) {
                this.tickNearbyEntity(livingEntity);
            }
        }
    }

    public void tickNearbyEntity(LivingEntity entity) {
        this.tryToLearnAnimation(entity);
    }

    public void tryToLearnAnimation(LivingEntity livingEntity) {
        LivingEntityPatch livingEntityPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)livingEntity, LivingEntityPatch.class);
        if (livingEntityPatch != null && livingEntityPatch.getArmature() instanceof HumanoidArmature) {
            Object mobEffectInstance2;
            for (Object mobEffectInstance2 : livingEntity.m_21220_()) {
                if (mobEffectInstance2.m_19544_().m_19483_() != MobEffectCategory.BENEFICIAL) continue;
                ((MimicEntity)this.original).m_7292_((MobEffectInstance)mobEffectInstance2);
            }
            mobEffectInstance2 = livingEntityPatch.getAnimator().getPlayerFor(null).getAnimation().get();
            if (mobEffectInstance2 instanceof AttackAnimation) {
                AttackAnimation animation = (AttackAnimation)mobEffectInstance2;
                ItemStack main = livingEntity.m_21205_();
                ItemStack off = livingEntity.m_21206_();
                if (!(main.m_41720_() instanceof IAvalonAnimationItem || main.m_41720_() instanceof IChangeArmatureItem || off.m_41720_() instanceof IAvalonAnimationItem || off.m_41720_() instanceof IChangeArmatureItem || main == ItemStack.f_41583_)) {
                    CopyAnimationInfo copyAnimationInfo = new CopyAnimationInfo((AssetAccessor<? extends AttackAnimation>)animation.getAccessor(), this, livingEntity.m_21205_(), livingEntity.m_21206_());
                    if (animation.getTotalTime() < 8.0f) {
                        this.copyMap.put((AssetAccessor<? extends AttackAnimation>)animation.getAccessor(), copyAnimationInfo);
                    }
                }
            }
        }
    }

    public void playAnimationSynchronized(AssetAccessor<? extends StaticAnimation> animation, float transitionTimeModifier) {
        if (!this.copyMap.containsKey(animation) && !this.WHITE_LIST.contains(animation) && animation.get() instanceof ActionAnimation && this.getStunShield() > 0.0f) {
            return;
        }
        this.animationStartYRot = ((MimicEntity)this.original).m_146908_();
        this.animationStartPos = ((MimicEntity)this.original).m_20182_();
        super.playAnimationSynchronized(animation, transitionTimeModifier);
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult attackResult = super.attack(damageSource, target, hand);
        int animation = this.copyMap.size();
        if (attackResult.resultType.dealtDamage()) {
            ((MimicEntity)this.original).m_5634_(attackResult.damage * Math.min(0.1f + (float)animation * 0.1f, 1.0f));
        }
        if (this.copyAnimationInfoNow != null) {
            this.copyAnimationInfoNow.addRectangle(this.animationStartPos, this.animationStartYRot, target.m_20182_());
        }
        return attackResult;
    }

    public void onConstructed(T entityIn) {
        Animator animator;
        this.original = entityIn;
        this.armature = ((MimicEntity)((Object)entityIn)).getArmature();
        this.animator = animator = EpicFightSharedConstants.getAnimator((LivingEntityPatch)this);
        this.initAnimator(animator);
        animator.postInit();
        if (!((MimicEntity)this.original).m_9236_().f_46443_) {
            this.setMaxStunShield(100.0f);
            this.setStunShield(100.0f);
        }
    }

    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((MimicEntity)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((MimicEntity)this.original).m_20202_() != null ? LivingMotions.MOUNT : (!(((MimicEntity)this.original).m_20184_().f_82480_ < (double)-0.55f) && !this.isAirborneState() ? ((double)((MimicEntity)this.original).f_267362_.m_267731_() > 0.005 ? (((MimicEntity)this.original).m_5912_() ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE) : LivingMotions.FALL)));
        this.currentCompositeMotion = this.currentLivingMotion;
    }

    public AssetAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        if (this.getStunShield() > 0.0f) {
            return null;
        }
        return switch (stunType) {
            default -> throw new IncompatibleClassChangeError();
            case StunType.LONG -> Animations.BIPED_HIT_LONG;
            case StunType.SHORT -> Animations.BIPED_HIT_SHORT;
            case StunType.HOLD -> Animations.BIPED_HIT_SHORT;
            case StunType.KNOCKDOWN -> Animations.BIPED_KNOCKDOWN;
            case StunType.NEUTRALIZE -> Animations.BIPED_COMMON_NEUTRALIZED;
            case StunType.FALL -> Animations.BIPED_LANDING;
            case StunType.NONE -> null;
        };
    }

    public void damageStunShield(float damage, float impact) {
        this.setStunShield(this.getStunShield() - Math.min(damage, 30.0f));
        System.out.println(this.getStunShield());
    }

    public boolean applyStun(StunType stunType, float stunTime) {
        if (this.getStunShield() > 0.0f) {
            return false;
        }
        return super.applyStun(stunType, stunTime);
    }
}

