/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.entity;

import com.merlin204.avalon.entity.IAvalonMeshEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlin204.mimic.copy.CopyAnimationInfo;
import org.merlin204.mimic.entity.MimicPatch;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;

public class MimicEntity
extends PathfinderMob
implements IAvalonMeshEntity {
    private final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"mimic", (String)"textures/entity/mimic.png");
    private final ResourceLocation TEXTURE_L = ResourceLocation.fromNamespaceAndPath((String)"mimic", (String)"textures/entity/mimic_l.png");
    private int protectTick = 0;
    private int hurtCount = 0;
    private int breakTick = 100;

    public MimicEntity(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.getPatch() != null) {
            if (this.getPatch().getStunShield() <= 0.0f) {
                --this.breakTick;
                if (this.breakTick < 0) {
                    this.getPatch().setStunShield(this.getPatch().getMaxStunShield());
                }
            } else {
                this.breakTick = 100;
                if (this.protectTick == 0) {
                    this.getPatch().setStunShield(this.getPatch().getStunShield() + this.getPatch().getMaxStunShield() * 0.01f);
                }
            }
        }
        if (this.protectTick > 0) {
            --this.protectTick;
            if (this.protectTick == 0) {
                this.hurtCount = 0;
            }
        }
    }

    public MimicPatch getPatch() {
        return (MimicPatch)EpicFightCapabilities.getEntityPatch((Entity)this, MimicPatch.class);
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float amount) {
        if (amount > 30.0f) {
            amount = 30.0f;
        }
        int animation = this.getPatch().copyMap.size();
        if (this.protectTick > 0) {
            ++this.hurtCount;
            amount *= 1.0f - Math.min(0.9f, (float)this.hurtCount * 0.15f);
        }
        this.protectTick = 35;
        if (animation == 0) {
            this.m_5634_(99999.0f);
        }
        if (this.getPatch().getStunShield() > 0.0f) {
            return super.m_6469_(damageSource, amount * Math.min(0.0f + (float)animation * 0.8f, 1.5f) * 0.3f);
        }
        return super.m_6469_(damageSource, amount * Math.min(0.0f + (float)animation * 0.8f, 1.5f));
    }

    @Nullable
    public Armature getArmature() {
        return Armatures.BIPED.get();
    }

    public boolean m_6785_(double p_21542_) {
        return false;
    }

    public void saveCopy(CompoundTag tag) {
        int number = 0;
        for (CopyAnimationInfo object : this.getPatch().copyMap.values()) {
            if (!(object instanceof CopyAnimationInfo)) continue;
            CopyAnimationInfo copyAnimationInfo = object;
            String info = "copy_" + number;
            tag.m_128365_(info, (Tag)copyAnimationInfo.savaInTag());
            ++number;
        }
        tag.m_128405_("number", number);
    }

    public void loadCopy(CompoundTag tag) {
        int number = tag.m_128451_("number");
        for (int i = 0; i < number; ++i) {
            String info = "copy_" + i;
            if (!tag.m_128441_(info)) continue;
            CopyAnimationInfo copyAnimationInfo = CopyAnimationInfo.loadFormTag(tag.m_128469_(info), this.getPatch());
            this.getPatch().copyMap.put(copyAnimationInfo.animation, copyAnimationInfo);
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        this.saveCopy(tag);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.loadCopy(tag);
    }

    public static AttributeSupplier getDefaultAttribute() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 20.0).m_22268_(Attributes.f_22277_, 72.0).m_22268_(Attributes.f_22278_, 1000.0).m_22268_((Attribute)EpicFightAttributes.MAX_STRIKES.get(), 50.0).m_22268_((Attribute)EpicFightAttributes.WEIGHT.get(), 2000.0).m_22265_();
    }

    @Nullable
    public ResourceLocation getTexture() {
        return this.TEXTURE;
    }

    @Nullable
    public ResourceLocation getLitTexture() {
        return this.TEXTURE_L;
    }

    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"mimic", (String)"entity/mimic", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }
}

