/*
 * Decompiled with CFR 0.152.
 */
package org.merlin204.mimic.copy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.merlin204.mimic.entity.MimicEntity;
import org.merlin204.mimic.entity.MimicPatch;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.asset.AssetAccessor;

public class CopyAnimationInfo {
    public final AssetAccessor<? extends AttackAnimation> animation;
    public final MimicPatch<?> ownerPatch;
    public final ItemStack itemMain;
    public final ItemStack itemOff;
    public int uesCount = 0;
    private List<Rectangle> rectangles = new ArrayList<Rectangle>();

    public CopyAnimationInfo(AssetAccessor<? extends AttackAnimation> animation, MimicPatch ownerPatch, ItemStack itemMain, ItemStack itemOff) {
        this.animation = animation;
        this.ownerPatch = ownerPatch;
        this.itemMain = itemMain.m_41777_();
        this.itemOff = itemOff.m_41777_();
    }

    public CompoundTag savaInTag() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("animation", ((AttackAnimation)this.animation.get()).getRegistryName().toString());
        ArrayList<Integer> xs = new ArrayList<Integer>();
        ArrayList<Integer> zs = new ArrayList<Integer>();
        for (Rectangle rectangle : this.rectangles) {
            xs.add(rectangle.x);
            zs.add(rectangle.z);
        }
        tag.m_128405_("ues_count", this.uesCount);
        tag.m_128408_("x", xs);
        tag.m_128408_("z", zs);
        tag.m_128365_("main", (Tag)this.itemMain.m_41739_(new CompoundTag()));
        tag.m_128365_("off", (Tag)this.itemOff.m_41739_(new CompoundTag()));
        return tag;
    }

    public static CopyAnimationInfo loadFormTag(CompoundTag tag, MimicPatch ownerPatch) {
        AnimationManager.AnimationAccessor animation = AnimationManager.byKey((String)tag.m_128461_("animation"));
        ItemStack itemMain = ItemStack.m_41712_((CompoundTag)tag.m_128469_("main"));
        ItemStack itemOff = ItemStack.m_41712_((CompoundTag)tag.m_128469_("off"));
        int number = 0;
        CopyAnimationInfo copyAnimationInfo = new CopyAnimationInfo((AssetAccessor<? extends AttackAnimation>)animation, ownerPatch, itemMain, itemOff);
        List<Integer> xs = Arrays.stream(tag.m_128465_("x")).boxed().toList();
        List<Integer> zs = Arrays.stream(tag.m_128465_("z")).boxed().toList();
        for (int x : xs) {
            copyAnimationInfo.rectangles.add(new Rectangle(x, zs.get(number)));
            ++number;
        }
        copyAnimationInfo.uesCount = tag.m_128451_("ues_count");
        return copyAnimationInfo;
    }

    public void addRectangle(Vec3 startPos, float startYRot, Vec3 targetPos) {
        double theta = Math.toRadians(startYRot);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        double dx = targetPos.f_82479_ - startPos.f_82479_;
        double dz = targetPos.f_82481_ - startPos.f_82481_;
        double localX = dx * cos + dz * sin;
        double localZ = -dx * sin + dz * cos;
        int gridX = (int)Math.floor(localX + 0.5);
        int gridZ = (int)Math.floor(localZ + 0.5);
        for (Rectangle rect : this.rectangles) {
            if (rect.x != gridX || rect.z != gridZ) continue;
            return;
        }
        this.rectangles.add(new Rectangle(gridX, gridZ));
    }

    public void tick() {
    }

    public boolean checkCanHit() {
        Vec3 Pos = ((MimicEntity)this.ownerPatch.getOriginal()).m_20182_();
        float yRot = ((MimicEntity)this.ownerPatch.getOriginal()).m_146908_();
        double theta = Math.toRadians(yRot);
        double cos = Math.cos(theta);
        double sin = Math.sin(theta);
        ArrayList<Rectangle> rects = new ArrayList<Rectangle>(this.rectangles);
        LivingEntity entity = this.ownerPatch.getTarget();
        if (entity == null) {
            return false;
        }
        if (Math.abs(entity.m_20182_().f_82480_ - Pos.f_82480_) > 2.0) {
            return false;
        }
        Vec3 entityPos = entity.m_20182_();
        double dx = entityPos.f_82479_ - Pos.f_82479_;
        double dz = entityPos.f_82481_ - Pos.f_82481_;
        double localX = dx * cos + dz * sin;
        double localZ = -dx * sin + dz * cos;
        int gridX = (int)Math.floor(localX + 0.5);
        int gridZ = (int)Math.floor(localZ + 0.5);
        for (Rectangle rect : rects) {
            if (gridX < rect.x || gridX > rect.x || gridZ < rect.z || gridZ > rect.z) continue;
            return true;
        }
        return false;
    }

    public void playAnimation() {
        this.ownerPatch.copyAnimationInfoNow = this;
        ((MimicEntity)this.ownerPatch.getOriginal()).m_21008_(InteractionHand.MAIN_HAND, this.itemMain.m_41777_());
        ((MimicEntity)this.ownerPatch.getOriginal()).m_21008_(InteractionHand.OFF_HAND, this.itemOff.m_41777_());
        this.ownerPatch.playAnimationSynchronized(this.animation, 0.0f);
        ++this.uesCount;
    }

    private void drawAllRectangles() {
        Vec3 Pos = ((MimicEntity)this.ownerPatch.getOriginal()).m_20182_();
        float yRot = ((MimicEntity)this.ownerPatch.getOriginal()).m_146908_();
        LivingEntity livingEntity = (LivingEntity)this.ownerPatch.getOriginal();
        for (Rectangle rect : this.rectangles) {
            double minX = (double)rect.x - 0.5;
            double maxX = (double)rect.x + 0.5;
            double minZ = (double)rect.z - 0.5;
            double maxZ = (double)rect.z + 0.5;
            this.drawLine(Pos, yRot, minX, minZ, maxX, minZ, livingEntity);
            this.drawLine(Pos, yRot, maxX, minZ, maxX, maxZ, livingEntity);
            this.drawLine(Pos, yRot, maxX, maxZ, minX, maxZ, livingEntity);
            this.drawLine(Pos, yRot, minX, maxZ, minX, minZ, livingEntity);
        }
    }

    private void drawLine(Vec3 Pos, float yRot, double x1, double z1, double x2, double z2, LivingEntity entity) {
        double step = 0.1;
        double dx = x2 - x1;
        double dz = z2 - z1;
        double length = Math.sqrt(dx * dx + dz * dz);
        int steps = (int)(length / 0.1);
        for (int i = 0; i <= steps; ++i) {
            double progress = (double)i / (double)steps;
            double localX = x1 + dx * progress;
            double localZ = z1 + dz * progress;
            Vec3 worldPos = this.localToWorld(new Vec3(localX, 0.0, localZ), Pos, yRot);
            Level level = entity.m_9236_();
            if (!(level instanceof ServerLevel)) continue;
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, worldPos.f_82479_, worldPos.f_82480_ + 0.5, worldPos.f_82481_, 5, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private Vec3 localToWorld(Vec3 local, Vec3 origin, float yRot) {
        double radian = Math.toRadians(yRot);
        double cos = Math.cos(radian);
        double sin = Math.sin(radian);
        return new Vec3(origin.f_82479_ + local.f_82479_ * cos - local.f_82481_ * sin, origin.f_82480_, origin.f_82481_ + local.f_82479_ * sin + local.f_82481_ * cos);
    }

    public static class Rectangle {
        public final int x;
        public final int z;

        public Rectangle(int x, int z) {
            this.x = x;
            this.z = z;
        }
    }
}

