/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.entityrespawner.entity;

import com.p1nero.entityrespawner.entity.EntityRespawnerEntities;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoulEntity
extends Entity {
    protected static final EntityDataAccessor<String> ENTITY_TO_RESPAWN_ID = SynchedEntityData.m_135353_(SoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    protected static final EntityDataAccessor<Integer> TIMER = SynchedEntityData.m_135353_(SoulEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean soulEffect;

    public SoulEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
    }

    public SoulEntity(Level level, int timer, Entity original) {
        super((EntityType)EntityRespawnerEntities.SOUL_ENTITY.get(), level);
        this.setTimer(timer);
        this.setEntityToRespawn(original.m_6095_());
        this.m_146884_(original.m_20182_().m_82520_(0.0, 1.0, 0.0));
    }

    public boolean m_20068_() {
        return true;
    }

    public boolean m_6469_(@NotNull DamageSource source, float value) {
        return false;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ENTITY_TO_RESPAWN_ID, (Object)"");
        this.m_20088_().m_135372_(TIMER, (Object)0);
    }

    protected void m_7378_(@NotNull CompoundTag tag) {
        int timer = tag.m_128451_("timer");
        String entityType = tag.m_128461_("entity_type");
        this.setTimer(timer);
        this.setEntityToRespawn(entityType);
    }

    protected void m_7380_(@NotNull CompoundTag tag) {
        tag.m_128359_("entity_type", this.getEntityToRespawnId());
        tag.m_128405_("timer", this.getTimer());
    }

    public void enableSoulEffect() {
        this.soulEffect = true;
    }

    public void setUseSoulEffect(boolean soulEffect) {
        this.soulEffect = soulEffect;
    }

    public void setTimer(int timer) {
        this.m_20088_().m_135381_(TIMER, (Object)timer);
    }

    public int getTimer() {
        return (Integer)this.m_20088_().m_135370_(TIMER);
    }

    public void setEntityToRespawn(String entityType) {
        this.m_20088_().m_135381_(ENTITY_TO_RESPAWN_ID, (Object)entityType);
    }

    public void setEntityToRespawn(EntityType<?> entityType) {
        ResourceLocation resourceLocation = ForgeRegistries.ENTITY_TYPES.getKey(entityType);
        if (resourceLocation != null) {
            this.setEntityToRespawn(resourceLocation.toString());
        }
    }

    public String getEntityToRespawnId() {
        return (String)this.m_20088_().m_135370_(ENTITY_TO_RESPAWN_ID);
    }

    @Nullable
    public EntityType<?> getEntityToRespawn() {
        ResourceLocation resourceLocation = ResourceLocation.parse((String)this.getEntityToRespawnId());
        return (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resourceLocation);
    }

    public void m_8119_() {
        super.m_8119_();
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.countdown(serverLevel);
        }
    }

    public void countdown(ServerLevel serverLevel) {
        if (this.getEntityToRespawnId().isEmpty()) {
            this.m_146870_();
        }
        if (this.getTimer() > 0) {
            this.setTimer(this.getTimer() - 1);
            if (this.f_19797_ % 20 == 0 && this.soulEffect) {
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123746_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.01);
            }
            if (this.getTimer() == 1) {
                this.respawnEntity(serverLevel);
            }
        }
    }

    public void respawnEntity(ServerLevel serverLevel) {
        EntityType<?> entityType = this.getEntityToRespawn();
        if (entityType != null) {
            if (entityType.m_262496_(serverLevel, this.m_20097_(), MobSpawnType.MOB_SUMMONED) != null) {
                this.onSpawnSuccess();
            }
            this.m_146870_();
        }
    }

    public void onSpawnSuccess() {
    }

    public void m_142687_(@NotNull Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.UNLOADED_TO_CHUNK || reason == Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            return;
        }
        super.m_142687_(reason);
    }
}

