/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.entityrespawner;

import com.p1nero.entityrespawner.EntityRespawnerConfig;
import com.p1nero.entityrespawner.entity.EntityRespawnerEntities;
import com.p1nero.entityrespawner.entity.SoulEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.Nullable;

@Mod(value="entityrespawner")
public class EntityRespawnerMod {
    public static final String MOD_ID = "entityrespawner";

    public EntityRespawnerMod(FMLJavaModLoadingContext context) {
        EntityRespawnerEntities.REGISTRY.register(context.getModEventBus());
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onLivingDeath);
        MinecraftForge.EVENT_BUS.addListener(this::onLivingJoin);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)EntityRespawnerConfig.SPEC);
    }

    private void onLivingDeath(LivingDeathEvent event) {
        if (!event.isCanceled() && EntityRespawnerConfig.entities.contains(event.getEntity().m_6095_())) {
            EntityRespawnerMod.addToRespawn(event.getEntity());
        }
    }

    private void onLivingJoin(EntityJoinLevelEvent event) {
        Level level;
        if (((Boolean)EntityRespawnerConfig.RESPAWN_WHEN_RELOAD.get()).booleanValue() && (level = event.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (event.loadedFromDisk() && (level = event.getEntity()) instanceof SoulEntity) {
                SoulEntity soulEntity = (SoulEntity)level;
                soulEntity.respawnEntity(serverLevel);
            }
        }
    }

    @Nullable
    public static SoulEntity addToRespawn(LivingEntity living) {
        return EntityRespawnerMod.addToRespawn(living, (Integer)EntityRespawnerConfig.RESPAWN_TIMER.get(), (Boolean)EntityRespawnerConfig.SOUL_EFFECT.get());
    }

    @Nullable
    public static SoulEntity addToRespawn(LivingEntity living, int timer, boolean soulEffect) {
        if (living.getPersistentData().m_128471_("entityrespawnermark")) {
            return null;
        }
        Level level = living.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SoulEntity soulEntity = new SoulEntity((Level)serverLevel, timer, (Entity)living);
            soulEntity.setUseSoulEffect(soulEffect);
            if (serverLevel.m_7967_((Entity)soulEntity)) {
                living.getPersistentData().m_128379_("entityrespawnermark", true);
                return soulEntity;
            }
        }
        return null;
    }
}

