/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.qliphoth_awakening_dimensions;

import com.finderfeed.fdbosses.content.items.LocatorEye;
import com.finderfeed.fdbosses.init.BossItems;
import com.mojang.logging.LogUtils;
import com.p1nero.qliphoth_awakening_dimensions.QADConfig;
import com.p1nero.qliphoth_awakening_dimensions.placement.QADPlacementTypes;
import com.p1nero.qliphoth_awakening_dimensions.telepoter.ChesedBossSpawnerTeleporter;
import com.p1nero.qliphoth_awakening_dimensions.telepoter.MalkuthBossSpawnerTeleporter;
import com.p1nero.qliphoth_awakening_dimensions.worldgen.QADDimensions;
import com.p1nero.qliphoth_awakening_dimensions.worldgen.QADWorldGenProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;

@Mod(value="qliphoth_awakening_dimensions")
public class QADimensionsMod {
    public static final String MOD_ID = "qliphoth_awakening_dimensions";
    private static final Logger LOGGER = LogUtils.getLogger();

    public QADimensionsMod(FMLJavaModLoadingContext context) {
        IEventBus bus = context.getModEventBus();
        bus.addListener(this::qad$dataSetup);
        MinecraftForge.EVENT_BUS.addListener(this::qad$onItemUse);
        MinecraftForge.EVENT_BUS.addListener(this::qad$onToolTip);
        QADPlacementTypes.STRUCTURE_PLACEMENT_TYPES.register(bus);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)QADConfig.SPEC);
    }

    private void qad$dataSetup(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new QADWorldGenProvider(packOutput, lookupProvider));
    }

    private void qad$onToolTip(ItemTooltipEvent event) {
        if (!QADConfig.enableTeleportEye) {
            return;
        }
        if (List.of((LocatorEye)BossItems.EYE_OF_CHESED.get(), (LocatorEye)BossItems.EYE_OF_MALKUTH.get()).contains(event.getItemStack().m_41720_())) {
            event.getToolTip().add(Component.m_237115_((String)"tip.qliphoth_awakening_dimensions.enter").m_130940_(ChatFormatting.GRAY));
        }
    }

    private void qad$onItemUse(LivingEntityUseItemEvent event) {
        if (!QADConfig.enableTeleportEye) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (entity.m_9236_().f_46443_) {
            return;
        }
        if (entity.m_6144_()) {
            Player player;
            ItemStack itemStack = event.getItem();
            MinecraftServer minecraftServer = entity.m_9236_().m_7654_();
            if (minecraftServer == null) {
                return;
            }
            if (entity instanceof Player && (player = (Player)entity).m_36335_().m_41519_(itemStack.m_41720_())) {
                return;
            }
            if (itemStack.m_150930_((Item)BossItems.EYE_OF_CHESED.get())) {
                level = minecraftServer.m_129880_(QADDimensions.CHESED_LEVEL_KEY);
                if (level != null) {
                    entity.changeDimension(level, (ITeleporter)new ChesedBossSpawnerTeleporter());
                }
            } else if (itemStack.m_150930_((Item)BossItems.EYE_OF_MALKUTH.get())) {
                level = minecraftServer.m_129880_(QADDimensions.MALKUTH_LEVEL_KEY);
                if (level != null) {
                    entity.changeDimension(level, (ITeleporter)new MalkuthBossSpawnerTeleporter());
                }
            } else {
                return;
            }
            if (entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                player.m_36335_().m_41524_(itemStack.m_41720_(), QADConfig.teleportEyeCooldown);
                player.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12287_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, (long)player.m_217043_().m_188502_()));
            }
        }
    }
}

