/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.capability.Utils;

import com.mojang.datafixers.util.Pair;
import com.nameless.indestructible.api.animation.types.CustomGuardAnimation;
import com.nameless.indestructible.api.animation.types.LivingEntityPatchEvent;
import com.nameless.indestructible.client.ClientBossInfo;
import com.nameless.indestructible.client.gui.BossBarGUi;
import com.nameless.indestructible.data.AdvancedMobpatchReloader;
import com.nameless.indestructible.main.Indestructible;
import com.nameless.indestructible.server.AdvancedBossInfo;
import com.nameless.indestructible.world.ai.CombatBehaviors.AnimationMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.CounterMotion;
import com.nameless.indestructible.world.ai.CombatBehaviors.DamageSourceModifier;
import com.nameless.indestructible.world.ai.CombatBehaviors.GuardMotion;
import com.nameless.indestructible.world.ai.CombatBehaviors.GuardMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.WanderMotionSet;
import com.nameless.indestructible.world.ai.goal.AdvancedCombatGoal;
import com.nameless.indestructible.world.ai.goal.GuardGoal;
import com.nameless.indestructible.world.capability.Utils.AdvancedCustomPatchEventManger;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import com.nameless.indestructible.world.capability.Utils.IAnimationEventCapability;
import com.nameless.indestructible.world.capability.Utils.IBossEventCapability;
import java.util.Set;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.network.EntityPairingPacketType;
import yesman.epicfight.network.EntityPairingPacketTypes;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.EpicFightDamageTypeTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class CapabilityState<T extends MobPatch<?>, V extends AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider> {
    private final V provider;
    private final T mobPatch;
    public GuardMotion currentGuardMotion;
    public GuardMotion specificGuardMotion;
    private final int regenStaminaStandbyTime;
    public final boolean hasStunReduction;
    private final float maxStunShield;
    private final int reganShieldStandbyTime;
    private final float reganShieldMultiply;
    private final float staminaLoseMultiply;
    public int block_tick;
    public int maxParryTimes;
    public int tickSinceLastAction;
    public int tickSinceBreakShield;
    public CounterMotion counterMotion;
    public int parryCounter = 0;
    private int parryTimes = 0;
    public int stun_immunity_time;
    public DamageSourceModifier damageSourceModifier = null;
    public int phase;
    public int hurtResistLevel = 2;
    public boolean neutralized;
    public float strafingForward;
    public float strafingClockwise;
    public int strafingTime;
    public int inactionTime;
    private Entity lastAttacker;
    private float lastGetImpact;
    public boolean interrupted;
    public boolean isParried = false;

    public CapabilityState(V provider, T mobPatch) {
        this.provider = provider;
        this.mobPatch = mobPatch;
        this.regenStaminaStandbyTime = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getRegenStaminaStandbyTime();
        this.hasStunReduction = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).hasStunReduction();
        this.maxStunShield = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getMaxStunShield();
        this.reganShieldStandbyTime = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getReganShieldStandbyTime();
        this.reganShieldMultiply = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getReganShieldMultiply();
        this.staminaLoseMultiply = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getStaminaLoseMultiply();
    }

    public T getPatch() {
        return this.mobPatch;
    }

    public V getProvider() {
        return this.provider;
    }

    public void entityConstructed() {
        IBossEventCapability ibc;
        T t;
        if (this.mobPatch instanceof IAdvancedCapability) {
            ((Mob)this.mobPatch.getOriginal()).m_20088_().m_135372_(IAdvancedCapability.STAMINA, (Object)Float.valueOf(0.0f));
            ((Mob)this.mobPatch.getOriginal()).m_20088_().m_135372_(IAdvancedCapability.ATTACK_SPEED, (Object)Float.valueOf(1.0f));
            ((Mob)this.mobPatch.getOriginal()).m_20088_().m_135372_(IAdvancedCapability.IS_BLOCKING, (Object)false);
        }
        if ((t = this.mobPatch) instanceof IBossEventCapability && (ibc = (IBossEventCapability)t).hasBossBar()) {
            ibc.setupServerBossInfo(new AdvancedBossInfo((LivingEntity)this.mobPatch.getOriginal()));
        }
        if ((t = this.mobPatch) instanceof IAnimationEventCapability) {
            IAnimationEventCapability iec = (IAnimationEventCapability)t;
            iec.setupEventManger();
        }
    }

    public void entityJoinWorld() {
        this.tickSinceLastAction = 0;
        this.tickSinceBreakShield = 0;
        this.block_tick = 30;
        T t = this.mobPatch;
        if (t instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)t;
            iac.setStamina(iac.getMaxStamina());
            iac.setAttackSpeed(1.0f);
        }
        this.phase = 0;
        float maxStunShield = this.maxStunShield;
        if (maxStunShield > 0.0f) {
            this.mobPatch.setMaxStunShield(maxStunShield);
            this.mobPatch.setStunShield(maxStunShield);
        }
        if (!this.mobPatch.isLogicalClient()) {
            T t2 = this.mobPatch;
            if (t2 instanceof IAnimationEventCapability) {
                IAnimationEventCapability iec = (IAnimationEventCapability)t2;
                iec.getEventManager().initPassiveEvent(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getStunEvent());
                iec.getEventManager().initActiveEvent();
            }
            if (this.damageSourceModifier != null) {
                this.damageSourceModifier = null;
            }
        }
    }

    public void serverStateTick() {
        IBossEventCapability ibc;
        T t = this.mobPatch;
        if (t instanceof IBossEventCapability && (ibc = (IBossEventCapability)t).hasBossBar() && ((Mob)this.mobPatch.getOriginal()).f_19797_ % 40 == 0) {
            ibc.getServerBossInfo().update();
        }
        if (!((t = this.mobPatch) instanceof IAdvancedCapability)) {
            return;
        }
        IAdvancedCapability iac = (IAdvancedCapability)t;
        if (!this.mobPatch.getEntityState().inaction()) {
            ++this.tickSinceLastAction;
        }
        if (this.inactionTime > 0) {
            --this.inactionTime;
        }
        float stamina = iac.getStamina();
        float maxStamina = iac.getMaxStamina();
        float staminaRegen = (float)((Mob)this.mobPatch.getOriginal()).m_21133_((Attribute)EpicFightAttributes.STAMINA_REGEN.get());
        if (stamina < maxStamina) {
            if (this.tickSinceLastAction > this.regenStaminaStandbyTime && !iac.isBlocking()) {
                float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
                iac.setStamina(stamina + maxStamina * (0.01f * staminaRegen) * staminaFactor);
            } else {
                iac.setStamina(stamina + 0.0015f * staminaRegen * maxStamina);
            }
        }
        if (maxStamina < stamina) {
            iac.setStamina(maxStamina);
        }
        if (this.maxStunShield > 0.0f) {
            float stunShield = this.mobPatch.getStunShield();
            float maxStunShield = this.maxStunShield;
            if (stunShield > 0.0f) {
                if (stunShield < maxStunShield && !this.mobPatch.getEntityState().hurt() && !this.mobPatch.getEntityState().knockDown()) {
                    this.mobPatch.setStunShield(stunShield + 0.0015f * this.reganShieldMultiply * maxStunShield);
                }
                if (this.tickSinceBreakShield > 0) {
                    this.tickSinceBreakShield = 0;
                }
            }
            if (stunShield == 0.0f) {
                ++this.tickSinceBreakShield;
                if (this.tickSinceBreakShield > this.reganShieldStandbyTime) {
                    this.mobPatch.setStunShield(this.maxStunShield);
                }
            }
            if (stunShield > maxStunShield) {
                this.mobPatch.setStunShield(this.maxStunShield);
            }
        }
        if (this.neutralized && this.mobPatch.getEntityState().hurtLevel() < 2) {
            this.neutralized = false;
        }
        if (this.mobPatch.getEntityState().hurt() && this.mobPatch.getEntityState().hurtLevel() >= this.hurtResistLevel) {
            this.interrupted = true;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStateTick() {
        T t = this.mobPatch;
        if (t instanceof IBossEventCapability) {
            IBossEventCapability ibc = (IBossEventCapability)t;
            ClientBossInfo clientBossInfo = ibc.getClientBossInfo();
            if (ibc.hasBossBar() && clientBossInfo != null) {
                clientBossInfo.setHealthRatio(((Mob)this.mobPatch.getOriginal()).m_21223_() / ((Mob)this.mobPatch.getOriginal()).m_21233_());
                T t2 = this.mobPatch;
                if (t2 instanceof IAdvancedCapability) {
                    IAdvancedCapability iac = (IAdvancedCapability)t2;
                    clientBossInfo.setStaminaRatio(iac.getStamina() / iac.getMaxStamina());
                }
            }
        }
    }

    public void selectGoalToRemove(Set<Goal> toRemove) {
        if (this.mobPatch instanceof IAdvancedCapability) {
            for (WrappedGoal wrappedGoal : ((Mob)this.mobPatch.getOriginal()).f_21345_.m_148105_()) {
                Goal goal = wrappedGoal.m_26015_();
                if (!(goal instanceof MeleeAttackGoal) && !(goal instanceof AnimatedAttackGoal) && !(goal instanceof RangedAttackGoal) && !(goal instanceof TargetChasingGoal) && !(goal instanceof GuardGoal) && !(goal instanceof AdvancedCombatGoal)) continue;
                toRemove.add(goal);
            }
        }
    }

    public void initAttributes() {
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22100_(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().get(EpicFightAttributes.WEIGHT.get()).doubleValue());
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().get(EpicFightAttributes.MAX_STRIKES.get()).doubleValue());
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().get(EpicFightAttributes.ARMOR_NEGATION.get()).doubleValue());
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().get(EpicFightAttributes.IMPACT.get()).doubleValue());
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get()).m_22100_(0.5);
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()).m_22100_(0.0);
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()).m_22100_((double)1.2f);
        ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()).m_22100_(1.0);
        if (this.mobPatch instanceof IAdvancedCapability) {
            ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get()).m_22100_(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().get(EpicFightAttributes.MAX_STAMINA.get()).doubleValue());
            ((Mob)this.mobPatch.getOriginal()).m_21051_((Attribute)EpicFightAttributes.STAMINA_REGEN.get()).m_22100_(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().get(EpicFightAttributes.STAMINA_REGEN.get()).doubleValue());
        }
        if (((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().containsKey(Attributes.f_22281_)) {
            ((Mob)this.mobPatch.getOriginal()).m_21051_(Attributes.f_22281_).m_22100_(((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getAttributeValues().get(Attributes.f_22281_).doubleValue());
        }
    }

    public void initStateAnimator(Animator animator) {
        for (Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>> pair : ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getDefaultAnimations()) {
            animator.addLivingAnimation((LivingMotion)pair.getFirst(), (AssetAccessor)pair.getSecond());
        }
    }

    public void attackedEvent(Entity target, AttackResult result) {
        T t = this.mobPatch;
        if (t instanceof IAnimationEventCapability) {
            IAnimationEventCapability iec = (IAnimationEventCapability)t;
            AdvancedCustomPatchEventManger eventManger = iec.getEventManager();
            if (result.resultType.dealtDamage() && eventManger.hasHitEvent()) {
                for (LivingEntityPatchEvent.BiEvent event : eventManger.getHitEventList()) {
                    event.testAndExecute((LivingEntityPatch<?>)this.mobPatch, target);
                    if (((Mob)this.mobPatch.getOriginal()).m_6084_() && eventManger.hasHitEvent()) continue;
                    break;
                }
            }
        }
    }

    public AttackResult TryHurt(DamageSource damageSource, float amount) {
        AttackResult result = AttackResult.of((AttackResult.ResultType)this.mobPatch.getEntityState().attackResult(damageSource), (float)amount);
        if (result.resultType.dealtDamage()) {
            AttackResult attackResult = result = damageSource.m_7640_() != this.mobPatch.getOriginal() ? this.tryProcess(damageSource, amount) : result;
            if (result.resultType.dealtDamage()) {
                this.lastAttacker = damageSource.m_7640_();
                if (damageSource instanceof EpicFightDamageSource) {
                    EpicFightDamageSource efDamageSource = (EpicFightDamageSource)damageSource;
                    this.lastGetImpact = efDamageSource.calculateImpact();
                } else {
                    this.lastGetImpact = amount / 3.0f;
                }
            }
        }
        return result;
    }

    private AttackResult tryProcess(DamageSource damageSource, float amount) {
        T t = this.mobPatch;
        if (!(t instanceof IAdvancedCapability)) {
            return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
        }
        IAdvancedCapability iac = (IAdvancedCapability)t;
        if (iac.isBlocking()) {
            CustomGuardAnimation animation = iac.getGuardAnimation();
            AnimationManager.AnimationAccessor<? extends StaticAnimation> success = animation.successAnimation != null ? animation.successAnimation : Animations.SWORD_GUARD_HIT;
            boolean isFront = false;
            Vec3 sourceLocation = damageSource.m_7270_();
            if (sourceLocation != null) {
                Vec3 viewVector = ((Mob)this.mobPatch.getOriginal()).m_20252_(1.0f);
                Vec3 toSourceLocation = sourceLocation.m_82546_(((Mob)this.mobPatch.getOriginal()).m_20182_()).m_82541_();
                if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                    isFront = true;
                }
            }
            if (iac.isBlockableSource(damageSource) && isFront) {
                float impact;
                if (damageSource instanceof EpicFightDamageSource) {
                    EpicFightDamageSource efDamageSource = (EpicFightDamageSource)damageSource;
                    impact = efDamageSource.calculateImpact();
                    if (efDamageSource.m_269533_(EpicFightDamageTypeTags.GUARD_PUNCTURE)) {
                        return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
                    }
                } else {
                    impact = amount / 3.0f;
                }
                float knockback = 0.25f + Math.min(impact * 0.1f, 1.0f);
                Entity entity = damageSource.m_7640_();
                if (entity instanceof LivingEntity) {
                    LivingEntity targetEntity = (LivingEntity)entity;
                    knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)targetEntity) * 0.1f;
                }
                float cost = this.maxParryTimes > 0 && this.parryCounter + 1 < this.maxParryTimes ? iac.getParryCostMultiply() : iac.getGuardCostMultiply();
                float stamina = iac.getStamina() - impact * cost;
                iac.setStamina(stamina);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((Mob)this.mobPatch.getOriginal()).m_9236_(), HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, this.mobPatch.getOriginal(), damageSource.m_7640_());
                if (stamina >= 0.0f) {
                    RandomSource random = ((Mob)this.mobPatch.getOriginal()).m_217043_();
                    this.mobPatch.rotateTo(damageSource.m_7640_(), 30.0f, true);
                    if (this.counterMotion != null && random.m_188501_() < this.counterMotion.chance && stamina >= this.counterMotion.cost) {
                        float counter_cost = this.counterMotion.cost;
                        if (this.stun_immunity_time > 0) {
                            ((Mob)this.mobPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), this.stun_immunity_time));
                        }
                        iac.setAttackSpeed(this.counterMotion.speed);
                        this.mobPatch.playAnimationSynchronized(this.counterMotion.counter, this.counterMotion.convert_time);
                        this.mobPatch.playSound(animation.isShield != false ? SoundEvents.f_12346_ : (SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                        if (this.counterMotion.cancel_block) {
                            iac.setBlocking(false);
                        }
                        iac.setStamina(iac.getStamina() - counter_cost);
                    } else if (this.maxParryTimes > 0) {
                        if (this.parryCounter + 1 >= this.maxParryTimes) {
                            iac.setBlocking(false);
                            this.maxParryTimes = 0;
                            if (this.stun_immunity_time > 0) {
                                ((Mob)this.mobPatch.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), this.stun_immunity_time));
                            }
                        }
                        this.mobPatch.playAnimationSynchronized(iac.getParryAnimation(this.parryTimes), 0.0f);
                        ++this.parryCounter;
                        ++this.parryTimes;
                        this.mobPatch.playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                        this.mobPatch.knockBackEntity(damageSource.m_7640_().m_20182_(), 0.4f * knockback);
                    } else {
                        this.mobPatch.playAnimationSynchronized(success, 0.1f);
                        this.mobPatch.playSound(animation.isShield != false ? SoundEvents.f_12346_ : (SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
                        this.mobPatch.knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
                    }
                    Entity entity2 = damageSource.m_7640_();
                    if (entity2 instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)entity2;
                        if (damageSource.m_7640_() instanceof LivingEntity) {
                            LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)living, LivingEntityPatch.class);
                            if (targetPatch != null) {
                                targetPatch.onAttackBlocked(damageSource, this.mobPatch);
                            }
                            if (targetPatch instanceof IAdvancedCapability) {
                                IAdvancedCapability targetIAC = (IAdvancedCapability)targetPatch;
                                targetIAC.setParried(this.parryCounter > 0);
                            }
                        }
                    }
                    return new AttackResult(AttackResult.ResultType.BLOCKED, amount);
                }
                iac.setBlocking(false);
                this.mobPatch.applyStun(StunType.NEUTRALIZE, 2.0f);
                this.mobPatch.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), -0.05f, 0.1f);
                ((HitParticleType)EpicFightParticles.AIR_BURST.get()).spawnParticleWithArgument((ServerLevel)((Mob)this.mobPatch.getOriginal()).m_9236_(), this.mobPatch.getOriginal(), damageSource.m_7640_());
                iac.setStamina(iac.getMaxStamina());
                return new AttackResult(AttackResult.ResultType.SUCCESS, amount / 2.0f);
            }
        }
        return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
    }

    public void modifierDamageSource(EpicFightDamageSource damageSource, InteractionHand hand) {
        if (this.damageSourceModifier != null) {
            damageSource.setBaseImpact(this.mobPatch.getImpact(hand) * this.damageSourceModifier.impact);
            damageSource.setBaseImpact(Math.min(100.0f, this.mobPatch.getArmorNegation(hand) * this.damageSourceModifier.armor_negation));
            if (this.damageSourceModifier.stun_type != null) {
                damageSource.setStunType(this.damageSourceModifier.stun_type);
            }
        }
    }

    public Collider modifierCollider(Collider collider) {
        if (this.damageSourceModifier != null && this.damageSourceModifier.collider != null) {
            collider = this.damageSourceModifier.collider;
        }
        return collider;
    }

    public void onDeath() {
        Object iec;
        T t = this.mobPatch;
        if (t instanceof IAnimationEventCapability) {
            iec = (IAnimationEventCapability)t;
            iec.getEventManager().initActiveEvent();
        }
        if ((t = this.mobPatch) instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)t;
            iac.setBlocking(false);
        }
        if ((t = this.mobPatch) instanceof IBossEventCapability && (iec = (IBossEventCapability)t).hasBossBar() && !((Mob)this.mobPatch.getOriginal()).m_213877_()) {
            iec.getServerBossInfo().update();
        }
    }

    public float modifierDamage(float damage) {
        if (this.damageSourceModifier != null) {
            damage *= this.damageSourceModifier.damage;
        }
        return damage;
    }

    private void resetWhenStunned() {
        this.tickSinceLastAction = 0;
        T t = this.mobPatch;
        if (t instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)t;
            iac.setDamageSourceModifier(null);
            iac.setBlocking(false);
            iac.setAttackSpeed(1.0f);
        }
        if ((t = this.mobPatch) instanceof IAnimationEventCapability) {
            IAnimationEventCapability iec = (IAnimationEventCapability)t;
            iec.getEventManager().initActiveEvent();
        }
    }

    public StunType processStun(StunType stunType) {
        IAnimationEventCapability iec;
        Object object;
        if (this.neutralized) {
            stunType = stunType == StunType.KNOCKDOWN ? stunType : StunType.NONE;
        } else {
            object = this.mobPatch;
            if (object instanceof IAdvancedCapability) {
                IAdvancedCapability iac = (IAdvancedCapability)object;
                if (this.staminaLoseMultiply > 0.0f && this.lastGetImpact > 0.0f && this.mobPatch.getStunShield() <= 0.0f) {
                    iac.setStamina(iac.getStamina() - this.lastGetImpact * this.staminaLoseMultiply);
                    if (iac.getStamina() < this.lastGetImpact * this.staminaLoseMultiply) {
                        stunType = StunType.NEUTRALIZE;
                        this.mobPatch.playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), -0.05f, 0.1f);
                        if (this.lastAttacker != null) {
                            ((HitParticleType)EpicFightParticles.AIR_BURST.get()).spawnParticleWithArgument((ServerLevel)((Mob)this.mobPatch.getOriginal()).m_9236_(), this.mobPatch.getOriginal(), this.lastAttacker);
                        }
                        iac.setStamina(iac.getMaxStamina());
                    }
                }
            }
        }
        object = this.mobPatch;
        if (object instanceof IAnimationEventCapability && (iec = (IAnimationEventCapability)object).getEventManager().hasStunEvent() && this.mobPatch.getHitAnimation(stunType) != null) {
            for (LivingEntityPatchEvent.StunEvent event : iec.getEventManager().getStunEvents()) {
                event.testAndExecute((LivingEntityPatch<?>)this.mobPatch, this.lastAttacker, stunType.ordinal());
                if (((Mob)this.mobPatch.getOriginal()).m_6084_() && iec.getEventManager().hasStunEvent()) continue;
                break;
            }
        }
        if (stunType != StunType.NONE) {
            this.resetWhenStunned();
        }
        return stunType;
    }

    public void setNeutralized(StunType stunType) {
        if (stunType == StunType.NEUTRALIZE) {
            this.neutralized = true;
        }
    }

    public void fallEvent() {
        IAnimationEventCapability iec;
        this.resetWhenStunned();
        T t = this.mobPatch;
        if (t instanceof IAnimationEventCapability && (iec = (IAnimationEventCapability)t).getEventManager().hasStunEvent()) {
            for (LivingEntityPatchEvent.StunEvent stunEvent : iec.getEventManager().getStunEvents()) {
                stunEvent.testAndExecute((LivingEntityPatch<?>)this.mobPatch, this.lastAttacker, StunType.FALL.ordinal());
                if (((Mob)this.mobPatch.getOriginal()).m_6084_() && iec.getEventManager().hasStunEvent()) continue;
                break;
            }
        }
    }

    public void tracked(ServerPlayer trackingPlayer) {
        IBossEventCapability ibc;
        T t = this.mobPatch;
        if (t instanceof IBossEventCapability && (ibc = (IBossEventCapability)t).hasBossBar()) {
            AdvancedBossInfo bossInfo = ibc.getServerBossInfo();
            bossInfo.m_6543_(trackingPlayer);
            SPEntityPairingPacket packet = new SPEntityPairingPacket(((Mob)this.mobPatch.getOriginal()).m_19879_(), (EntityPairingPacketType)EntityPairingPacketTypes.SET_BOSS_EVENT_OWNER);
            packet.getBuffer().writeLong(bossInfo.m_18860_().getMostSignificantBits());
            packet.getBuffer().writeLong(bossInfo.m_18860_().getLeastSignificantBits());
            EpicFightNetworkManager.sendToPlayer((Object)packet, (ServerPlayer)trackingPlayer, (Object[])new Object[0]);
        }
    }

    public void stopTracked(Player trackingPlayer) {
        IBossEventCapability ibc;
        T t = this.mobPatch;
        if (t instanceof IBossEventCapability && (ibc = (IBossEventCapability)t).hasBossBar()) {
            AdvancedBossInfo bossInfo = ibc.getServerBossInfo();
            bossInfo.m_6539_((ServerPlayer)trackingPlayer);
        }
    }

    public void entityPairing(SPEntityPairingPacket packet) {
        T t = this.mobPatch;
        if (t instanceof IBossEventCapability) {
            IBossEventCapability ibc = (IBossEventCapability)t;
            long mostSignificant = packet.getBuffer().readLong();
            long leastSignificant = packet.getBuffer().readLong();
            UUID uuid = new UUID(mostSignificant, leastSignificant);
            ResourceLocation rl = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getBossBar() == null ? Indestructible.BOSS_BAR : ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getBossBar();
            MutableComponent name = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getName() == null ? ((Mob)this.mobPatch.getOriginal()).m_6095_().m_20676_() : Component.m_237115_((String)((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.provider)).getName());
            ibc.setupClientBossInfo(new ClientBossInfo(name.getString(), ((Mob)this.mobPatch.getOriginal()).m_5446_().getString(), rl, uuid));
            BossBarGUi.BossBarEntities.put(uuid, ibc.getClientBossInfo());
        }
    }

    public void onAttackBlocked(LivingEntityPatch<?> livingEntityPatch) {
        IAnimationEventCapability iec;
        Object object = this.mobPatch;
        if (object instanceof IAnimationEventCapability && (iec = (IAnimationEventCapability)object).getEventManager().hasBlockedEvents()) {
            for (LivingEntityPatchEvent.BlockedEvent event : iec.getEventManager().getBlockedEvents()) {
                event.testAndExecute((LivingEntityPatch<?>)this.mobPatch, livingEntityPatch.getOriginal(), this.isParried);
                if (((Mob)this.mobPatch.getOriginal()).m_6084_() && iec.getEventManager().hasBlockedEvents()) continue;
                break;
            }
        }
        this.isParried = false;
    }

    public void animationMotion(AnimationMotionSet motionSet, LivingEntityPatch.ServerAnimationPacketProvider packetProvider) {
        Object object = this.mobPatch;
        if (object instanceof IAnimationEventCapability) {
            Object event;
            IAnimationEventCapability iec = (IAnimationEventCapability)object;
            if (motionSet.time_events != null && !motionSet.time_events.isEmpty()) {
                object = motionSet.time_events.iterator();
                while (object.hasNext()) {
                    event = (LivingEntityPatchEvent.TimeStampedEvent)object.next();
                    iec.getEventManager().addTimeStampedEvent((LivingEntityPatchEvent.TimeStampedEvent)event);
                }
            }
            if (motionSet.hit_events != null && !motionSet.hit_events.isEmpty()) {
                object = motionSet.hit_events.iterator();
                while (object.hasNext()) {
                    event = (LivingEntityPatchEvent.BiEvent)object.next();
                    iec.getEventManager().addHitEvent((LivingEntityPatchEvent.BiEvent)event);
                }
            }
            if (motionSet.blocked_events != null && !motionSet.blocked_events.isEmpty()) {
                object = motionSet.blocked_events.iterator();
                while (object.hasNext()) {
                    event = (LivingEntityPatchEvent.BlockedEvent)object.next();
                    iec.getEventManager().addBlockedEvents((LivingEntityPatchEvent.BlockedEvent)event);
                }
            }
        }
        if ((object = this.mobPatch) instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)object;
            iac.setAttackSpeed(motionSet.speed);
            iac.setBlocking(false);
            if (motionSet.stamina != 0.0f) {
                iac.setStamina(iac.getStamina() - motionSet.stamina);
            }
            iac.setDamageSourceModifier(motionSet.damage_source_modifier);
        }
        if (!this.mobPatch.getEntityState().turningLocked()) {
            ((Mob)this.mobPatch.getOriginal()).m_21391_((Entity)this.mobPatch.getTarget(), 30.0f, 30.0f);
        }
        this.mobPatch.playAnimationSynchronized(motionSet.animation, motionSet.convert_time, packetProvider);
    }

    public void guardMotion(GuardMotionSet motionSet) {
        T t = this.mobPatch;
        if (t instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)t;
            iac.specificGuardMotion(motionSet.guard_motion);
            iac.modifyGuardMotion();
            iac.setBlocking(true);
            iac.setBlockTick(motionSet.guard_time);
            iac.setMaxParryTimes(motionSet.parry_times);
            iac.setStunImmunityTime(motionSet.stun_immunity_time);
            iac.setCounterMotion(motionSet.counter_motion);
        }
    }

    public void strafingMotion(WanderMotionSet wanderMotionSet) {
        T t = this.mobPatch;
        if (t instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)t;
            iac.setStrafingTime(wanderMotionSet.strafing_time);
            iac.setInactionTime(wanderMotionSet.inaction_time);
            iac.setStrafingDirection(wanderMotionSet.forward, wanderMotionSet.clockwise);
        }
    }
}

