/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.capability;

import com.nameless.indestructible.api.animation.types.CustomGuardAnimation;
import com.nameless.indestructible.client.ClientBossInfo;
import com.nameless.indestructible.data.AdvancedMobpatchReloader;
import com.nameless.indestructible.gameasset.GuardAnimations;
import com.nameless.indestructible.server.AdvancedBossInfo;
import com.nameless.indestructible.world.ai.CombatBehaviors.AnimationMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.CounterMotion;
import com.nameless.indestructible.world.ai.CombatBehaviors.DamageSourceModifier;
import com.nameless.indestructible.world.ai.CombatBehaviors.GuardMotion;
import com.nameless.indestructible.world.ai.CombatBehaviors.GuardMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.WanderMotionSet;
import com.nameless.indestructible.world.ai.goal.AdvancedChasingGoal;
import com.nameless.indestructible.world.ai.goal.AdvancedCombatGoal;
import com.nameless.indestructible.world.ai.goal.GuardGoal;
import com.nameless.indestructible.world.ai.task.AdvancedChasingBehavior;
import com.nameless.indestructible.world.ai.task.AdvancedCombatBehavior;
import com.nameless.indestructible.world.ai.task.GuardBehavior;
import com.nameless.indestructible.world.capability.Utils.AdvancedCustomPatchEventManger;
import com.nameless.indestructible.world.capability.Utils.BrainsUtils;
import com.nameless.indestructible.world.capability.Utils.CapabilityState;
import com.nameless.indestructible.world.capability.Utils.CapabilityUtils;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import com.nameless.indestructible.world.capability.Utils.IAnimationEventCapability;
import com.nameless.indestructible.world.capability.Utils.IBossEventCapability;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPEntityPairingPacket;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.behavior.BackUpIfTooCloseStopInaction;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedCustomMobPatch<T extends PathfinderMob>
extends MobPatch<T>
implements IAdvancedCapability,
IBossEventCapability,
IAnimationEventCapability {
    protected final CapabilityState<MobPatch<?>, ?> capabilityState;
    private AdvancedCustomPatchEventManger eventManger;
    public boolean hasBossBar;
    public AdvancedBossInfo bossInfo;
    @OnlyIn(value=Dist.CLIENT)
    public ClientBossInfo clientBossInfo;

    public AdvancedCustomMobPatch(Faction faction, AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider provider) {
        super(faction);
        this.capabilityState = new CapabilityState<AdvancedCustomMobPatch, AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider>(provider, this);
    }

    public void onConstructed(T entityIn) {
        super.onConstructed(entityIn);
        this.capabilityState.entityConstructed();
    }

    public void onJoinWorld(T entityIn, EntityJoinLevelEvent event) {
        this.initialized = true;
        ((PathfinderMob)this.original).m_21204_().f_22141_ = new AttributeSupplier(CapabilityUtils.putEpicFightAttributes(((PathfinderMob)this.original).m_21204_().f_22141_.f_22241_));
        this.initAttributes();
        if (!entityIn.m_9236_().m_5776_() && !((PathfinderMob)this.original).m_21525_()) {
            this.initAI();
        }
        this.capabilityState.entityJoinWorld();
    }

    @Override
    public void initAttributes() {
        this.capabilityState.initAttributes();
    }

    public void serverTick(LivingEvent.LivingTickEvent event) {
        if (this.capabilityState.hasStunReduction) {
            super.serverTick(event);
        }
        this.cancelKnockback = false;
        this.capabilityState.serverStateTick();
    }

    protected void clientTick(LivingEvent.LivingTickEvent event) {
        this.capabilityState.clientStateTick();
    }

    protected void selectGoalToRemove(Set<Goal> toRemove) {
        this.capabilityState.selectGoalToRemove(toRemove);
    }

    protected void initAI() {
        super.initAI();
        boolean isUsingBrain = !((PathfinderMob)this.getOriginal()).m_6274_().f_21845_.isEmpty();
        Object provider = this.capabilityState.getProvider();
        CombatBehaviors behaviors = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getCombatBehaviorsBuilder().build((MobPatch)this);
        if (isUsingBrain) {
            Brain brain = ((PathfinderMob)this.original).m_6274_();
            BrainsUtils.removeBehaviors(brain, Activity.f_37978_, AdvancedCombatBehavior.class);
            BrainsUtils.removeBehaviors(brain, Activity.f_37978_, AdvancedChasingBehavior.class);
            BrainsUtils.removeBehaviors(brain, Activity.f_37978_, GuardBehavior.class);
            if (behaviors != null) {
                BrainsUtils.removeBehaviors(((PathfinderMob)this.original).m_6274_(), Activity.f_37988_, MeleeAttack.class);
                BrainsUtils.removeBehaviors(((PathfinderMob)this.original).m_6274_(), Activity.f_37988_, OneShot.class);
                BrainsUtils.addBehaviors(((PathfinderMob)this.original).m_6274_(), Activity.f_37978_, new AdvancedCombatBehavior<AdvancedCustomMobPatch>(this, behaviors));
            }
            BrainRecomposer.replaceBehavior((Brain)brain, (Activity)Activity.f_37988_, (int)11, (BehaviorControl)BehaviorBuilder.m_257845_(entity -> entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem), (OneShot)BackUpIfTooCloseStopInaction.create((int)5, (float)0.75f)), (Class[])new Class[]{OneShot.class});
            BrainsUtils.replaceBehaviors(((PathfinderMob)this.original).m_6274_(), Activity.f_37978_, MoveToTargetSink.class, new AdvancedChasingBehavior<AdvancedCustomMobPatch>(this, ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getChasingSpeed(), ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getAttackRadius()));
            BrainsUtils.addBehaviors(((PathfinderMob)this.original).m_6274_(), Activity.f_37978_, new GuardBehavior(this, ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getGuardRadius()));
        } else if (behaviors != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AdvancedCombatGoal<AdvancedCustomMobPatch>(this, behaviors));
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new GuardGoal<AdvancedCustomMobPatch>(this, ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getGuardRadius()));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, new AdvancedChasingGoal<AdvancedCustomMobPatch>(this, (PathfinderMob)this.getOriginal(), ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getChasingSpeed(), true, ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)provider)).getAttackRadius()));
        }
    }

    public void initAnimator(Animator animator) {
        super.initAnimator(animator);
        this.capabilityState.initStateAnimator(animator);
        if (((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getGuardMotion() != null) {
            animator.addLivingAnimation((LivingMotion)LivingMotions.BLOCK, ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getGuardMotion().guard_animation);
        }
    }

    public void updateMotion(boolean considerInaction) {
        super.commonAggressiveMobUpdateMotion(considerInaction);
        if (this.isBlocking()) {
            this.currentCompositeMotion = LivingMotions.BLOCK;
        }
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult result = super.attack(damageSource, target, hand);
        this.capabilityState.attackedEvent(target, result);
        return result;
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }

    public void setStunReductionOnHit(StunType stunType) {
        if (this.capabilityState.hasStunReduction) {
            super.setStunReductionOnHit(stunType);
        }
    }

    public float getStunReduction() {
        if (this.capabilityState.hasStunReduction) {
            return super.getStunReduction();
        }
        return 0.0f;
    }

    @Override
    public void modifyGuardMotion() {
        this.getAnimator().resetLivingAnimations();
        this.capabilityState.initStateAnimator(this.animator);
        if (((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getGuardMotion() != null) {
            this.setCurrentGuardMotion(this.getGuardMotion());
            this.animator.addLivingAnimation((LivingMotion)LivingMotions.BLOCK, this.capabilityState.currentGuardMotion.guard_animation);
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((PathfinderMob)this.original).m_19879_());
        msg.putEntries(this.getAnimator().getLivingAnimations().entrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original, (Object[])new Object[0]);
    }

    private GuardMotion getGuardMotion() {
        GuardMotion motion = ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getGuardMotion();
        GuardMotion specific = this.capabilityState.specificGuardMotion;
        if (specific != null) {
            Boolean[] b = this.capabilityState.specificGuardMotion.changeTag;
            if (b[0].booleanValue()) {
                motion.guard_animation = specific.guard_animation;
            }
            if (b[1].booleanValue()) {
                motion.can_block_projectile = specific.can_block_projectile;
            }
            if (b[2].booleanValue()) {
                motion.cost = specific.cost;
            }
            if (b[3].booleanValue()) {
                motion.parry_cost = specific.parry_cost;
            }
            if (b[4].booleanValue()) {
                motion.parry_animation = specific.parry_animation;
            }
        }
        return motion;
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        return this.capabilityState.TryHurt(damageSource, amount);
    }

    public EpicFightDamageSource getDamageSource(AnimationManager.AnimationAccessor<? extends StaticAnimation> animation, InteractionHand hand) {
        EpicFightDamageSource damagesource = super.getDamageSource(animation, hand);
        this.capabilityState.modifierDamageSource(damagesource, hand);
        return damagesource;
    }

    public Collider getColliderMatching(InteractionHand hand) {
        Collider collider = this.getAdvancedHoldingItemCapability(hand).getWeaponCollider();
        collider = this.capabilityState.modifierCollider(collider);
        return collider;
    }

    public float getModifiedBaseDamage(float baseDamage) {
        return this.capabilityState.modifierDamage(baseDamage);
    }

    public void onDeath(LivingDeathEvent event) {
        this.capabilityState.onDeath();
        this.getAnimator().playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
    }

    public boolean applyStun(StunType stunType, float time) {
        stunType = this.capabilityState.processStun(stunType);
        boolean isStunned = super.applyStun(stunType, time);
        this.capabilityState.setNeutralized(stunType);
        return isStunned;
    }

    public void onFall(LivingFallEvent event) {
        AssetAccessor fallAnimation;
        if (!((PathfinderMob)this.getOriginal()).m_9236_().m_5776_() && this.isAirborneState() && (fallAnimation = this.getAnimator().getLivingAnimation((LivingMotion)LivingMotions.LANDING_RECOVERY, this.getHitAnimation(StunType.FALL))) != null) {
            this.playAnimationSynchronized(fallAnimation, 0.0f);
        }
        if (!((PathfinderMob)this.getOriginal()).m_9236_().m_5776_() && ((PathfinderMob)this.getOriginal()).m_20096_() && event.getDamageMultiplier() > 0.0f && !this.getEntityState().inaction() && !this.isAirborneState() && event.getDistance() > 5.0f && this.getHitAnimation(StunType.FALL) != null) {
            this.capabilityState.fallEvent();
        }
        this.setAirborneState(false);
    }

    public void knockBackEntity(Vec3 sourceLocation, float power) {
        if (this.capabilityState.neutralized) {
            return;
        }
        super.knockBackEntity(sourceLocation, power);
    }

    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getHitAnimation(StunType stunType) {
        return ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getStunAnimations().get(stunType);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        super.onStartTracking(trackingPlayer);
        this.capabilityState.tracked(trackingPlayer);
    }

    @Override
    public void onStopTracking(Player trackingPlayer) {
        this.capabilityState.stopTracked(trackingPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void entityPairing(SPEntityPairingPacket packet) {
        super.entityPairing(packet);
        this.capabilityState.entityPairing(packet);
    }

    public void onAttackBlocked(DamageSource damageSource, LivingEntityPatch<?> livingEntityPatch) {
        this.capabilityState.onAttackBlocked(livingEntityPatch);
    }

    public SoundEvent getWeaponHitSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        return itemCap.isEmpty() ? ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getHitSound() : itemCap.getHitSound();
    }

    public SoundEvent getSwingSound(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        return itemCap.isEmpty() ? ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getSwingSound() : itemCap.getSmashingSound();
    }

    public HitParticleType getWeaponHitParticle(InteractionHand hand) {
        CapabilityItem itemCap = this.getAdvancedHoldingItemCapability(hand);
        return itemCap.isEmpty() ? ((AdvancedMobpatchReloader.AdvancedCustomMobPatchProvider)((Object)this.capabilityState.getProvider())).getHitParticle() : itemCap.getHitParticle();
    }

    @Override
    public boolean hasBossBar() {
        return this.hasBossBar;
    }

    @Override
    public void setupServerBossInfo(AdvancedBossInfo bossInfo) {
        this.bossInfo = bossInfo;
    }

    @Override
    public AdvancedBossInfo getServerBossInfo() {
        return this.bossInfo;
    }

    @Override
    public void setupClientBossInfo(ClientBossInfo bossInfo) {
        this.clientBossInfo = bossInfo;
    }

    @Override
    public ClientBossInfo getClientBossInfo() {
        return this.clientBossInfo;
    }

    @Override
    public void setupEventManger() {
        this.eventManger = new AdvancedCustomPatchEventManger();
    }

    @Override
    public AdvancedCustomPatchEventManger getEventManager() {
        return this.eventManger;
    }

    @Override
    public void setBlocking(boolean blocking) {
        ((PathfinderMob)this.getOriginal()).m_20088_().m_135381_(IS_BLOCKING, (Object)blocking);
        if (!blocking) {
            this.capabilityState.parryCounter = 0;
        }
    }

    @Override
    public boolean isBlocking() {
        return (Boolean)((PathfinderMob)this.getOriginal()).m_20088_().m_135370_(IS_BLOCKING);
    }

    @Override
    public float getMaxStamina() {
        AttributeInstance maxStamina = ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STAMINA.get());
        return (float)(maxStamina == null ? 0.0 : maxStamina.m_22135_());
    }

    @Override
    public float getStamina() {
        return this.getMaxStamina() == 0.0f ? 0.0f : ((Float)((PathfinderMob)this.original).m_20088_().m_135370_(STAMINA)).floatValue();
    }

    @Override
    public void setStamina(float value) {
        float f1 = Math.max(Math.min(value, this.getMaxStamina()), 0.0f);
        ((PathfinderMob)this.original).m_20088_().m_135381_(STAMINA, (Object)Float.valueOf(f1));
    }

    @Override
    public float getAttackSpeed() {
        return ((Float)((PathfinderMob)this.original).m_20088_().m_135370_(ATTACK_SPEED)).floatValue();
    }

    @Override
    public void setAttackSpeed(float value) {
        ((PathfinderMob)this.original).m_20088_().m_135381_(ATTACK_SPEED, (Object)Float.valueOf(Math.abs(value)));
    }

    @Override
    public void resetActionTick() {
        this.capabilityState.tickSinceLastAction = 0;
    }

    @Override
    public void setParried(boolean isParried) {
        this.capabilityState.isParried = isParried;
    }

    @Override
    public float getGuardCostMultiply() {
        return this.capabilityState.currentGuardMotion != null ? this.capabilityState.currentGuardMotion.cost : 0.0f;
    }

    @Override
    public CustomGuardAnimation getGuardAnimation() {
        Object object;
        if (this.capabilityState.currentGuardMotion != null && (object = this.capabilityState.currentGuardMotion.guard_animation.get()) instanceof CustomGuardAnimation) {
            CustomGuardAnimation guardAnimation = (CustomGuardAnimation)((Object)object);
            return guardAnimation;
        }
        return (CustomGuardAnimation)((Object)GuardAnimations.MOB_LONGSWORD_GUARD.get());
    }

    @Override
    public void specificGuardMotion(@Nullable GuardMotion guard_motion) {
        this.capabilityState.specificGuardMotion = guard_motion;
    }

    @Override
    public void setCurrentGuardMotion(GuardMotion guardMotion) {
        this.capabilityState.currentGuardMotion = guardMotion;
    }

    @Override
    public boolean canBlockProjectile() {
        return this.capabilityState.currentGuardMotion != null && this.capabilityState.currentGuardMotion.can_block_projectile;
    }

    @Override
    public float getParryCostMultiply() {
        return this.capabilityState.currentGuardMotion != null ? this.capabilityState.currentGuardMotion.parry_cost : 0.0f;
    }

    @Override
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getParryAnimation(int times) {
        if (this.capabilityState.currentGuardMotion != null) {
            GuardMotion guardMotion = this.capabilityState.currentGuardMotion;
            List<AnimationManager.AnimationAccessor> parry_animation = guardMotion.parry_animation != null && !guardMotion.parry_animation.isEmpty() ? this.capabilityState.currentGuardMotion.parry_animation : List.of(Animations.LONGSWORD_GUARD_ACTIVE_HIT1, Animations.LONGSWORD_GUARD_ACTIVE_HIT2);
            return parry_animation.get(times % parry_animation.size());
        }
        return Animations.EMPTY_ANIMATION;
    }

    @Override
    public boolean isBlockableSource(DamageSource damageSource) {
        return !damageSource.m_269533_(DamageTypeTags.f_268738_) && !damageSource.m_269533_(DamageTypeTags.f_268490_) && (!damageSource.m_269533_(DamageTypeTags.f_268524_) || this.canBlockProjectile()) && !damageSource.m_269533_(DamageTypeTags.f_268415_) && !damageSource.m_276093_(DamageTypes.f_268515_) && !damageSource.m_269533_(DamageTypeTags.f_268745_);
    }

    @Override
    public int getBlockTick() {
        return this.capabilityState.block_tick;
    }

    @Override
    public void setBlockTick(int tick) {
        this.capabilityState.block_tick = tick;
    }

    @Override
    public void setCounterMotion(CounterMotion counter_motion) {
        this.capabilityState.counterMotion = counter_motion;
    }

    @Override
    public void setMaxParryTimes(int times) {
        this.capabilityState.maxParryTimes = times;
    }

    @Override
    public boolean isParrying() {
        return this.capabilityState.maxParryTimes > 0;
    }

    @Override
    public void setStunImmunityTime(int tick) {
        this.capabilityState.stun_immunity_time = tick;
    }

    @Override
    public int getPhase() {
        return this.capabilityState.phase;
    }

    @Override
    public void setPhase(int phase) {
        this.capabilityState.phase = phase;
    }

    @Override
    public void setHurtResistLevel(int level) {
        this.capabilityState.hurtResistLevel = level;
    }

    @Override
    public void setInterrupted(boolean interrupted) {
        this.capabilityState.interrupted = interrupted;
    }

    @Override
    public boolean interrupted() {
        return this.capabilityState.interrupted;
    }

    @Override
    public int getStrafingTime() {
        return this.capabilityState.strafingTime;
    }

    @Override
    public void setStrafingTime(int tick) {
        this.capabilityState.strafingTime = tick;
    }

    @Override
    public int getInactionTime() {
        return this.capabilityState.inactionTime;
    }

    @Override
    public void setInactionTime(int tick) {
        this.capabilityState.inactionTime = tick;
    }

    @Override
    public float getStrafingForward() {
        return this.capabilityState.strafingForward;
    }

    @Override
    public float getStrafingClockwise() {
        return this.capabilityState.strafingClockwise;
    }

    @Override
    public void setStrafingDirection(float forward, float clockwise) {
        this.capabilityState.strafingForward = forward;
        this.capabilityState.strafingClockwise = clockwise;
    }

    @Override
    public void actAnimationMotion(AnimationMotionSet motionSet, LivingEntityPatch.ServerAnimationPacketProvider packetProvider) {
        this.capabilityState.animationMotion(motionSet, packetProvider);
    }

    @Override
    public void actGuardMotion(GuardMotionSet motionSet) {
        this.capabilityState.guardMotion(motionSet);
    }

    @Override
    public void actStrafing(WanderMotionSet wanderMotionSet) {
        this.capabilityState.strafingMotion(wanderMotionSet);
    }

    @Override
    public void setDamageSourceModifier(@Nullable DamageSourceModifier damageSourceModifier) {
        this.capabilityState.damageSourceModifier = damageSourceModifier;
    }
}

