/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.ai.task;

import com.google.common.collect.ImmutableMap;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ProjectileWeaponItem;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class GuardBehavior<E extends Mob, T extends MobPatch<?>>
extends Behavior<E> {
    private final T mobPatch;
    private final float radiusSqr;
    private int targetInactiontime = -1;

    public GuardBehavior(T mobPatch, float radius) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.f_148205_, (Object)MemoryStatus.VALUE_PRESENT));
        this.mobPatch = mobPatch;
        this.radiusSqr = radius * radius;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E mob) {
        return this.checkTargetValid() && ((IAdvancedCapability)this.mobPatch).isBlocking();
    }

    protected boolean canStillUse(ServerLevel level, E mob, long p_22547_) {
        return this.checkExtraStartConditions(level, mob) && !this.targetInaction();
    }

    public void start(ServerLevel level, E mob, long p_22507_) {
        this.targetInactiontime = -1;
        ((IAdvancedCapability)this.mobPatch).resetActionTick();
    }

    public void stop(ServerLevel level, E mob, long p_22550_) {
        this.targetInactiontime = -1;
        ((IAdvancedCapability)this.mobPatch).setBlocking(false);
        this.mobPatch.getAnimator().resetLivingAnimations();
    }

    private boolean checkTargetValid() {
        LivingEntity livingentity = this.mobPatch.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    private boolean withinDistance() {
        LivingEntity target = this.mobPatch.getTarget();
        return ((Mob)this.mobPatch.getOriginal()).m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_()) <= (double)this.radiusSqr;
    }

    private boolean targetInaction() {
        LivingEntityPatch target = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.mobPatch.getTarget(), LivingEntityPatch.class);
        if (target == null) {
            return true;
        }
        return this.targetInactiontime > ((IAdvancedCapability)this.mobPatch).getBlockTick();
    }

    public void tick(ServerLevel level, E mob, long p_22553_) {
        LivingEntityPatch targetPatch;
        LivingEntity target = this.mobPatch.getTarget();
        if (target != null && (targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class)) != null) {
            int phase = targetPatch.getEntityState().getLevel();
            this.targetInactiontime = this.withinDistance() && phase > 0 && phase < 3 ? 0 : (((IAdvancedCapability)this.mobPatch).canBlockProjectile() && target.m_21211_().m_41720_() instanceof ProjectileWeaponItem && target.m_6117_() ? 0 : ++this.targetInactiontime);
        }
    }
}

