/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.ai.task;

import com.google.common.collect.ImmutableMap;
import com.nameless.indestructible.mixin.BehaviorSeriesMixin;
import com.nameless.indestructible.mixin.CombatBehaviorsMixin;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import com.nameless.indestructible.world.capability.Utils.IAnimationEventCapability;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileWeaponItem;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedCombatBehavior<T extends MobPatch<?>>
extends Behavior<Mob> {
    protected final T mobPatch;
    protected final CombatBehaviors<T> combatBehaviors;

    public AdvancedCombatBehavior(T mobPatch, CombatBehaviors<T> combatBehaviors) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT));
        this.mobPatch = mobPatch;
        this.combatBehaviors = combatBehaviors;
    }

    protected void tick(ServerLevel worldIn, Mob entityIn, long gameTimeIn) {
        boolean inaction;
        IAdvancedCapability iac = (IAdvancedCapability)this.mobPatch;
        boolean bl = inaction = iac.isBlocking() || iac.getInactionTime() > 0;
        if (this.mobPatch.getTarget() != null) {
            CombatBehaviors.Behavior result;
            EntityState state = this.mobPatch.getEntityState();
            this.combatBehaviors.tick();
            if (this.combatBehaviors.hasActivatedMove()) {
                CombatBehaviors.Behavior result2;
                if (iac.interrupted()) {
                    int count = ((CombatBehaviorsMixin)this.combatBehaviors).getCurrentBehaviorPointer();
                    CombatBehaviors.BehaviorSeries currentBehaviorSeries = ((CombatBehaviorsMixin)this.combatBehaviors).getBehaviorSeriesList().get(count);
                    ((BehaviorSeriesMixin)currentBehaviorSeries).setLoopFinished(true);
                    ((BehaviorSeriesMixin)currentBehaviorSeries).setNextBehaviorPointer(0);
                    iac.setInterrupted(false);
                    return;
                }
                if (state.canBasicAttack() && !inaction && (result2 = this.combatBehaviors.tryProceed()) != null) {
                    iac.setDamageSourceModifier(null);
                    iac.setBlocking(false);
                    iac.setAttackSpeed(1.0f);
                    iac.setHurtResistLevel(2);
                    T t = this.mobPatch;
                    if (t instanceof IAnimationEventCapability) {
                        IAnimationEventCapability iec = (IAnimationEventCapability)t;
                        iec.getEventManager().initActiveEvent();
                    }
                    result2.execute(this.mobPatch);
                }
            } else if (!state.inaction() && !inaction && (result = this.combatBehaviors.selectRandomBehaviorSeries()) != null) {
                iac.setDamageSourceModifier(null);
                iac.setBlocking(false);
                iac.setAttackSpeed(1.0f);
                iac.setHurtResistLevel(2);
                T t = this.mobPatch;
                if (t instanceof IAnimationEventCapability) {
                    IAnimationEventCapability iec = (IAnimationEventCapability)t;
                    iec.getEventManager().initActiveEvent();
                }
                result.execute(this.mobPatch);
            }
        }
    }

    protected boolean checkExtraStartConditions(ServerLevel levelIn, Mob entityIn) {
        return !this.isHoldingRangeWeapon(entityIn) && this.isValidTarget(this.mobPatch.getTarget());
    }

    protected boolean canStillUse(ServerLevel levelIn, Mob entityIn, long gameTimeIn) {
        return this.checkExtraStartConditions(levelIn, entityIn) && BehaviorUtils.m_22667_((LivingEntity)entityIn, (LivingEntity)this.mobPatch.getTarget()) && !this.mobPatch.getEntityState().hurt();
    }

    private boolean isHoldingRangeWeapon(Mob mob) {
        return mob.m_21093_(stack -> {
            Item item = stack.m_41720_();
            return item instanceof ProjectileWeaponItem && mob.m_5886_((ProjectileWeaponItem)item);
        });
    }

    protected boolean isValidTarget(LivingEntity attackTarget) {
        return attackTarget != null && attackTarget.m_6084_() && (!(attackTarget instanceof Player) || !attackTarget.m_5833_() && !((Player)attackTarget).m_7500_());
    }
}

