/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.ai.task;

import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class AdvancedChasingBehavior<T extends MobPatch<?>>
extends MoveToTargetSink {
    private final T mobPatch;
    protected final double attackRadiusSqr;
    private final double speed;

    public AdvancedChasingBehavior(T mobPatch, double speedModifier, double attackRadius) {
        super(150, 250);
        this.mobPatch = mobPatch;
        this.speed = speedModifier;
        this.attackRadiusSqr = attackRadius * attackRadius;
    }

    public boolean m_6114_(ServerLevel level, Mob mob) {
        return ((IAdvancedCapability)this.mobPatch).getStrafingTime() > 0 || super.m_6114_(level, mob);
    }

    protected boolean m_6737_(ServerLevel level, Mob mob, long gameTime) {
        if (super.m_6737_(level, mob, gameTime)) {
            MobPatch mobpatch = (MobPatch)EpicFightCapabilities.getEntityPatch((Entity)mob, MobPatch.class);
            return !mobpatch.getEntityState().inaction() && !this.withinDistance(mob);
        }
        return false;
    }

    private boolean withinDistance(Mob mob) {
        LivingEntity target = mob.m_5448_();
        if (target == null) {
            return false;
        }
        return this.attackRadiusSqr > mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
    }

    public void m_6725_(ServerLevel level, Mob mob, long p_23619_) {
        IAdvancedCapability iac = (IAdvancedCapability)this.mobPatch;
        LivingEntity target = mob.m_5448_();
        if (target == null) {
            return;
        }
        if (!this.mobPatch.getEntityState().turningLocked()) {
            mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        }
        if (this.mobPatch.getEntityState().movementLocked()) {
            return;
        }
        if (iac.getStrafingTime() > 0) {
            iac.setStrafingTime(iac.getStrafingTime() - 1);
            mob.m_21573_().m_26573_();
            mob.m_21391_((Entity)target, 30.0f, 30.0f);
            mob.m_21566_().m_24988_(this.withinDistance(mob) && iac.getStrafingForward() > 0.0f ? 0.0f : iac.getStrafingForward(), iac.getStrafingClockwise());
        } else if (((IAdvancedCapability)this.mobPatch).isBlocking()) {
            mob.m_21391_((Entity)target, 30.0f, 30.0f);
            mob.m_21573_().m_5624_((Entity)target, this.speed * (double)0.8f);
        } else {
            super.m_6725_(level, mob, p_23619_);
        }
    }
}

