/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.ai.goal;

import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ProjectileWeaponItem;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class GuardGoal<T extends MobPatch<?>>
extends Goal {
    private final T mobPatch;
    private final float radiusSqr;
    private int targetInactiontime = -1;

    public GuardGoal(T mobPatch, float radius) {
        this.mobPatch = mobPatch;
        this.radiusSqr = radius * radius;
    }

    public boolean m_8036_() {
        return this.checkTargetValid() && ((IAdvancedCapability)this.mobPatch).isBlocking();
    }

    public boolean m_8045_() {
        return this.m_8036_() && !this.targetInaction();
    }

    public void m_8056_() {
        super.m_8056_();
        this.targetInactiontime = -1;
        ((IAdvancedCapability)this.mobPatch).resetActionTick();
    }

    public void m_8041_() {
        IAdvancedCapability iac = (IAdvancedCapability)this.mobPatch;
        super.m_8041_();
        this.targetInactiontime = -1;
        iac.setBlocking(false);
        this.mobPatch.getAnimator().resetLivingAnimations();
    }

    private boolean checkTargetValid() {
        LivingEntity livingentity = this.mobPatch.getTarget();
        if (livingentity == null) {
            return false;
        }
        if (!livingentity.m_6084_()) {
            return false;
        }
        return !(livingentity instanceof Player) || !livingentity.m_5833_() && !((Player)livingentity).m_7500_();
    }

    private boolean withinDistance() {
        LivingEntity target = this.mobPatch.getTarget();
        return ((Mob)this.mobPatch.getOriginal()).m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_()) <= (double)this.radiusSqr;
    }

    private boolean targetInaction() {
        LivingEntityPatch target = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)this.mobPatch.getTarget(), LivingEntityPatch.class);
        if (target == null) {
            return true;
        }
        return this.targetInactiontime > ((IAdvancedCapability)this.mobPatch).getBlockTick();
    }

    public void m_8037_() {
        LivingEntityPatch targetPatch;
        LivingEntity target = this.mobPatch.getTarget();
        if (target != null && (targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target, LivingEntityPatch.class)) != null) {
            int phase = targetPatch.getEntityState().getLevel();
            this.targetInactiontime = this.withinDistance() && phase > 0 && phase < 3 ? 0 : (((IAdvancedCapability)this.mobPatch).canBlockProjectile() && target.m_21211_().m_41720_() instanceof ProjectileWeaponItem && target.m_6117_() ? 0 : ++this.targetInactiontime);
        }
    }
}

