/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.ai.CombatBehaviors;

import com.google.common.collect.Lists;
import com.nameless.indestructible.data.conditions.CustomPhase;
import com.nameless.indestructible.data.conditions.SelfStamina;
import com.nameless.indestructible.data.conditions.TargetIsGuardBreak;
import com.nameless.indestructible.data.conditions.TargetIsKnockDown;
import com.nameless.indestructible.data.conditions.TargetIsUsingItem;
import com.nameless.indestructible.data.conditions.TargetWithinState;
import com.nameless.indestructible.main.Indestructible;
import com.nameless.indestructible.world.ai.CombatBehaviors.AnimationMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.GuardMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.WanderMotionSet;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import dev.latvian.mods.kubejs.typings.Info;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.entity.CustomCondition;
import yesman.epicfight.data.conditions.entity.HealthPoint;
import yesman.epicfight.data.conditions.entity.RandomChance;
import yesman.epicfight.data.conditions.entity.TargetInDistance;
import yesman.epicfight.data.conditions.entity.TargetInEyeHeight;
import yesman.epicfight.data.conditions.entity.TargetInPov;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.network.server.SPAnimatorControl;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedBehaviorBuilder<T extends MobPatch<?>>
extends CombatBehaviors.Behavior.Builder<T> {
    private final List<Consumer<T>> behaviorList = Lists.newArrayList();
    private LivingEntityPatch.ServerAnimationPacketProvider packetProvider = SPAnimatorControl::new;

    public static AdvancedBehaviorBuilder<?> Builder() {
        return new AdvancedBehaviorBuilder();
    }

    @Info(value="add animation motion set to the To-be-executed list, call process() later to fulfill it, call AnimationMotionSet.create() to create an Animation motion set, and call method in it to define its properties")
    public AdvancedBehaviorBuilder<T> tryProcessAnimationSet(AnimationMotionSet set) {
        Consumer<MobPatch> c = mobPatch -> {
            if (mobPatch instanceof IAdvancedCapability) {
                IAdvancedCapability iac = (IAdvancedCapability)mobPatch;
                iac.actAnimationMotion(set, this.packetProvider);
            }
        };
        this.behaviorList.add(c);
        return this;
    }

    @Info(value="add guard motion set to the To-be-executed list, call process() later to fulfill it, call GuardMotionSet.create() to create a guard motion set, and call method in it to define its properties")
    public AdvancedBehaviorBuilder<T> tryProcessGuardMotion(GuardMotionSet set) {
        Consumer<MobPatch> c = mobPatch -> {
            if (mobPatch instanceof IAdvancedCapability) {
                IAdvancedCapability iac = (IAdvancedCapability)mobPatch;
                iac.actGuardMotion(set);
            }
        };
        this.behaviorList.add(c);
        return this;
    }

    @Info(value="add wander motion set to the To-be-executed list, call process() later to fulfill it, call WanderMotionSet.create() to create a wander motion set, and call method in it to define its properties")
    public AdvancedBehaviorBuilder<T> tryProcessWanderSet(WanderMotionSet set) {
        Consumer<MobPatch> c = mobPatch -> {
            if (mobPatch instanceof IAdvancedCapability) {
                IAdvancedCapability iac = (IAdvancedCapability)mobPatch;
                iac.actStrafing(set);
            }
        };
        this.behaviorList.add(c);
        return this;
    }

    @Info(value="add behavior of setting entity phase to the To-be-executed list, call process() later to fulfill it")
    public AdvancedBehaviorBuilder<T> tryProcessSetPhase(int phase) {
        Consumer<MobPatch> c = mobPatch -> {
            if (mobPatch instanceof IAdvancedCapability) {
                IAdvancedCapability iac = (IAdvancedCapability)mobPatch;
                iac.setPhase(phase);
            }
        };
        this.behaviorList.add(c);
        return this;
    }

    @Info(value="add behavior of setting entity hurtResist level to the To-be-executed list, call process() later to fulfill it")
    public AdvancedBehaviorBuilder<T> tryProcessSetHurtResistLevel(int level) {
        Consumer<MobPatch> c = mobPatch -> {
            if (mobPatch instanceof IAdvancedCapability) {
                IAdvancedCapability iac = (IAdvancedCapability)mobPatch;
                iac.setHurtResistLevel(level);
            }
        };
        this.behaviorList.add(c);
        return this;
    }

    @Info(value="add behavior of playing animation to the To-be-executed list which , call process() later to fulfill it")
    public AdvancedBehaviorBuilder<T> tryProcessAnimation(Object object) {
        AnimationManager.AnimationAccessor animation;
        if (object instanceof AnimationManager.AnimationAccessor) {
            AnimationManager.AnimationAccessor a;
            animation = a = (AnimationManager.AnimationAccessor)object;
        } else if (object instanceof String) {
            String s = (String)object;
            animation = AnimationManager.byKey((String)s);
        } else {
            animation = Animations.EMPTY_ANIMATION;
            Indestructible.LOGGER.warn(object + " can't be recognized");
        }
        Consumer<MobPatch> c = mobPatch -> mobPatch.playAnimationSynchronized((AssetAccessor)animation, 0.0f);
        this.behaviorList.add(c);
        return this;
    }

    @Info(value="add custom behavior to the To-be-executed list which , call process() later to fulfill it")
    public AdvancedBehaviorBuilder<T> tryProcessCustomBehavior(Consumer<T> behavior) {
        this.behaviorList.add(behavior);
        return this;
    }

    public void process() {
        Consumer<MobPatch> c = mobPatch -> this.behaviorList.forEach(b -> b.accept(mobPatch));
        this.behavior((Consumer)c);
    }

    @Info(value="behavior of playing animation")
    public AdvancedBehaviorBuilder<T> animationBehavior(Object object) {
        AnimationManager.AnimationAccessor animation;
        if (object instanceof AnimationManager.AnimationAccessor) {
            AnimationManager.AnimationAccessor a;
            animation = a = (AnimationManager.AnimationAccessor)object;
        } else if (object instanceof String) {
            String s = (String)object;
            animation = AnimationManager.byKey((String)s);
        } else {
            animation = Animations.EMPTY_ANIMATION;
            Indestructible.LOGGER.warn(object + " can't be recognized");
        }
        this.animationBehavior(animation);
        return this;
    }

    @Info(value="custom behavior")
    public AdvancedBehaviorBuilder<T> behavior(Consumer<T> behavior) {
        return (AdvancedBehaviorBuilder)super.behavior(behavior);
    }

    @Info(value="empty behavior")
    public AdvancedBehaviorBuilder<T> emptyBehavior() {
        return (AdvancedBehaviorBuilder)super.emptyBehavior();
    }

    @Info(value="behavior of playing animation, only allow instance of animation as parameter")
    public AdvancedBehaviorBuilder<T> animationBehavior(AnimationManager.AnimationAccessor<? extends StaticAnimation> motion) {
        return (AdvancedBehaviorBuilder)super.animationBehavior(motion);
    }

    @Info(value="condition of entity within current phase")
    public AdvancedBehaviorBuilder<T> withinPhase(int minLevel, int maxLevel) {
        this.condition(new CustomPhase(minLevel, maxLevel));
        return this;
    }

    @Info(value="condition of entity's health in current state")
    public AdvancedBehaviorBuilder<T> health(float health, Object object) {
        HealthPoint.Comparator comparator = null;
        if (object instanceof HealthPoint.Comparator) {
            HealthPoint.Comparator c;
            comparator = c = (HealthPoint.Comparator)object;
        } else if (object instanceof String) {
            String s = (String)object;
            comparator = HealthPoint.Comparator.valueOf((String)s.toUpperCase(Locale.ROOT));
        } else {
            Indestructible.LOGGER.warn(object + " can't be recognized");
        }
        this.condition((Condition)new HealthPoint(health, comparator));
        return this;
    }

    @Info(value="condition of entity's stamina in current state")
    public AdvancedBehaviorBuilder<T> stamina(float stamina, Object object) {
        HealthPoint.Comparator comparator = null;
        if (object instanceof HealthPoint.Comparator) {
            HealthPoint.Comparator c;
            comparator = c = (HealthPoint.Comparator)object;
        } else if (object instanceof String) {
            String s = (String)object;
            comparator = HealthPoint.Comparator.valueOf((String)s.toUpperCase(Locale.ROOT));
        } else {
            Indestructible.LOGGER.warn(object + " can't be recognized");
        }
        this.condition((Condition)new SelfStamina(stamina, comparator));
        return this;
    }

    @Info(value="condition of entity's target is neutralized")
    public AdvancedBehaviorBuilder<T> targetIsGuardBreak(boolean invert) {
        this.condition(new TargetIsGuardBreak(invert));
        return this;
    }

    @Info(value="condition of entity's target is knockdown")
    public AdvancedBehaviorBuilder<T> targetIsKnockDown(boolean invert) {
        this.condition(new TargetIsKnockDown(invert));
        return this;
    }

    @Info(value="condition of entity's target is using item")
    public AdvancedBehaviorBuilder<T> targetIsUsingItem(boolean isEdible) {
        this.condition(new TargetIsUsingItem(isEdible));
        return this;
    }

    @Info(value="condition of entity's target is in current attack phase")
    public AdvancedBehaviorBuilder<T> targetAttackPhase(int minLevel, int maxLevel) {
        this.condition(new TargetWithinState(minLevel, maxLevel));
        return this;
    }

    @Info(value="condition of y distance of the entity's target is smaller than entity's eye height")
    public AdvancedBehaviorBuilder<T> withinEyeHeight() {
        this.condition((Condition)new TargetInEyeHeight());
        return this;
    }

    @Info(value="condition of random value is higher than the given argument")
    public AdvancedBehaviorBuilder<T> randomChance(float chance) {
        this.condition((Condition)new RandomChance(chance));
        return this;
    }

    @Info(value="condition of the distance between target and entity are within the given arguments")
    public AdvancedBehaviorBuilder<T> withinDistance(double minDistance, double maxDistance) {
        this.condition((Condition)new TargetInDistance(minDistance, maxDistance));
        return this;
    }

    @Info(value="condition of entity's angle towards target is within the given arguments")
    public AdvancedBehaviorBuilder<T> withinAngle(double minDegree, double maxDegree) {
        this.condition((Condition)new TargetInPov(minDegree, maxDegree));
        return this;
    }

    @Info(value="condition of entity's Y-axis angle towards target is within the given arguments")
    public AdvancedBehaviorBuilder<T> withinAngleHorizontal(double minDegree, double maxDegree) {
        this.condition((Condition)new TargetInPov.TargetInPovHorizontal(minDegree, maxDegree));
        return this;
    }

    public AdvancedBehaviorBuilder<T> health(float health, HealthPoint.Comparator comparator) {
        this.condition((Condition)new HealthPoint(health, comparator));
        return this;
    }

    @Info(value="custom condition, Function<T extend MobPatch, Boolean>")
    public AdvancedBehaviorBuilder<T> custom(Function<T, Boolean> customPredicate) {
        this.condition((Condition)new CustomCondition(customPredicate));
        return this;
    }

    @Info(value="custom condition, condition<T extend MobPatch> instance")
    public AdvancedBehaviorBuilder<T> predicate(Condition<T> predicate) {
        return (AdvancedBehaviorBuilder)super.predicate(predicate);
    }

    public AdvancedBehaviorBuilder<T> packetProvider(LivingEntityPatch.ServerAnimationPacketProvider packetProvider) {
        this.packetProvider = packetProvider;
        return this;
    }
}

