/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.main;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.nameless.indestructible.client.UIConfig;
import com.nameless.indestructible.client.gui.AdvanceHealthBar;
import com.nameless.indestructible.client.gui.BossBarGUi;
import com.nameless.indestructible.command.AHPatchPlayAnimationCommand;
import com.nameless.indestructible.command.AHPatchSetLookAtCommand;
import com.nameless.indestructible.command.AHPatchSetPhaseCommand;
import com.nameless.indestructible.data.AdvancedMobpatchReloader;
import com.nameless.indestructible.data.ExtraConditions;
import com.nameless.indestructible.gameasset.GuardAnimations;
import com.nameless.indestructible.server.CommonConfig;
import com.nameless.indestructible.server.network.SPCancelBossInfo;
import com.nameless.indestructible.server.network.SPDatapackSync;
import com.nameless.indestructible.world.capability.Utils.IBossEventCapability;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

@Mod(value="indestructible")
public class Indestructible {
    public static final String MOD_ID = "indestructible";
    public static final Logger LOGGER = LogManager.getLogger((String)"indestructible");
    public static AnimationManager.AnimationAccessor<?>[] NEUTRALIZE_ANIMATIONS;
    public static final ResourceLocation BOSS_BAR;

    public Indestructible(FMLJavaModLoadingContext context) {
        IEventBus bus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)UIConfig.SPEC);
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.SPEC);
        ExtraConditions.CONDITIONS.register(bus);
        bus.addListener(GuardAnimations::registerAnimations);
        bus.addListener(this::doCommonStuff);
        bus.addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOW, this::reloadListnerEvent);
        MinecraftForge.EVENT_BUS.addListener(this::onDatapackSync);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::stopTrackingEvent);
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        EpicFightNetworkManager.INSTANCE.registerMessage(99, SPDatapackSync.class, SPDatapackSync::toBytes, SPDatapackSync::fromBytes, SPDatapackSync::handle);
        EpicFightNetworkManager.INSTANCE.registerMessage(98, SPCancelBossInfo.class, SPCancelBossInfo::toBytes, SPCancelBossInfo::fromBytes, SPCancelBossInfo::handle);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        EntityUI.ENTITY_UI_LIST.add(AdvanceHealthBar.Instance);
        MinecraftForge.EVENT_BUS.register((Object)new BossBarGUi());
        BossBarGUi.cancelBossBar.addAll((Collection)UIConfig.BOSS_NAME.get());
    }

    private void reloadListnerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new AdvancedMobpatchReloader());
        AnimationManager.AnimationAccessor[] providers = new AnimationManager.AnimationAccessor[((List)CommonConfig.NEUTRALIZE_ANIMATION.get()).size()];
        for (int i = 0; i < ((List)CommonConfig.NEUTRALIZE_ANIMATION.get()).size(); ++i) {
            ResourceLocation rl = ResourceLocation.parse((String)((String)((List)CommonConfig.NEUTRALIZE_ANIMATION.get()).get(i)));
            providers[i] = AnimationManager.byKey((ResourceLocation)rl);
        }
        NEUTRALIZE_ANIMATIONS = providers;
    }

    private void onDatapackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player != null) {
            if (!player.m_20194_().m_7779_(player.m_36316_())) {
                SPDatapackSync mobPatchPacket = new SPDatapackSync(AdvancedMobpatchReloader.getTagCount());
                AdvancedMobpatchReloader.getDataStream().forEach(mobPatchPacket::write);
                EpicFightNetworkManager.sendToPlayer((Object)mobPatchPacket, (ServerPlayer)player, (Object[])new Object[0]);
            }
        } else {
            event.getPlayerList().m_11314_().forEach(serverPlayer -> {
                SPDatapackSync mobPatchPacket = new SPDatapackSync(AdvancedMobpatchReloader.getTagCount());
                AdvancedMobpatchReloader.getDataStream().forEach(mobPatchPacket::write);
                EpicFightNetworkManager.sendToPlayer((Object)mobPatchPacket, (ServerPlayer)serverPlayer, (Object[])new Object[0]);
            });
        }
    }

    private void registerCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MOD_ID).requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"living_entity", (ArgumentType)EntityArgument.m_91449_()).then(AHPatchSetPhaseCommand.register())).then(AHPatchSetLookAtCommand.register())).then(AHPatchPlayAnimationCommand.register())));
    }

    private void stopTrackingEvent(PlayerEvent.StopTracking event) {
        Entity trackingTarget = event.getTarget();
        MobPatch mobPatch = (MobPatch)EpicFightCapabilities.getEntityPatch((Entity)trackingTarget, MobPatch.class);
        if (mobPatch instanceof IBossEventCapability) {
            IBossEventCapability ibc = (IBossEventCapability)mobPatch;
            ibc.onStopTracking(event.getEntity());
        }
    }

    static {
        BOSS_BAR = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"textures/gui/boss_bar.png");
    }
}

