/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.data.conditions;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class TargetWithinState
implements Condition<LivingEntityPatch<?>> {
    private int minLevel;
    private int maxLevel;

    public TargetWithinState(int minLevel, int maxLevel) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public TargetWithinState() {
    }

    public TargetWithinState read(CompoundTag tag) {
        if (!tag.m_128441_("min")) {
            throw new IllegalArgumentException("attack level condition error: min distance not specified!");
        }
        if (!tag.m_128441_("max")) {
            throw new IllegalArgumentException("attack level condition error: max distance not specified!");
        }
        this.minLevel = tag.m_128451_("min");
        this.maxLevel = tag.m_128451_("max");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("min", this.minLevel);
        tag.m_128405_("max", this.maxLevel);
        return tag;
    }

    public boolean predicate(LivingEntityPatch<?> target) {
        LivingEntityPatch tartgetpatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)target.getTarget(), LivingEntityPatch.class);
        if (tartgetpatch == null) {
            return false;
        }
        int level = tartgetpatch.getEntityState().getLevel();
        return this.minLevel <= level && level <= this.maxLevel;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

