/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.data.conditions;

import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.utils.ParseUtil;
import yesman.epicfight.client.gui.datapack.widgets.ComboBox;
import yesman.epicfight.client.gui.datapack.widgets.ResizableEditBox;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.data.conditions.entity.HealthPoint;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class SelfStamina
extends Condition.EntityPatchCondition {
    private float value;
    private HealthPoint.Comparator comparator;

    public SelfStamina() {
    }

    public SelfStamina(float stamina, HealthPoint.Comparator comparator) {
        this.value = stamina;
        this.comparator = comparator;
    }

    public SelfStamina read(CompoundTag tag) {
        if (!tag.m_128441_("comparator")) {
            throw new IllegalArgumentException("stamina condition error: comparator not specified!");
        }
        if (!tag.m_128441_("stamina")) {
            throw new IllegalArgumentException("stamina condition error: health not specified!");
        }
        String sComparator = tag.m_128461_("comparator").toUpperCase(Locale.ROOT);
        try {
            this.comparator = HealthPoint.Comparator.valueOf((String)sComparator);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("stamina condition error: invalid comparator " + sComparator);
        }
        this.value = tag.m_128457_("stamina");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("comparator", this.comparator.toString().toLowerCase(Locale.ROOT));
        tag.m_128350_("stamina", this.value);
        return tag;
    }

    public boolean predicate(LivingEntityPatch<?> self) {
        if (!(self instanceof IAdvancedCapability)) {
            return true;
        }
        IAdvancedCapability iac = (IAdvancedCapability)self;
        float stamina = iac.getStamina();
        float maxstamina = iac.getMaxStamina();
        return switch (this.comparator) {
            default -> throw new IncompatibleClassChangeError();
            case HealthPoint.Comparator.LESS_ABSOLUTE -> {
                if (this.value > stamina) {
                    yield true;
                }
                yield false;
            }
            case HealthPoint.Comparator.GREATER_ABSOLUTE -> {
                if (this.value < stamina) {
                    yield true;
                }
                yield false;
            }
            case HealthPoint.Comparator.LESS_RATIO -> {
                if (this.value > stamina / maxstamina) {
                    yield true;
                }
                yield false;
            }
            case HealthPoint.Comparator.GREATER_RATIO -> this.value < stamina / maxstamina;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        ResizableEditBox editbox = new ResizableEditBox(screen.getMinecraft().f_91062_, 0, 0, 0, 0, (Component)Component.m_237113_((String)"Don't use this"), null, null);
        ComboBox comboBox = new ComboBox(screen, screen.getMinecraft().f_91062_, 0, 0, 0, 0, null, null, 4, (Component)Component.m_237113_((String)"in here"), List.of(HealthPoint.Comparator.values()), ParseUtil::snakeToSpacedCamel, null);
        editbox.m_94153_(context -> StringUtil.isNullOrEmpty((String)context) || ParseUtil.isParsable((String)context, Float::parseFloat));
        return List.of(Condition.ParameterEditor.of(value -> FloatTag.m_128566_((float)Float.parseFloat(value.toString())), tag -> ParseUtil.valueOfOmittingType((Object)ParseUtil.nullOrToString((Object)tag, Tag::m_7916_)), (AbstractWidget)editbox), Condition.ParameterEditor.of(value -> StringTag.m_129297_((String)value.toString().toLowerCase(Locale.ROOT)), tag -> ParseUtil.enumValueOfOrNull(HealthPoint.Comparator.class, (String)ParseUtil.nullOrToString((Object)tag, Tag::m_7916_)), (AbstractWidget)comboBox));
    }
}

