/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.data.conditions;

import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class CustomPhase
implements Condition<LivingEntityPatch<?>> {
    private int minLevel;
    private int maxLevel;

    public CustomPhase(int minLevel, int maxLevel) {
        this.minLevel = minLevel;
        this.maxLevel = maxLevel;
    }

    public CustomPhase() {
    }

    public CustomPhase read(CompoundTag tag) {
        if (!tag.m_128441_("min")) {
            throw new IllegalArgumentException("custom phase condition error: min distance not specified!");
        }
        if (!tag.m_128441_("max")) {
            throw new IllegalArgumentException("custom phase condition error: max distance not specified!");
        }
        this.minLevel = tag.m_128451_("min");
        this.maxLevel = tag.m_128451_("max");
        return this;
    }

    public CompoundTag serializePredicate() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("min", this.minLevel);
        tag.m_128405_("max", this.maxLevel);
        return tag;
    }

    public boolean predicate(LivingEntityPatch<?> target) {
        if (target instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)target;
            int phase = iac.getPhase();
            return this.minLevel <= phase && phase <= this.maxLevel;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Condition.ParameterEditor> getAcceptingParameters(Screen screen) {
        return null;
    }
}

