/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.nameless.indestructible.api.animation.types.LivingEntityPatchEvent;
import com.nameless.indestructible.compat.kubejs.JsEventInstance;
import com.nameless.indestructible.gameasset.GuardAnimations;
import com.nameless.indestructible.main.Indestructible;
import com.nameless.indestructible.server.network.SPDatapackSync;
import com.nameless.indestructible.world.ai.CombatBehaviors.AdvancedBehaviorBuilder;
import com.nameless.indestructible.world.ai.CombatBehaviors.AnimationMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.CounterMotion;
import com.nameless.indestructible.world.ai.CombatBehaviors.DamageSourceModifier;
import com.nameless.indestructible.world.ai.CombatBehaviors.GuardMotion;
import com.nameless.indestructible.world.ai.CombatBehaviors.GuardMotionSet;
import com.nameless.indestructible.world.ai.CombatBehaviors.WanderMotionSet;
import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import com.nameless.indestructible.world.capability.AdvancedCustomMobPatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.collider.MultiOBBCollider;
import yesman.epicfight.api.collider.OBBCollider;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.data.conditions.Condition;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.main.EpicFightSharedConstants;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.Factions;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedMobpatchReloader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<EntityType<?>, CompoundTag> TAGMAP = Maps.newHashMap();
    private static final Map<EntityType<?>, MobPatchReloadListener.AbstractMobPatchProvider> ADVANCED_MOB_PATCH_PROVIDERS = Maps.newHashMap();

    public static void addProvider(EntityType<?> entityType, MobPatchReloadListener.AbstractMobPatchProvider provider) {
        ADVANCED_MOB_PATCH_PROVIDERS.put(entityType, provider);
        EntityPatchProvider.putCustomEntityPatch(entityType, entity -> () -> ADVANCED_MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get(entity));
    }

    public static void addClientTag(EntityType<?> entityType, CompoundTag tag) {
        TAGMAP.put(entityType, tag);
    }

    public AdvancedMobpatchReloader() {
        super(GSON, "advanced_mobpatch");
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager resourceManager, ProfilerFiller profileIn) {
        ADVANCED_MOB_PATCH_PROVIDERS.clear();
        TAGMAP.clear();
        return super.m_5944_(resourceManager, profileIn);
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String pathString = rl.m_135815_();
            ResourceLocation registryName = ResourceLocation.fromNamespaceAndPath((String)rl.m_135827_(), (String)pathString);
            if (!ForgeRegistries.ENTITY_TYPES.containsKey(registryName)) {
                Indestructible.LOGGER.warn("[Custom Entity] Entity named " + registryName + " does not exist");
                continue;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(registryName);
            CompoundTag tag = null;
            try {
                tag = TagParser.m_129359_((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                Indestructible.LOGGER.warn("Error while deserializing datapack for {}: {}", (Object)registryName, (Object)e.getLocalizedMessage());
                continue;
            }
            MobPatchReloadListener.AbstractMobPatchProvider abstractMobpatchProvider = null;
            try {
                abstractMobpatchProvider = AdvancedMobpatchReloader.deserializePatchProvider(entityType, tag, false, resourceManagerIn);
            }
            catch (Exception e) {
                Indestructible.LOGGER.warn("Can't deserialize mob capability: {}: {}", (Object)registryName, (Object)e.getLocalizedMessage());
                continue;
            }
            AdvancedMobpatchReloader.addProvider(entityType, abstractMobpatchProvider);
            TAGMAP.put(entityType, AdvancedMobpatchReloader.filterClientData(tag));
            if (!EpicFightSharedConstants.isPhysicalClient()) continue;
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128441_("preset") ? tag.m_128461_("preset") : tag.m_128461_("renderer"), tag);
        }
        if (ModList.get().isLoaded("kubejs")) {
            JsEventInstance.load();
        }
    }

    public static MobPatchReloadListener.AbstractMobPatchProvider deserializePatchProvider(EntityType<?> entityType, CompoundTag tag, boolean clientSide, ResourceManager resourceManager) {
        boolean humanoid = tag.m_128471_("isHumanoid");
        return humanoid ? AdvancedMobpatchReloader.deserializeHumaniodMobPatchProvider(entityType, tag, clientSide, resourceManager) : AdvancedMobpatchReloader.deserializeMobPatchProvider(entityType, tag, clientSide, resourceManager);
    }

    public static AdvancedCustomMobPatchProvider deserializeMobPatchProvider(EntityType<?> entityType, CompoundTag tag, boolean clientSide, ResourceManager resourceManager) {
        AdvancedCustomMobPatchProvider provider = new AdvancedCustomMobPatchProvider();
        provider.attributeValues = AdvancedMobpatchReloader.deserializeAdvancedAttributes(tag.m_128469_("attributes"));
        ResourceLocation modelLocation = ResourceLocation.parse((String)tag.m_128461_("model"));
        ResourceLocation armatureLocation = ResourceLocation.parse((String)tag.m_128461_("armature"));
        if (EpicFightSharedConstants.isPhysicalClient()) {
            Meshes.getOrCreate((ResourceLocation)modelLocation, jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(SkinnedMesh::new));
            provider.name = tag.m_128441_("boss_bar") && tag.m_128441_("custom_name") ? tag.m_128461_("custom_name") : null;
            provider.bossBar = tag.m_128441_("boss_bar") && tag.m_128441_("custom_texture") ? ResourceLocation.m_135820_((String)tag.m_128461_("custom_texture")) : null;
        }
        Armatures.registerEntityTypeArmature(entityType, (AssetAccessor)Armatures.getOrCreate((ResourceLocation)armatureLocation, Armature::new));
        provider.hasBossBar = tag.m_128441_("boss_bar") && tag.m_128471_("boss_bar");
        provider.defaultAnimations = MobPatchReloadListener.deserializeDefaultAnimations((CompoundTag)tag.m_128469_("default_livingmotions"));
        provider.faction = (Faction)Faction.ENUM_MANAGER.getOrThrow(tag.m_128461_("faction"));
        provider.scale = tag.m_128469_("attributes").m_128441_("scale") ? (float)tag.m_128469_("attributes").m_128459_("scale") : 1.0f;
        float f = provider.maxStunShield = tag.m_128469_("attributes").m_128441_("max_stun_shield") ? (float)tag.m_128469_("attributes").m_128459_("max_stun_shield") : 0.0f;
        if (tag.m_128441_("swing_sound")) {
            provider.swingSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)tag.m_128461_("swing_sound")));
        }
        if (tag.m_128441_("hit_sound")) {
            provider.hitSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)tag.m_128461_("hit_sound")));
        }
        if (tag.m_128441_("hit_particle")) {
            provider.hitParticle = (HitParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ResourceLocation.parse((String)tag.m_128461_("hit_particle")));
        }
        if (!clientSide) {
            provider.stunAnimations = MobPatchReloadListener.deserializeStunAnimations((CompoundTag)tag.m_128469_("stun_animations"));
            provider.chasingSpeed = tag.m_128469_("attributes").m_128459_("chasing_speed");
            provider.defaultGuardMotion = AdvancedMobpatchReloader.deserializeGuardMotions(tag.m_128469_("custom_guard_motion"));
            provider.combatBehaviorsBuilder = AdvancedMobpatchReloader.deserializeAdvancedBehaviorsBuilder(tag.m_128437_("combat_behavior", 10));
            provider.regenStaminaStandbyTime = tag.m_128469_("attributes").m_128441_("stamina_regan_delay") ? tag.m_128469_("attributes").m_128451_("stamina_regan_delay") : 30;
            provider.hasStunReduction = !tag.m_128469_("attributes").m_128441_("has_stun_reduction") || tag.m_128469_("attributes").m_128471_("has_stun_reduction");
            provider.reganShieldStandbyTime = tag.m_128469_("attributes").m_128441_("stun_shield_regan_delay") ? tag.m_128469_("attributes").m_128451_("stun_shield_regan_delay") : 30;
            provider.reganShieldMultiply = tag.m_128469_("attributes").m_128441_("stun_shield_regan_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stun_shield_regan_multiply") : 1.0f;
            provider.staminaLoseMultiply = tag.m_128469_("attributes").m_128441_("stamina_lose_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stamina_lose_multiply") : 0.0f;
            provider.attackRadius = tag.m_128469_("attributes").m_128441_("attack_radius") ? (float)tag.m_128469_("attributes").m_128459_("attack_radius") : 1.5f;
            provider.guardRadius = tag.m_128469_("attributes").m_128441_("guard_radius") ? (float)tag.m_128469_("attributes").m_128459_("guard_radius") : 3.0f;
            provider.stunEvent = AdvancedMobpatchReloader.deserializeStunCommandList(tag.m_128437_("stun_command_list", 10));
        }
        return provider;
    }

    public static AdvancedCustomHumanoidMobPatchProvider deserializeHumaniodMobPatchProvider(EntityType<?> entityType, CompoundTag tag, boolean clientSide, ResourceManager resourceManager) {
        AdvancedCustomHumanoidMobPatchProvider provider = new AdvancedCustomHumanoidMobPatchProvider();
        provider.attributeValues = AdvancedMobpatchReloader.deserializeAdvancedAttributes(tag.m_128469_("attributes"));
        ResourceLocation modelLocation = ResourceLocation.parse((String)tag.m_128461_("model"));
        ResourceLocation armatureLocation = ResourceLocation.parse((String)tag.m_128461_("armature"));
        if (EpicFightSharedConstants.isPhysicalClient()) {
            Meshes.getOrCreate((ResourceLocation)modelLocation, jsonAssetLoader -> jsonAssetLoader.loadSkinnedMesh(SkinnedMesh::new));
            provider.name = tag.m_128441_("boss_bar") && tag.m_128441_("custom_name") ? tag.m_128461_("custom_name") : null;
            provider.bossBar = tag.m_128441_("boss_bar") && tag.m_128441_("custom_texture") ? ResourceLocation.m_135820_((String)tag.m_128461_("custom_texture")) : null;
        }
        Armatures.registerEntityTypeArmature(entityType, (AssetAccessor)Armatures.getOrCreate((ResourceLocation)armatureLocation, Armature::new));
        provider.hasBossBar = tag.m_128441_("boss_bar") && tag.m_128471_("boss_bar");
        provider.defaultAnimations = MobPatchReloadListener.deserializeDefaultAnimations((CompoundTag)tag.m_128469_("default_livingmotions"));
        provider.faction = (Faction)Faction.ENUM_MANAGER.getOrThrow(tag.m_128461_("faction"));
        float f = provider.scale = tag.m_128469_("attributes").m_128441_("scale") ? (float)tag.m_128469_("attributes").m_128459_("scale") : 1.0f;
        if (tag.m_128441_("swing_sound")) {
            provider.swingSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)tag.m_128461_("swing_sound")));
        }
        if (tag.m_128441_("hit_sound")) {
            provider.hitSound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(ResourceLocation.parse((String)tag.m_128461_("hit_sound")));
        }
        if (tag.m_128441_("hit_particle")) {
            provider.hitParticle = (HitParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(ResourceLocation.parse((String)tag.m_128461_("hit_particle")));
        }
        if (!clientSide) {
            provider.stunAnimations = MobPatchReloadListener.deserializeStunAnimations((CompoundTag)tag.m_128469_("stun_animations"));
            provider.chasingSpeed = tag.m_128469_("attributes").m_128459_("chasing_speed");
            provider.AHCombatBehaviors = AdvancedMobpatchReloader.deserializeAdvancedHumanoidCombatBehaviors(tag.m_128437_("combat_behavior", 10));
            provider.AHWeaponMotions = MobPatchReloadListener.deserializeHumanoidWeaponMotions((ListTag)tag.m_128437_("humanoid_weapon_motions", 10));
            provider.guardMotions = AdvancedMobpatchReloader.deserializeHumanoidGuardMotions(tag.m_128437_("custom_guard_motion", 10));
            provider.regenStaminaStandbyTime = tag.m_128469_("attributes").m_128441_("stamina_regan_delay") ? tag.m_128469_("attributes").m_128451_("stamina_regan_delay") : 30;
            provider.hasStunReduction = !tag.m_128469_("attributes").m_128441_("has_stun_reduction") || tag.m_128469_("attributes").m_128471_("has_stun_reduction");
            provider.maxStunShield = tag.m_128469_("attributes").m_128441_("max_stun_shield") ? (float)tag.m_128469_("attributes").m_128459_("max_stun_shield") : 0.0f;
            provider.reganShieldStandbyTime = tag.m_128469_("attributes").m_128441_("stun_shield_regan_delay") ? tag.m_128469_("attributes").m_128451_("stun_shield_regan_delay") : 30;
            provider.reganShieldMultiply = tag.m_128469_("attributes").m_128441_("stun_shield_regan_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stun_shield_regan_multiply") : 1.0f;
            provider.staminaLoseMultiply = tag.m_128469_("attributes").m_128441_("stamina_lose_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stamina_lose_multiply") : 0.0f;
            provider.attackRadius = tag.m_128469_("attributes").m_128441_("attack_radius") ? (float)tag.m_128469_("attributes").m_128459_("attack_radius") : 1.5f;
            provider.guardRadius = tag.m_128469_("attributes").m_128441_("guard_radius") ? (float)tag.m_128469_("attributes").m_128459_("guard_radius") : 3.0f;
            provider.stunEvent = AdvancedMobpatchReloader.deserializeStunCommandList(tag.m_128437_("stun_command_list", 10));
        }
        return provider;
    }

    public static CompoundTag filterClientData(CompoundTag tag) {
        CompoundTag clientTag = new CompoundTag();
        return AdvancedMobpatchReloader.extractBranch(clientTag, tag);
    }

    public static CompoundTag extractBranch(CompoundTag extract, CompoundTag original) {
        extract.m_128365_("model", original.m_128423_("model"));
        extract.m_128365_("armature", original.m_128423_("armature"));
        extract.m_128379_("isHumanoid", original.m_128441_("isHumanoid") ? original.m_128471_("isHumanoid") : false);
        extract.m_128365_("renderer", original.m_128423_("renderer"));
        extract.m_128365_("faction", original.m_128423_("faction"));
        extract.m_128365_("default_livingmotions", original.m_128423_("default_livingmotions"));
        extract.m_128365_("attributes", original.m_128423_("attributes"));
        if (original.m_128441_("boss_bar")) {
            extract.m_128365_("boss_bar", original.m_128423_("boss_bar"));
            if (original.m_128441_("custom_name")) {
                extract.m_128365_("custom_name", original.m_128423_("custom_name"));
            }
            if (original.m_128441_("custom_texture")) {
                extract.m_128365_("custom_texture", original.m_128423_("custom_texture"));
            }
        }
        return extract;
    }

    public static Stream<CompoundTag> getDataStream() {
        Stream<CompoundTag> tagStream = TAGMAP.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).m_128359_("id", ForgeRegistries.ENTITY_TYPES.getKey((Object)((EntityType)entry.getKey())).toString());
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static int getTagCount() {
        return TAGMAP.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        for (CompoundTag tag : packet.getTags()) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(ResourceLocation.parse((String)tag.m_128461_("id")));
            ADVANCED_MOB_PATCH_PROVIDERS.put(entityType, AdvancedMobpatchReloader.deserializePatchProvider(entityType, tag, true, Minecraft.m_91087_().m_91098_()));
            EntityPatchProvider.putCustomEntityPatch((EntityType)entityType, entity -> () -> ADVANCED_MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get(entity));
            ResourceLocation armatureLocation = ResourceLocation.parse((String)tag.m_128461_("armature"));
            boolean humanoid = tag.m_128471_("isHumanoid");
            AssetAccessor armature = Armatures.getOrCreate((ResourceLocation)armatureLocation, (Armatures.ArmatureContructor)(humanoid ? Armature::new : HumanoidArmature::new));
            Armatures.registerEntityTypeArmature((EntityType)entityType, (AssetAccessor)armature);
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128461_("renderer"), tag);
        }
    }

    public static Map<Attribute, Double> deserializeAdvancedAttributes(CompoundTag tag) {
        HashMap attributes = Maps.newHashMap();
        attributes.put((Attribute)EpicFightAttributes.WEIGHT.get(), tag.m_128441_("weight") ? tag.m_128459_("weight") : 40.0);
        attributes.put((Attribute)EpicFightAttributes.IMPACT.get(), tag.m_128441_("impact") ? tag.m_128459_("impact") : 0.5);
        attributes.put((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), tag.m_128441_("armor_negation") ? tag.m_128459_("armor_negation") : 0.0);
        attributes.put((Attribute)EpicFightAttributes.MAX_STAMINA.get(), tag.m_128441_("max_stamina") ? tag.m_128459_("max_stamina") : 15.0);
        attributes.put((Attribute)EpicFightAttributes.STAMINA_REGEN.get(), tag.m_128441_("stamina_regan_multiply") ? tag.m_128459_("stamina_regan_multiply") : 1.0);
        attributes.put((Attribute)EpicFightAttributes.MAX_STRIKES.get(), Double.valueOf(tag.m_128425_("max_strikes", 3) ? tag.m_128451_("max_strikes") : 1));
        if (tag.m_128425_("attack_damage", 6)) {
            attributes.put(Attributes.f_22281_, tag.m_128459_("attack_damage"));
        }
        return attributes;
    }

    public static Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> deserializeAdvancedHumanoidCombatBehaviors(ListTag tag) {
        HashMap combatBehaviorsMapBuilder = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag combatBehavior = tag.m_128728_(i);
            ListTag categories = combatBehavior.m_128437_("weapon_categories", 8);
            Style style = (Style)Style.ENUM_MANAGER.get(combatBehavior.m_128461_("style"));
            CombatBehaviors.Builder builder = AdvancedMobpatchReloader.deserializeAdvancedBehaviorsBuilder(combatBehavior.m_128437_("behavior_series", 10));
            for (int j = 0; j < categories.size(); ++j) {
                WeaponCategory category = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(categories.m_128778_(j));
                combatBehaviorsMapBuilder.computeIfAbsent(category, key -> Maps.newHashMap());
                ((Map)combatBehaviorsMapBuilder.get(category)).put(style, builder);
            }
        }
        return combatBehaviorsMapBuilder;
    }

    public static Map<WeaponCategory, Map<Style, GuardMotion>> deserializeHumanoidGuardMotions(ListTag tag) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag list = tag.m_128728_(i);
            Style style = (Style)Style.ENUM_MANAGER.get(list.m_128461_("style"));
            GuardMotion guardMotion = AdvancedMobpatchReloader.deserializeGuardMotions(list);
            Tag weponTypeTag = list.m_128423_("weapon_categories");
            if (weponTypeTag instanceof StringTag) {
                WeaponCategory weaponCategory = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(weponTypeTag.m_7916_());
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, guardMotion);
                continue;
            }
            if (!(weponTypeTag instanceof ListTag)) continue;
            ListTag weponTypesTag = (ListTag)weponTypeTag;
            for (int j = 0; j < weponTypesTag.size(); ++j) {
                WeaponCategory weaponCategory = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(weponTypesTag.m_128778_(j));
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, guardMotion);
            }
        }
        return map;
    }

    private static <T extends MobPatch<?>> CombatBehaviors.Builder<T> deserializeAdvancedBehaviorsBuilder(ListTag tag) {
        CombatBehaviors.Builder builder = CombatBehaviors.builder();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag behaviorSeries = tag.m_128728_(i);
            float weight = (float)behaviorSeries.m_128459_("weight");
            int cooldown = behaviorSeries.m_128441_("cooldown") ? behaviorSeries.m_128451_("cooldown") : 0;
            boolean canBeInterrupted = behaviorSeries.m_128441_("canBeInterrupted") && behaviorSeries.m_128471_("canBeInterrupted");
            boolean looping = behaviorSeries.m_128441_("looping") && behaviorSeries.m_128471_("looping");
            ListTag behaviorList = behaviorSeries.m_128437_("behaviors", 10);
            CombatBehaviors.BehaviorSeries.Builder behaviorSeriesBuilder = CombatBehaviors.BehaviorSeries.builder();
            behaviorSeriesBuilder.weight(weight).cooldown(cooldown).canBeInterrupted(canBeInterrupted).looping(looping);
            for (int j = 0; j < behaviorList.size(); ++j) {
                AdvancedBehaviorBuilder behaviorBuilder = new AdvancedBehaviorBuilder();
                CompoundTag behavior = behaviorList.m_128728_(j);
                ListTag conditionList = behavior.m_128437_("conditions", 10);
                if (behavior.m_128441_("set_phase")) {
                    behaviorBuilder.tryProcessSetPhase(behavior.m_128451_("set_phase"));
                }
                if (behavior.m_128441_("end_by_hurt_level")) {
                    behaviorBuilder.tryProcessSetHurtResistLevel(behavior.m_128451_("end_by_hurt_level"));
                }
                if (behavior.m_128441_("animation")) {
                    AnimationManager.AnimationAccessor animation = AnimationManager.byKey((String)behavior.m_128461_("animation"));
                    motionSet = new AnimationMotionSet((AnimationManager.AnimationAccessor<? extends StaticAnimation>)animation, 0.0f, 1.0f, 0.0f);
                    motionSet = behavior.m_128441_("play_speed") ? ((AnimationMotionSet)motionSet).setSpeed((float)behavior.m_128459_("play_speed")) : motionSet;
                    motionSet = behavior.m_128441_("stamina") ? ((AnimationMotionSet)motionSet).setStaminaCost((float)behavior.m_128459_("stamina")) : motionSet;
                    motionSet = behavior.m_128441_("convert_time") ? ((AnimationMotionSet)motionSet).setConvertTime((float)behavior.m_128459_("convert_time")) : motionSet;
                    motionSet = behavior.m_128441_("damage_modifier") && !behavior.m_128469_("damage_modifier").m_128456_() ? ((AnimationMotionSet)motionSet).setDamageSourceModifier(AdvancedMobpatchReloader.deserializeDamageModifier(behavior.m_128469_("damage_modifier"))) : motionSet;
                    motionSet = behavior.m_128441_("command_list") && !behavior.m_128437_("command_list", 10).isEmpty() ? ((AnimationMotionSet)motionSet).addTimeStampedEvents(AdvancedMobpatchReloader.deserializeTimeCommandList(behavior.m_128437_("command_list", 10))) : motionSet;
                    motionSet = behavior.m_128441_("hit_command_list") && !behavior.m_128437_("hit_command_list", 10).isEmpty() ? ((AnimationMotionSet)motionSet).addHitEvents(AdvancedMobpatchReloader.deserializeHitCommandList(behavior.m_128437_("hit_command_list", 10))) : motionSet;
                    motionSet = behavior.m_128441_("blocked_command_list") && !behavior.m_128437_("blocked_command_list", 10).isEmpty() ? ((AnimationMotionSet)motionSet).addBlockedEvents(AdvancedMobpatchReloader.deserializeBlockedCommandList(behavior.m_128437_("blocked_command_list", 10))) : motionSet;
                    behaviorBuilder.tryProcessAnimationSet((AnimationMotionSet)motionSet);
                } else if (behavior.m_128441_("guard")) {
                    int guard_time = behavior.m_128451_("guard");
                    motionSet = new GuardMotionSet(guard_time, 0, 0);
                    CounterMotion counterMotion = new CounterMotion(GuardAnimations.MOB_COUNTER_ATTACK, 3.0f, 0.3f, 1.0f, 0.0f, true);
                    if (behavior.m_128441_("parry") && behavior.m_128471_("parry")) {
                        ((GuardMotionSet)motionSet).setParryTimes(Integer.MAX_VALUE);
                    }
                    motionSet = behavior.m_128441_("parry_times") ? ((GuardMotionSet)motionSet).setParryTimes(behavior.m_128451_("parry_times")) : motionSet;
                    motionSet = behavior.m_128441_("stun_immunity_time") ? ((GuardMotionSet)motionSet).setStunImmunityTime(behavior.m_128451_("stun_immunity_time")) : motionSet;
                    counterMotion = behavior.m_128441_("counter") ? counterMotion.setCounterAnimation(behavior.m_128461_("counter")) : counterMotion;
                    counterMotion = behavior.m_128441_("counter_cost") ? counterMotion.setCost((float)behavior.m_128459_("counter_cost")) : counterMotion;
                    counterMotion = behavior.m_128441_("counter_chance") ? counterMotion.setChance((float)behavior.m_128459_("counter_chance")) : counterMotion;
                    counterMotion = behavior.m_128441_("counter_speed") ? counterMotion.setSpeed((float)behavior.m_128459_("counter_speed")) : counterMotion;
                    counterMotion = behavior.m_128441_("counter_convert_time") ? counterMotion.setConvertTime((float)behavior.m_128459_("counter_convert_time")) : counterMotion;
                    counterMotion = behavior.m_128441_("cancel_after_counter") ? counterMotion.cancelBlock(behavior.m_128471_("cancel_after_counter")) : counterMotion;
                    motionSet = ((GuardMotionSet)motionSet).setCounterMotion(counterMotion);
                    motionSet = behavior.m_128441_("specific_guard_motion") ? ((GuardMotionSet)motionSet).setSpecificGuardMotion(AdvancedMobpatchReloader.deserializeGuardMotions(behavior.m_128469_("specific_guard_motion"))) : motionSet;
                    behaviorBuilder.tryProcessGuardMotion((GuardMotionSet)motionSet);
                } else if (behavior.m_128441_("wander")) {
                    int strafingTime = behavior.m_128451_("wander");
                    motionSet = new WanderMotionSet(strafingTime, strafingTime, 0.0f, 0.0f);
                    motionSet = behavior.m_128441_("inaction_time") ? ((WanderMotionSet)motionSet).setInactionTime(behavior.m_128451_("inaction_time")) : motionSet;
                    motionSet = behavior.m_128441_("z_axis") ? ((WanderMotionSet)motionSet).setForwardDirection((float)behavior.m_128459_("z_axis")) : motionSet;
                    motionSet = behavior.m_128441_("x_axis") ? ((WanderMotionSet)motionSet).setClockwise((float)behavior.m_128459_("x_axis")) : motionSet;
                    behaviorBuilder.tryProcessWanderSet((WanderMotionSet)motionSet);
                }
                behaviorBuilder.process();
                for (int k = 0; k < conditionList.size(); ++k) {
                    CompoundTag condition = conditionList.m_128728_(k);
                    Condition predicate = MobPatchReloadListener.deserializeBehaviorPredicate((String)condition.m_128461_("predicate"), (CompoundTag)condition);
                    behaviorBuilder.predicate(predicate);
                }
                behaviorSeriesBuilder.nextBehavior(behaviorBuilder);
            }
            builder.newBehaviorSeries(behaviorSeriesBuilder);
        }
        return builder;
    }

    public static GuardMotion deserializeGuardMotions(CompoundTag args) {
        GuardMotion guardMotion = new GuardMotion((AnimationManager.AnimationAccessor<? extends StaticAnimation>)Animations.EMPTY_ANIMATION, false, 0.0f);
        if (args.m_128441_("guard")) {
            guardMotion = guardMotion.setGuardAnimation(args.m_128461_("guard"));
        }
        if (args.m_128441_("stamina_cost_multiply")) {
            guardMotion = guardMotion.setCost((float)args.m_128459_("stamina_cost_multiply"));
        }
        if (args.m_128441_("can_block_projectile")) {
            guardMotion = guardMotion.canBlockProjectile(args.m_128471_("can_block_projectile"));
        }
        if (args.m_128441_("parry_cost_multiply")) {
            guardMotion = guardMotion.setParryCost((float)args.m_128459_("parry_cost_multiply"));
        }
        if (args.m_128441_("parry_animation")) {
            ListTag animationId = args.m_128437_("parry_animation", 8);
            Object[] parry_animations = new AnimationManager.AnimationAccessor[animationId.size()];
            for (int j = 0; j < animationId.size(); ++j) {
                AnimationManager.AnimationAccessor parry_animation = AnimationManager.byKey((String)animationId.m_128778_(j));
                parry_animations[j] = parry_animation;
            }
            guardMotion = guardMotion.setParryAnimations(parry_animations);
        }
        return guardMotion;
    }

    public static LivingEntityPatchEvent.TimeStampedEvent[] deserializeTimeCommandList(ListTag args) {
        LivingEntityPatchEvent.TimeStampedEvent[] list = new LivingEntityPatchEvent.TimeStampedEvent[args.size()];
        for (int k = 0; k < args.size(); ++k) {
            LivingEntityPatchEvent.TimeStampedEvent event;
            CompoundTag command = args.m_128728_(k);
            boolean execute_at_target = command.m_128441_("execute_at_target") && command.m_128471_("execute_at_target");
            list[k] = event = LivingEntityPatchEvent.TimeStampedEvent.CreateTimeCommandEvent(command.m_128457_("time"), command.m_128461_("command"), execute_at_target);
        }
        return list;
    }

    public static LivingEntityPatchEvent.BiEvent[] deserializeHitCommandList(ListTag args) {
        LivingEntityPatchEvent.BiEvent[] list = new LivingEntityPatchEvent.BiEvent[args.size()];
        for (int k = 0; k < args.size(); ++k) {
            LivingEntityPatchEvent.BiEvent event;
            CompoundTag command = args.m_128728_(k);
            boolean execute_at_target = command.m_128441_("execute_at_target") && command.m_128471_("execute_at_target");
            list[k] = event = LivingEntityPatchEvent.BiEvent.CreateBiCommandEvent(command.m_128461_("command"), execute_at_target);
        }
        return list;
    }

    public static List<LivingEntityPatchEvent.StunEvent> deserializeStunCommandList(ListTag args) {
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < args.size(); ++k) {
            CompoundTag command = args.m_128728_(k);
            boolean execute_at_target = command.m_128441_("execute_at_target") && command.m_128471_("execute_at_target");
            LivingEntityPatchEvent.StunEvent event = LivingEntityPatchEvent.StunEvent.CreateStunCommandEvent(command.m_128461_("command"), execute_at_target, StunType.valueOf((String)command.m_128461_("stun_type").toUpperCase(Locale.ROOT)));
            list.add(event);
        }
        return list;
    }

    public static LivingEntityPatchEvent.BlockedEvent[] deserializeBlockedCommandList(ListTag args) {
        LivingEntityPatchEvent.BlockedEvent[] list = new LivingEntityPatchEvent.BlockedEvent[args.size()];
        for (int k = 0; k < args.size(); ++k) {
            LivingEntityPatchEvent.BlockedEvent event;
            CompoundTag command = args.m_128728_(k);
            boolean execute_at_target = command.m_128441_("execute_at_target") && command.m_128471_("execute_at_target");
            list[k] = event = LivingEntityPatchEvent.BlockedEvent.CreateBlockCommandEvent(command.m_128461_("command"), execute_at_target, command.m_128471_("is_parry"));
        }
        return list;
    }

    public static DamageSourceModifier deserializeDamageModifier(CompoundTag args) {
        float damage = args.m_128441_("damage") ? args.m_128457_("damage") : 1.0f;
        float impact = args.m_128441_("impact") ? args.m_128457_("impact") : 1.0f;
        float armor_negation = args.m_128441_("armor_negation") ? args.m_128457_("armor_negation") : 1.0f;
        DamageSourceModifier modifier = new DamageSourceModifier(damage, impact, armor_negation);
        if (args.m_128441_("stun_type")) {
            modifier.setStunType(args.m_128461_("stun_type").toUpperCase(Locale.ROOT));
        }
        if (args.m_128441_("collider")) {
            modifier.setCollider(AdvancedMobpatchReloader.deserializeCollider(args.m_128469_("collider")));
        }
        return new DamageSourceModifier(damage, impact, armor_negation);
    }

    public static Collider deserializeCollider(CompoundTag tag) {
        int number = tag.m_128451_("number");
        if (number < 1) {
            EpicFightMod.LOGGER.warn("Datapack deserialization error: the number of colliders must bigger than 0! ");
            return null;
        }
        ListTag sizeVector = tag.m_128437_("size", 6);
        ListTag centerVector = tag.m_128437_("center", 6);
        double sizeX = sizeVector.m_128772_(0);
        double sizeY = sizeVector.m_128772_(1);
        double sizeZ = sizeVector.m_128772_(2);
        double centerX = centerVector.m_128772_(0);
        double centerY = centerVector.m_128772_(1);
        double centerZ = centerVector.m_128772_(2);
        if (sizeX < 0.0 || sizeY < 0.0 || sizeZ < 0.0) {
            EpicFightMod.LOGGER.warn("Datapack deserialization error: the size of the collider must be non-negative! ");
            return null;
        }
        if (number == 1) {
            return new OBBCollider(sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
        }
        return new MultiOBBCollider(number, sizeX, sizeY, sizeZ, centerX, centerY, centerZ);
    }

    public static class AdvancedCustomHumanoidMobPatchProvider
    extends AdvancedCustomMobPatchProvider {
        protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> AHCombatBehaviors = Maps.newHashMap();
        protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>> AHWeaponMotions = Maps.newHashMap();
        protected Map<WeaponCategory, Map<Style, GuardMotion>> guardMotions = Maps.newHashMap();

        @Override
        public EntityPatch<?> get(Entity entity) {
            return new AdvancedCustomHumanoidMobPatch(this.faction, this);
        }

        public Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>>> getHumanoidWeaponMotions() {
            return this.AHWeaponMotions;
        }

        public Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> getHumanoidCombatBehaviors() {
            return this.AHCombatBehaviors;
        }

        public Map<WeaponCategory, Map<Style, GuardMotion>> getGuardMotions() {
            return this.guardMotions;
        }
    }

    public static class AdvancedCustomMobPatchProvider
    extends MobPatchReloadListener.AbstractMobPatchProvider {
        protected Faction faction = Factions.NEUTRAL;
        protected CombatBehaviors.Builder<MobPatch<?>> combatBehaviorsBuilder;
        protected int regenStaminaStandbyTime = 30;
        protected boolean hasStunReduction = true;
        protected float maxStunShield = 0.0f;
        protected int reganShieldStandbyTime = 30;
        protected float reganShieldMultiply = 1.0f;
        protected float staminaLoseMultiply = 0.0f;
        protected float guardRadius = 3.0f;
        protected float attackRadius = 1.5f;
        protected List<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> defaultAnimations = new ArrayList<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>>();
        protected Map<StunType, AnimationManager.AnimationAccessor<? extends StaticAnimation>> stunAnimations = Maps.newHashMap();
        protected Map<Attribute, Double> attributeValues = Maps.newHashMap();
        protected double chasingSpeed = 1.0;
        protected float scale = 1.0f;
        protected boolean hasBossBar = false;
        protected ResourceLocation bossBar;
        protected String name;
        protected GuardMotion defaultGuardMotion;
        protected List<LivingEntityPatchEvent.StunEvent> stunEvent = new ArrayList<LivingEntityPatchEvent.StunEvent>();
        protected SoundEvent swingSound = (SoundEvent)EpicFightSounds.WHOOSH.get();
        protected SoundEvent hitSound = (SoundEvent)EpicFightSounds.BLUNT_HIT.get();
        protected HitParticleType hitParticle = (HitParticleType)EpicFightParticles.HIT_BLUNT.get();

        public EntityPatch<?> get(Entity entity) {
            return new AdvancedCustomMobPatch(this.faction, this);
        }

        public List<Pair<LivingMotion, AnimationManager.AnimationAccessor<? extends StaticAnimation>>> getDefaultAnimations() {
            return this.defaultAnimations;
        }

        public Map<StunType, AnimationManager.AnimationAccessor<? extends StaticAnimation>> getStunAnimations() {
            return this.stunAnimations;
        }

        public Map<Attribute, Double> getAttributeValues() {
            return this.attributeValues;
        }

        public double getChasingSpeed() {
            return this.chasingSpeed;
        }

        public float getScale() {
            return this.scale;
        }

        public int getRegenStaminaStandbyTime() {
            return this.regenStaminaStandbyTime;
        }

        public boolean hasStunReduction() {
            return this.hasStunReduction;
        }

        public float getMaxStunShield() {
            return this.maxStunShield;
        }

        public int getReganShieldStandbyTime() {
            return this.reganShieldStandbyTime;
        }

        public float getReganShieldMultiply() {
            return this.reganShieldMultiply;
        }

        public float getStaminaLoseMultiply() {
            return this.staminaLoseMultiply;
        }

        public float getGuardRadius() {
            return this.guardRadius;
        }

        public float getAttackRadius() {
            return this.attackRadius;
        }

        public List<LivingEntityPatchEvent.StunEvent> getStunEvent() {
            return this.stunEvent;
        }

        public boolean hasBossBar() {
            return this.hasBossBar;
        }

        public String getName() {
            return this.name;
        }

        public ResourceLocation getBossBar() {
            return this.bossBar;
        }

        public CombatBehaviors.Builder<MobPatch<?>> getCombatBehaviorsBuilder() {
            return this.combatBehaviorsBuilder;
        }

        public GuardMotion getGuardMotion() {
            return this.defaultGuardMotion;
        }

        public SoundEvent getSwingSound() {
            return this.swingSound;
        }

        public SoundEvent getHitSound() {
            return this.hitSound;
        }

        public HitParticleType getHitParticle() {
            return this.hitParticle;
        }
    }
}

