/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.compat.kubejs.Utils;

import com.google.common.collect.Maps;
import com.nameless.indestructible.main.Indestructible;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.Locale;
import java.util.Map;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.world.damagesource.StunType;

public class StunAnimationHelper {
    private final Map<StunType, AnimationManager.AnimationAccessor<? extends StaticAnimation>> stunAnimationMap = Maps.newHashMap();

    public static StunAnimationHelper getHelper() {
        return new StunAnimationHelper();
    }

    @Info(value="mandatory or alternative method otherwise won't be stunned, bind stun animation to stun type in this map", params={@Param(name="object1", value="stun type, enum or name(string)"), @Param(name="object2", value="animation, animation instance or its registry name(String)")})
    public StunAnimationHelper addStunAnimation(Object object1, Object object2) {
        String s;
        StunType stunType = null;
        AnimationManager.AnimationAccessor animation = null;
        if (object1 instanceof StunType) {
            StunType t;
            stunType = t = (StunType)object1;
        } else if (object1 instanceof String) {
            s = (String)object1;
            stunType = StunType.valueOf((String)s.toUpperCase(Locale.ROOT));
        } else {
            Indestructible.LOGGER.warn(object1 + " can't be recognized");
        }
        if (object2 instanceof AnimationManager.AnimationAccessor) {
            AnimationManager.AnimationAccessor a;
            animation = a = (AnimationManager.AnimationAccessor)object2;
        } else if (object2 instanceof String) {
            s = (String)object2;
            animation = AnimationManager.byKey((String)s);
        } else {
            Indestructible.LOGGER.warn(object2 + " can't be recognized");
        }
        if (stunType != null && animation != null) {
            this.stunAnimationMap.put(stunType, (AnimationManager.AnimationAccessor<? extends StaticAnimation>)animation);
        }
        return this;
    }

    public Map<StunType, AnimationManager.AnimationAccessor<? extends StaticAnimation>> createMap() {
        return this.stunAnimationMap;
    }
}

