/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nameless.indestructible.client.ClientBossInfo;
import com.nameless.indestructible.client.gui.AdvanceHealthBar;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class BossBarGUi {
    public static final Map<UUID, ClientBossInfo> BossBarEntities = Maps.newHashMap();
    public static final List<String> cancelBossBar = new ArrayList<String>();

    @SubscribeEvent
    public void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (!cancelBossBar.isEmpty()) {
            for (String bossEventName : cancelBossBar) {
                if (!event.getBossEvent().m_18861_().getString().equals(bossEventName)) continue;
                event.setCanceled(true);
                event.setIncrement(0);
            }
        }
        BossBarEntities.values().forEach(k -> {
            if (event.getBossEvent().m_18861_().getString().contains(k.getOriginalName())) {
                event.setCanceled(true);
                event.setIncrement(0);
            }
        });
        if (!event.getBossEvent().m_18861_().getString().equals("advanced epic fight boss")) {
            return;
        }
        event.setCanceled(true);
        UUID infoID = event.getBossEvent().m_18860_();
        ClientBossInfo info = BossBarEntities.get(infoID);
        if (info != null) {
            ResourceLocation rl = info.getRl();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)rl);
            int l = Minecraft.m_91087_().f_91062_.m_92895_(info.getDisplayName());
            int i1 = event.getWindow().m_85445_() / 2 - l / 2;
            int x = event.getX() - 36;
            int y = event.getY();
            if (event.getY() >= Minecraft.m_91087_().m_91268_().m_85446_() / 3) {
                return;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            PoseStack barPoseStack = guiGraphics.m_280168_();
            barPoseStack.m_85836_();
            barPoseStack.m_85841_(1.0f, 1.0f, 1.0f);
            float healthRatio = Mth.m_14036_((float)info.getHealthRatio(), (float)0.0f, (float)1.0f);
            int health = (int)(256.0f * healthRatio);
            float staminaRatio = Mth.m_14036_((float)info.getStaminaRatio(), (float)0.0f, (float)1.0f);
            int stamina = (int)(256.0f * staminaRatio);
            guiGraphics.m_280163_(rl, x, y, 0.0f, 0.0f, 256, 19, 255, 255);
            guiGraphics.m_280163_(rl, x, y, 0.0f, 21.0f, health, 19, 255, 255);
            guiGraphics.m_280163_(rl, x, y + 18, 0.0f, 42.0f, 256, 10, 255, 255);
            guiGraphics.m_280163_(rl, x, y + 18, 0.0f, 55.0f, stamina, 10, 255, 255);
            guiGraphics.m_280163_(rl, x, y, 0.0f, 68.0f, 256, 29, 255, 255);
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, info.getDisplayName(), i1, y - 9, 0xFFFFFF);
            event.setIncrement(44);
        }
    }

    @SubscribeEvent
    public void renderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            AdvanceHealthBar.Instance.reset();
        } else {
            AdvanceHealthBar.Instance.remove();
        }
    }

    @SubscribeEvent
    public void levelTickEvent(TickEvent.LevelTickEvent event) {
        if (event.level.m_5776_() && event.phase == TickEvent.Phase.END) {
            AdvanceHealthBar.Instance.tick();
        }
    }
}

