/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nameless.indestructible.client.UIConfig;
import com.nameless.indestructible.world.capability.Utils.IAdvancedCapability;
import com.nameless.indestructible.world.capability.Utils.IBossEventCapability;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import yesman.epicfight.client.gui.EntityUI;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.VisibleMobEffect;

@OnlyIn(value=Dist.CLIENT)
public class AdvanceHealthBar
extends EntityUI {
    public static final AdvanceHealthBar Instance = new AdvanceHealthBar();
    public static final ResourceLocation STATUS_BAR = ResourceLocation.fromNamespaceAndPath((String)"indestructible", (String)"textures/gui/bar.png");
    public static final ResourceLocation DELAY_BAR = ResourceLocation.fromNamespaceAndPath((String)"indestructible", (String)"textures/gui/bar1.png");
    private final Map<LivingEntity, EntityAttributeTracker> trackingEntities = Maps.newConcurrentMap();

    public boolean shouldDraw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, float partialTicks) {
        IBossEventCapability ibe;
        if ((Integer)UIConfig.REPLACE_HEALTH_BAR.get() == 0 || (Integer)UIConfig.REPLACE_HEALTH_BAR.get() == 1 && !(entitypatch instanceof IAdvancedCapability)) {
            return false;
        }
        ClientConfig.HealthBarVisibility healthBarVisibility = ClientConfig.healthBarVisibility;
        Minecraft mc = Minecraft.m_91087_();
        if (healthBarVisibility == ClientConfig.HealthBarVisibility.NONE) {
            return false;
        }
        if (entity.m_6095_().m_204039_(Tags.EntityTypes.BOSSES) || entitypatch instanceof IBossEventCapability && (ibe = (IBossEventCapability)entitypatch).hasBossBar()) {
            return false;
        }
        EntityAttributeTracker healthTracker = this.trackingEntities.computeIfAbsent(entity, key -> new EntityAttributeTracker((LivingEntity)key, entitypatch));
        healthTracker.checkChange(partialTicks);
        healthTracker.setKeepUp(true);
        if (entity.m_20177_((Player)playerpatch.getOriginal()) || entity == ((LocalPlayer)playerpatch.getOriginal()).m_20202_()) {
            return false;
        }
        if (entity.m_20280_(mc.m_91288_()) >= 400.0) {
            return false;
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player == playerpatch.getOriginal() && playerpatch.getMaxStunShield() <= 0.0f) {
                return false;
            }
            if (player.m_7500_() || player.m_5833_()) {
                return false;
            }
        }
        boolean showTarget = false;
        if (healthBarVisibility == ClientConfig.HealthBarVisibility.TARGET) {
            return playerpatch.getTarget() == entity;
        }
        if (healthBarVisibility == ClientConfig.HealthBarVisibility.TARGET_AND_HURT) {
            showTarget = playerpatch.getTarget() == entity;
        }
        return (!entity.m_21220_().isEmpty() || entity.m_21223_() < entity.m_21233_() || showTarget) && !entity.m_213877_();
    }

    public void draw(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, PoseStack poseStack, MultiBufferSource buffers, float partialTicks) {
        float healthEnd;
        Matrix4f modelViewMatrix = super.getModelViewMatrixAlignedToCamera(poseStack, entity, 0.0f, entity.m_20206_() + 0.5f, 0.0f, true, partialTicks);
        Collection activeEffects = entity.m_21220_();
        if (!activeEffects.isEmpty() && !entity.m_7306_(playerpatch.getOriginal())) {
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    ResourceLocation rl;
                    MobEffectInstance effectInstance = (MobEffectInstance)iter.next();
                    MobEffect effect = effectInstance.m_19544_();
                    if (effect instanceof VisibleMobEffect) {
                        VisibleMobEffect visibleMobEffect = (VisibleMobEffect)effect;
                        rl = visibleMobEffect.getIcon(effectInstance);
                    } else {
                        rl = ResourceLocation.fromNamespaceAndPath((String)ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).m_135827_(), (String)("textures/mob_effect/" + ForgeRegistries.MOB_EFFECTS.getKey((Object)effect).m_135815_() + ".png"));
                    }
                    float x = startX + 0.3f * (float)j;
                    float y = startY + -0.3f * (float)i;
                    AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)rl, (MultiBufferSource)buffers, (float)x, (float)y, (float)(x + 0.3f), (float)(y + 0.3f), (int)0, (int)0, (int)256, (int)256, (int)256);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        EntityAttributeTracker attributeTracker = this.trackingEntities.get(entity);
        float maxHealth = entity.m_21233_();
        float partialHealth = attributeTracker.healthState.getAnimatedValue(entity.f_19797_, partialTicks);
        float partialAbsorption = attributeTracker.absorptionState.getAnimatedValue(entity.f_19797_, partialTicks);
        AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)STATUS_BAR, (MultiBufferSource)buffers, (float)-0.5f, (float)0.0f, (float)0.5f, (float)0.1f, (float)0.0f, (float)0.25f, (float)1.0f, (float)0.390625f);
        if (partialAbsorption > 0.0f || attributeTracker.absorptionState.hasAnimation()) {
            boolean isTotalOverMaxHealth = partialHealth + partialAbsorption > maxHealth;
            float absorptionStart = isTotalOverMaxHealth ? Mth.m_14036_((float)(partialHealth / (partialHealth + partialAbsorption)), (float)0.0f, (float)1.0f) : partialHealth / maxHealth;
            float absorptionEnd = isTotalOverMaxHealth ? Mth.m_14036_((float)((partialHealth + partialAbsorption) / maxHealth), (float)0.0f, (float)1.0f) : (partialHealth + partialAbsorption) / maxHealth;
            AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)STATUS_BAR, (MultiBufferSource)buffers, (float)(absorptionStart - 0.5f), (float)0.0f, (float)(absorptionEnd - 0.5f), (float)0.1f, (float)absorptionStart, (float)0.5625f, (float)absorptionEnd, (float)0.703125f);
            if (attributeTracker.absorptionState.hasAnimation()) {
                float lostAbsorptionStart = Mth.m_14036_((float)(entity.m_6103_() / partialAbsorption), (float)0.0f, (float)1.0f);
                lostAbsorptionStart = absorptionStart + (absorptionEnd - absorptionStart) * lostAbsorptionStart;
                AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)DELAY_BAR, (MultiBufferSource)buffers, (float)(lostAbsorptionStart - 0.5f), (float)0.0f, (float)(absorptionEnd - 0.5f), (float)0.1f, (float)0.0f, (float)0.5625f, (float)1.0f, (float)0.703125f);
            }
            healthEnd = isTotalOverMaxHealth ? absorptionStart : 1.0f;
        } else {
            healthEnd = 1.0f;
        }
        float ratio = Mth.m_14036_((float)(entity.m_21223_() / maxHealth), (float)0.0f, (float)1.0f);
        float filledHealthEnd = Math.max(-0.5f + ratio * healthEnd, -0.46875f);
        AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)STATUS_BAR, (MultiBufferSource)buffers, (float)-0.5f, (float)0.0f, (float)filledHealthEnd, (float)0.1f, (float)0.0f, (float)0.40625f, (float)(ratio * healthEnd), (float)0.546875f);
        if (attributeTracker.healthState.hasAnimation()) {
            float animatedHealthRatio = Mth.m_14036_((float)(partialHealth / maxHealth), (float)0.0f, (float)1.0f);
            float animatedHealthModelX = Math.min(-0.5f + animatedHealthRatio, 0.46875f);
            AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)modelViewMatrix, (ResourceLocation)DELAY_BAR, (MultiBufferSource)buffers, (float)filledHealthEnd, (float)0.0f, (float)animatedHealthModelX, (float)0.1f, (float)0.0f, (float)0.40625f, (float)1.0f, (float)0.546875f);
        }
        if (attributeTracker.stunShieldState != null) {
            Matrix4f stunMartrix = new Matrix4f((Matrix4fc)modelViewMatrix).scale(0.92f, 1.0f, 1.0f);
            AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)stunMartrix, (ResourceLocation)STATUS_BAR, (MultiBufferSource)buffers, (float)-0.5f, (float)0.1f, (float)0.5f, (float)0.15f, (float)0.046875f, (float)0.71875f, (float)0.96875f, (float)0.796875f);
            float stunShieldRatio = Mth.m_14036_((float)(entitypatch.getStunShield() / entitypatch.getMaxStunShield()), (float)0.0f, (float)1.0f);
            int stunShieldTextureRatio = (int)(62.0f * stunShieldRatio);
            AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)stunMartrix, (ResourceLocation)STATUS_BAR, (MultiBufferSource)buffers, (float)-0.5f, (float)0.1f, (float)(-0.5f + stunShieldRatio), (float)0.15f, (float)0.046875f, (float)0.828125f, (float)((float)stunShieldTextureRatio / 64.0f), (float)0.90625f);
            float animatedStunShieldPosition = Mth.m_14036_((float)(attributeTracker.stunShieldState.getAnimatedValue(entity.f_19797_, partialTicks) / entitypatch.getMaxStunShield()), (float)0.0f, (float)1.0f);
            AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)stunMartrix, (ResourceLocation)DELAY_BAR, (MultiBufferSource)buffers, (float)(-0.5f + stunShieldRatio), (float)0.1f, (float)(animatedStunShieldPosition - 0.5f), (float)0.15f, (float)0.046875f, (float)0.828125f, (float)0.796875f, (float)0.90625f);
        }
        if (attributeTracker.staminaState != null && entitypatch instanceof IAdvancedCapability) {
            IAdvancedCapability iac = (IAdvancedCapability)entitypatch;
            Matrix4f staminaMartrix = new Matrix4f((Matrix4fc)modelViewMatrix).scale(0.82f, 1.0f, 1.0f);
            AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)staminaMartrix, (ResourceLocation)STATUS_BAR, (MultiBufferSource)buffers, (float)-0.5f, (float)-0.05f, (float)0.5f, (float)0.0f, (float)0.09375f, (float)0.0f, (float)0.921875f, (float)0.109375f);
            float staminaRatio = Mth.m_14036_((float)(iac.getStamina() / iac.getMaxStamina()), (float)0.0f, (float)1.0f);
            float shieldRatio = -0.5f + staminaRatio;
            int staminaTextureRatio = (int)(59.0f * staminaRatio);
            AdvanceHealthBar.drawUIAsLevelModel((Matrix4f)staminaMartrix, (ResourceLocation)STATUS_BAR, (MultiBufferSource)buffers, (float)-0.5f, (float)-0.05f, (float)(-0.5f + staminaRatio), (float)0.0f, (float)0.09375f, (float)0.125f, (float)((float)staminaTextureRatio / 64.0f), (float)0.234375f);
        }
    }

    public void reset() {
        this.trackingEntities.values().forEach(tracker -> tracker.setKeepUp(false));
    }

    public void remove() {
        this.trackingEntities.entrySet().removeIf(entry -> !((EntityAttributeTracker)entry.getValue()).canKeepUp());
    }

    public void tick() {
        this.trackingEntities.values().forEach(EntityAttributeTracker::tick);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class EntityAttributeTracker {
        private final LivingEntity entity;
        private final AttributeState healthState;
        private final AttributeState absorptionState;
        @Nullable
        private final AttributeState stunShieldState;
        @Nullable
        private final AttributeState staminaState;
        private boolean canKeepUp;

        public EntityAttributeTracker(LivingEntity entity, @Nullable LivingEntityPatch<?> entitypatch) {
            AttributeState attributeState;
            this.entity = entity;
            this.healthState = new AttributeState(() -> ((LivingEntity)entity).m_21233_(), () -> ((LivingEntity)entity).m_21223_());
            this.absorptionState = new AttributeState(() -> ((LivingEntity)entity).m_21233_(), () -> ((LivingEntity)entity).m_6103_());
            AttributeState attributeState2 = entitypatch != null ? new AttributeState(() -> entitypatch.getMaxStunShield(), () -> entitypatch.getStunShield()) : (this.stunShieldState = null);
            if (entitypatch instanceof IAdvancedCapability) {
                IAdvancedCapability iac = (IAdvancedCapability)entitypatch;
                attributeState = new AttributeState(iac::getMaxStamina, iac::getStamina);
            } else {
                attributeState = null;
            }
            this.staminaState = attributeState;
        }

        public void setKeepUp(boolean canKeepUp) {
            this.canKeepUp = canKeepUp;
        }

        public boolean canKeepUp() {
            return this.canKeepUp;
        }

        public void checkChange(float partialTick) {
            this.healthState.checkState(this.entity.f_19797_, partialTick);
            this.absorptionState.checkState(this.entity.f_19797_, partialTick);
            if (this.stunShieldState != null) {
                this.stunShieldState.checkState(this.entity.f_19797_, partialTick);
            }
            if (this.staminaState != null) {
                this.staminaState.checkState(this.entity.f_19797_, partialTick);
            }
        }

        public void tick() {
            this.healthState.tick(this.entity.f_19797_);
            this.absorptionState.tick(this.entity.f_19797_);
            if (this.stunShieldState != null) {
                this.stunShieldState.tick(this.entity.f_19797_);
            }
            if (this.staminaState != null) {
                this.staminaState.tick(this.entity.f_19797_);
            }
        }

        class AttributeState {
            final Supplier<Float> maxValueGetter;
            final Supplier<Float> currentValueGetter;
            float value;
            float valueO;
            int lastChangeTick;
            int animationFrames;

            AttributeState(Supplier<Float> maxValueGetter, Supplier<Float> currentValueGetter) {
                float initValue;
                this.maxValueGetter = maxValueGetter;
                this.currentValueGetter = currentValueGetter;
                this.value = initValue = currentValueGetter.get().floatValue();
                this.valueO = initValue;
                this.lastChangeTick = 0;
                this.animationFrames = 0;
            }

            void checkState(int tickCount, float partialTick) {
                float currentValue = this.currentValueGetter.get().floatValue();
                if (this.value != currentValue) {
                    if (this.animationFrames > 0) {
                        this.valueO = this.getAnimatedValue(tickCount, partialTick);
                    }
                    this.lastChangeTick = tickCount + 3;
                    this.animationFrames = currentValue == 0.0f ? 4 : Math.max(4, (int)(Math.abs(this.valueO - currentValue) / this.maxValueGetter.get().floatValue() * 10.0f));
                    this.value = currentValue;
                }
            }

            boolean hasAnimation() {
                return this.animationFrames > 0;
            }

            void tick(int tickCount) {
                if (tickCount - this.lastChangeTick >= this.animationFrames) {
                    this.animationFrames = 0;
                    this.valueO = this.value;
                }
            }

            float getAnimatedValue(int tickCount, float partialTick) {
                if (this.animationFrames == 0) {
                    return this.value;
                }
                if (tickCount < this.lastChangeTick) {
                    return this.valueO;
                }
                float divide = (float)(tickCount - this.lastChangeTick) / (float)this.animationFrames;
                float partial = divide + partialTick / (float)this.animationFrames;
                return this.valueO + (this.value - this.valueO) * partial;
            }
        }
    }
}

