/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.api.animation.types;

import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.kubejs.typings.Param;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.StunType;

public class LivingEntityPatchEvent {
    @Info(params={@Param(name="time", value="number, when will the event be executed"), @Param(name="event", value="Consumer<LivingEntityPatch<?>>, current event")})
    public static TimeStampedEvent createTimeStampedEvent(float time, Consumer<LivingEntityPatch<?>> event) {
        return new TimeStampedEvent(time, event);
    }

    @Info(params={@Param(name="time", value="number, when will the event be executed"), @Param(name="event", value="BiConsumer<LivingEntityPatch<?>, Entity>(patch of this entity, entity of target), current event")})
    public static BiEvent createBiEvent(BiConsumer<LivingEntityPatch<?>, Entity> event) {
        return new BiEvent(event);
    }

    @Info(params={@Param(name="object", value="stun type, enum or name(String)"), @Param(name="event", value="BiConsumer<LivingEntityPatch<?>, Entity>(patch of this entity, entity which stun this mob), current event")})
    public static StunEvent createStunEvent(Object object, BiConsumer<LivingEntityPatch<?>, Entity> event) {
        StunType stunType = StunType.NONE;
        if (object instanceof String) {
            String s = (String)object;
            stunType = StunType.valueOf((String)s.toUpperCase(Locale.ROOT));
        } else if (object instanceof StunType) {
            StunType t;
            stunType = t = (StunType)object;
        }
        return new StunEvent(event, stunType.ordinal());
    }

    @Info(params={@Param(name="isParry", value="if entity attack is parried by others"), @Param(name="event", value="BiConsumer<LivingEntityPatch<?>, Entity>(patch of this entity, entity which blocked this entity's attack), current event")})
    public static BlockedEvent createBlockedEvent(boolean isParry, BiConsumer<LivingEntityPatch<?>, Entity> event) {
        return new BlockedEvent(event, isParry);
    }

    public static class TimeStampedEvent
    extends LivingEntityPatchEvent
    implements Comparable<TimeStampedEvent> {
        private final float time;
        private final Consumer<LivingEntityPatch<?>> event;

        public TimeStampedEvent(float time, Consumer<LivingEntityPatch<?>> event) {
            this.event = event;
            this.time = time;
        }

        public void testAndExecute(LivingEntityPatch<?> entitypatch, float prevElapsed, float elapsed) {
            if (!entitypatch.isLogicalClient() && this.time >= prevElapsed && this.time < elapsed) {
                this.event.accept(entitypatch);
            }
        }

        @Override
        public int compareTo(TimeStampedEvent event) {
            if (this.time == event.time) {
                return 0;
            }
            return this.time > event.time ? 1 : -1;
        }

        public static TimeStampedEvent CreateTimeCommandEvent(float time, String command, boolean isTarget) {
            Consumer<LivingEntityPatch<?>> event = entitypatch -> {
                Level server = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                CommandSourceStack css = ((LivingEntity)entitypatch.getOriginal()).m_20203_().m_81325_(2).m_81324_();
                if (isTarget && entitypatch.getTarget() != null) {
                    LivingEntity target;
                    if (entitypatch instanceof MobPatch) {
                        MobPatch mobPatch = (MobPatch)entitypatch;
                        target = mobPatch.getTarget();
                    } else {
                        target = entitypatch.getTarget();
                    }
                    css = css.m_81329_((Entity)target);
                }
                if (server.m_7654_() != null && entitypatch.getOriginal() != null) {
                    server.m_7654_().m_129892_().m_230957_(css, command);
                }
            };
            return new TimeStampedEvent(time, event);
        }
    }

    public static class BiEvent {
        protected final BiConsumer<LivingEntityPatch<?>, Entity> event;

        public BiEvent(BiConsumer<LivingEntityPatch<?>, Entity> event) {
            this.event = event;
        }

        public static BiEvent CreateBiCommandEvent(String command, boolean isTarget) {
            BiConsumer<LivingEntityPatch<?>, Entity> event = (entitypatch, target) -> {
                Level server = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                CommandSourceStack css = ((LivingEntity)entitypatch.getOriginal()).m_20203_().m_81325_(2).m_81324_();
                if (isTarget && target instanceof LivingEntity) {
                    css = css.m_81329_(target);
                }
                if (server.m_7654_() != null && entitypatch.getOriginal() != null) {
                    server.m_7654_().m_129892_().m_230957_(css, command);
                }
            };
            return new BiEvent(event);
        }

        public void testAndExecute(LivingEntityPatch<?> entitypatch, Entity target) {
            if (!entitypatch.isLogicalClient()) {
                this.event.accept(entitypatch, target);
            }
        }
    }

    public static class StunEvent
    extends BiEvent {
        private final int condition;

        public StunEvent(BiConsumer<LivingEntityPatch<?>, Entity> event, int condition) {
            super(event);
            this.condition = condition;
        }

        public static StunEvent CreateStunCommandEvent(String command, boolean isTarget, StunType stunType) {
            BiConsumer<LivingEntityPatch<?>, Entity> event = (entitypatch, target) -> {
                Level server = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                CommandSourceStack css = ((LivingEntity)entitypatch.getOriginal()).m_20203_().m_81325_(2).m_81324_();
                if (isTarget && target instanceof LivingEntity) {
                    css = css.m_81329_(target);
                }
                if (server.m_7654_() != null && entitypatch.getOriginal() != null) {
                    server.m_7654_().m_129892_().m_230957_(css, command);
                }
            };
            return new StunEvent(event, stunType.ordinal());
        }

        public void testAndExecute(LivingEntityPatch<?> entitypatch, Entity target, int condition) {
            if (!entitypatch.isLogicalClient() && this.condition == condition) {
                this.event.accept(entitypatch, target);
            }
        }
    }

    public static class BlockedEvent {
        protected final BiConsumer<LivingEntityPatch<?>, Entity> event;
        boolean isParry;

        public BlockedEvent(BiConsumer<LivingEntityPatch<?>, Entity> event, boolean isParry) {
            this.event = event;
            this.isParry = isParry;
        }

        public static BlockedEvent CreateBlockCommandEvent(String command, boolean isTarget, boolean isParry) {
            BiConsumer<LivingEntityPatch<?>, Entity> event = (entitypatch, target) -> {
                Level server = ((LivingEntity)entitypatch.getOriginal()).m_9236_();
                CommandSourceStack css = ((LivingEntity)entitypatch.getOriginal()).m_20203_().m_81325_(2).m_81324_();
                if (isTarget && target instanceof LivingEntity) {
                    css = css.m_81329_(target);
                }
                if (server.m_7654_() != null && entitypatch.getOriginal() != null) {
                    server.m_7654_().m_129892_().m_230957_(css, command);
                }
            };
            return new BlockedEvent(event, isParry);
        }

        public void testAndExecute(LivingEntityPatch<?> entitypatch, Entity target, boolean isParry) {
            if (!entitypatch.isLogicalClient() && this.isParry == isParry) {
                this.event.accept(entitypatch, target);
            }
        }
    }
}

