/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.battle_field1;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;

public class DimensionResourceCopier {
    private static String dimensionPath;
    private static String modId;
    private static final Logger LOGGER;

    public static void copyDimensionToSaves(MinecraftServer server, ResourceKey<Level> levelResourceKey) {
        Path gameDir = FMLPaths.GAMEDIR.get();
        Path savesDir = gameDir.resolve("saves");
        dimensionPath = levelResourceKey.m_135782_().m_135815_();
        modId = levelResourceKey.m_135782_().m_135827_();
        if (server.m_6982_()) {
            DimensionResourceCopier.copyToSave(gameDir.resolve(server.m_129910_().m_5462_()));
        } else {
            try (Stream<Path> saveFolders = Files.list(savesDir);){
                saveFolders.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(DimensionResourceCopier::copyToSave);
            }
            catch (IOException e) {
                LOGGER.error("P1nero's Battle Field 1\uff1a \u904d\u5386\u5b58\u6863\u76ee\u5f55\u5931\u8d25: {}", (Object)e.getMessage());
            }
        }
    }

    private static void copyToSave(Path saveFolder) {
        Path targetDir = saveFolder.resolve("dimensions").resolve(modId).resolve(dimensionPath);
        if (Files.exists(targetDir.resolve("region"), new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(targetDir, new FileAttribute[0]);
            DimensionResourceCopier.copyUsingModClassLoader(targetDir);
            LOGGER.info("P1nero's Battle Field 1\uff1a {} \u590d\u5236\u5b8c\u6210\u3002", (Object)targetDir);
        }
        catch (IOException e) {
            LOGGER.error("P1nero's Battle Field 1\uff1a \u590d\u5236\u5230\u5b58\u6863\u5931\u8d25: {} - {}", (Object)saveFolder.getFileName(), (Object)e.getMessage());
        }
    }

    private static void copyUsingModClassLoader(Path targetDir) {
        Class<?> modClass = ModList.get().getModObjectById(modId).orElseThrow(() -> new IllegalStateException("\u627e\u4e0d\u5230\u6a21\u7ec4")).getClass();
        String resourcePath = "/" + modId + "/" + dimensionPath;
        try {
            DimensionResourceCopier.copyResourceDirectory(modClass, resourcePath, targetDir);
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.error("P1nero's Battle Field 1\uff1a \u590d\u5236\u8d44\u6e90\u5931\u8d25: {}", (Object)e.getMessage());
        }
    }

    private static void copyResourceDirectory(Class<?> modClass, String resourcePath, Path targetDir) throws IOException, URISyntaxException {
        URL resourceUrl = modClass.getResource(resourcePath);
        if (resourceUrl == null) {
            throw new IOException("P1nero's Battle Field 1\uff1a \u8d44\u6e90\u76ee\u5f55\u4e0d\u5b58\u5728: " + resourcePath);
        }
        if ("jar".equals(resourceUrl.getProtocol())) {
            DimensionResourceCopier.copyJarResources(resourceUrl, resourcePath, targetDir);
        } else {
            Path sourceDir = Paths.get(resourceUrl.toURI());
            Files.walk(sourceDir, new FileVisitOption[0]).forEach(source -> DimensionResourceCopier.copyFile(source, sourceDir, targetDir));
        }
    }

    private static void copyJarResources(URL resourceUrl, String resourcePath, Path targetDir) throws IOException {
        String jarPath = resourceUrl.getPath().substring(5, resourceUrl.getPath().indexOf("!"));
        jarPath = URLDecoder.decode(jarPath, StandardCharsets.UTF_8);
        try (FileSystem jarFs = FileSystems.newFileSystem(Path.of(jarPath, new String[0]), (ClassLoader)null);){
            Path resourceRoot = jarFs.getPath(resourcePath, new String[0]);
            Files.walk(resourceRoot, new FileVisitOption[0]).forEach(source -> DimensionResourceCopier.copyFile(source, resourceRoot, targetDir));
        }
    }

    private static void copyFile(Path source, Path sourceRoot, Path targetRoot) {
        try {
            Path relative = sourceRoot.relativize(source);
            Path target = targetRoot.resolve(relative.toString());
            if (Files.isDirectory(source, new LinkOption[0])) {
                Files.createDirectories(target, new FileAttribute[0]);
            } else {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
                LOGGER.info("P1nero's Battle Field 1\uff1a \u4ece {} \u590d\u5236\u5230 {} ", (Object)source, (Object)target);
            }
        }
        catch (IOException e) {
            LOGGER.error("P1nero's Battle Field 1\uff1a \u590d\u5236\u6587\u4ef6\u5931\u8d25: {} - {}", (Object)source, (Object)e.getMessage());
        }
    }

    static {
        LOGGER = LogUtils.getLogger();
    }
}

