/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.environment;

import java.util.Comparator;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.condition.BiomeCondition;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.creativecore.client.CreativeCoreClient;
import team.creative.creativecore.client.render.text.DebugTextRenderer;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.creativecore.common.util.type.list.PairList;

public class BiomeEnvironment
implements Iterable<Pair<BiomeArea, AmbientVolume>> {
    private final PairList<BiomeArea, AmbientVolume> biomes = new PairList();
    private double highestRainVolume;

    public BiomeEnvironment() {
    }

    public BiomeEnvironment(AmbientEngine engine, Player player, Level level, AmbientVolume volume) {
        this.highestRainVolume = 0.0;
        if (volume.volume() > 0.0) {
            BlockPos center = BlockPos.containing((Position)player.getEyePosition(CreativeCoreClient.getFrameTime()));
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int x2 = -engine.biomeScanCount; x2 <= engine.biomeScanCount; ++x2) {
                for (int z = -engine.biomeScanCount; z <= engine.biomeScanCount; ++z) {
                    BiomeArea area;
                    Pair before;
                    pos.set(center.getX() + x2 * engine.biomeScanDistance, center.getY(), center.getZ() + z * engine.biomeScanDistance);
                    Holder holder = level.getBiome((BlockPos)pos);
                    float biomeConditionVolume = (float)((1.0 - center.distSqr((Vec3i)pos) / engine.squaredBiomeDistance) * volume.conditionVolume());
                    if (level.isRaining() && ((Biome)holder.value()).getPrecipitationAt((BlockPos)pos, level.getSeaLevel()) == Biome.Precipitation.RAIN) {
                        this.highestRainVolume = Math.max(this.highestRainVolume, (double)biomeConditionVolume * volume.settingVolume());
                    }
                    if ((before = this.biomes.getPair((Object)(area = new BiomeArea((Holder<Biome>)holder, (BlockPos)pos)))) == null) {
                        this.biomes.add((Object)area, (Object)new AmbientVolume(biomeConditionVolume, volume.settingVolume()));
                        continue;
                    }
                    if (!(((AmbientVolume)before.value).conditionVolume() < (double)biomeConditionVolume)) continue;
                    ((AmbientVolume)before.value).setConditionVolumeDirect(biomeConditionVolume);
                }
            }
            this.biomes.sort(Comparator.comparingDouble(x -> ((AmbientVolume)x.value).volume()).reversed());
        }
    }

    @Override
    public Iterator<Pair<BiomeArea, AmbientVolume>> iterator() {
        return this.biomes.iterator();
    }

    public double rainVolume() {
        return this.highestRainVolume;
    }

    public void collectDetails(DebugTextRenderer text) {
        for (Pair<BiomeArea, AmbientVolume> pair : this) {
            text.detail(((BiomeArea)pair.getKey()).identifier.toString(), pair.getValue());
        }
    }

    public static class BiomeArea {
        public final Holder<Biome> biome;
        public final Identifier identifier;
        public final BlockPos pos;

        public BiomeArea(Holder<Biome> biome, BlockPos pos) {
            this.biome = biome;
            this.identifier = ((ResourceKey)biome.unwrapKey().get()).identifier();
            this.pos = pos;
        }

        public boolean checkBiome(BiomeCondition[] conditions) {
            for (BiomeCondition condition : conditions) {
                if (!(condition.tag() ? this.biome.tags().anyMatch(x -> condition.pattern().matcher(x.location().toString()).matches()) : condition.pattern().matcher(this.identifier.toString()).matches())) continue;
                return true;
            }
            return false;
        }

        public boolean equals(Object object) {
            if (object instanceof BiomeArea) {
                BiomeArea a = (BiomeArea)object;
                return a.biome.equals(this.biome);
            }
            return false;
        }

        public int hashCode() {
            return this.biome.hashCode();
        }
    }
}

