/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.environment;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.attribute.EnvironmentAttributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import team.creative.ambientsounds.condition.AmbientVolume;
import team.creative.ambientsounds.dimension.AmbientDimension;
import team.creative.ambientsounds.engine.AmbientEngine;
import team.creative.ambientsounds.environment.BiomeEnvironment;
import team.creative.ambientsounds.environment.EntityEnvironment;
import team.creative.ambientsounds.environment.TerrainEnvironment;
import team.creative.ambientsounds.mod.SereneSeasonsCompat;
import team.creative.creativecore.client.render.text.DebugTextRenderer;

public class AmbientEnvironment {
    public AmbientDimension dimension;
    public boolean muted = false;
    public boolean night;
    public double sunAngle;
    public double dayTimeHour;
    public double rainSurfaceVolume;
    public boolean raining;
    public boolean snowing;
    public boolean thundering;
    public BiomeEnvironment biome = new BiomeEnvironment();
    public TerrainEnvironment terrain = new TerrainEnvironment();
    public EntityEnvironment entity = new EntityEnvironment();
    public AmbientVolume biomeVolume = AmbientVolume.SILENT;
    public HashMap<String, AmbientVolume> biomeTypeVolumes = new HashMap();
    public double absoluteHeight;
    public double relativeHeight;
    public double relativeMinHeight;
    public double relativeMaxHeight;
    public double underwater;
    public double temperature;

    public boolean isRainAudibleAtSurface() {
        return this.rainSurfaceVolume > 0.0;
    }

    public void analyzeFast(AmbientDimension dimension, Player player, Level level, float deltaTime) {
        this.dimension = dimension;
        this.raining = level.isRainingAt(player.blockPosition().above());
        this.snowing = ((Biome)level.getBiome(player.blockPosition()).value()).coldEnoughToSnow(player.blockPosition(), level.getSeaLevel()) && level.isRaining();
        this.thundering = level.isThundering() && !this.snowing;
        this.absoluteHeight = player.getEyeY();
        this.relativeHeight = this.absoluteHeight - this.terrain.averageHeight;
        this.relativeMinHeight = this.absoluteHeight - (double)this.terrain.maxHeight;
        this.relativeMaxHeight = this.absoluteHeight - (double)this.terrain.minHeight;
        this.temperature = SereneSeasonsCompat.getTemperature(player);
        this.analyzeUnderwater(player, level);
        this.analyzeTime(level, player, deltaTime);
        this.entity.analyzeFast(dimension, player, level, deltaTime);
    }

    public void analyzeTime(Level level, Player player, float deltaTime) {
        this.sunAngle = (Math.toDegrees(((Float)level.environmentAttributes().getValue(EnvironmentAttributes.SUN_ANGLE, player.position())).floatValue()) - 180.0) % 360.0;
        if (this.sunAngle < 0.0) {
            this.sunAngle += 360.0;
        }
        this.night = this.sunAngle < 90.0 || this.sunAngle > 270.0;
        this.dayTimeHour = this.sunAngle * 0.06666666666666667;
    }

    public void analyzeUnderwater(Player player, Level level) {
        int depth = 0;
        if (player.isEyeInFluid(FluidTags.WATER)) {
            BlockPos blockpos = BlockPos.containing((Position)player.getEyePosition());
            while (level.getFluidState(blockpos).is(FluidTags.WATER)) {
                ++depth;
                blockpos = blockpos.above();
            }
        }
        this.underwater = depth;
    }

    public void analyzeSlow(AmbientDimension dimension, AmbientEngine engine, Player player, Level level, float deltaTime) {
        this.terrain.analyze(engine, dimension, player, level);
        this.biome = new BiomeEnvironment(engine, player, level, this.biomeVolume);
        this.rainSurfaceVolume = this.biome.rainVolume();
    }

    public void collectLevelDetails(DebugTextRenderer text) {
        text.detail("dimension", (Object)this.dimension);
        text.detail("night", (Object)this.night);
        text.detail("rain", (Object)this.raining);
        text.detail("rainSurfaceVolume", (Object)this.rainSurfaceVolume);
        text.detail("snow", (Object)this.snowing);
        text.detail("storm", (Object)this.thundering);
        text.detail("sun", (Object)this.sunAngle);
        text.detail("time", (Object)this.dayTimeHour);
    }

    public void collectPlayerDetails(DebugTextRenderer text, Player player) {
        text.detail("underwater", (Object)this.underwater);
        text.detail("temp", (Object)this.temperature);
        text.detail("height", (Object)("r:" + DebugTextRenderer.DECIMAL_FORMAT.format(this.relativeHeight) + ",a:" + DebugTextRenderer.DECIMAL_FORMAT.format(this.terrain.averageHeight) + " (" + DebugTextRenderer.DECIMAL_FORMAT.format(this.relativeMinHeight) + "," + DebugTextRenderer.DECIMAL_FORMAT.format(this.relativeMaxHeight) + ")"));
    }

    public void collectTerrainDetails(DebugTextRenderer text) {
        this.terrain.collectDetails(text);
    }

    public void collectBiomeDetails(DebugTextRenderer text) {
        text.detail("b-volume", (Object)this.biomeVolume);
        this.biome.collectDetails(text);
    }

    public void reload() {
        this.terrain.scanner = null;
    }
}

