/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.toolstats.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.darkhax.toolstats.Constants;

public class ConfigSchema {
    public boolean showEnchantability = true;
    public boolean alwaysShowEnchantability = false;
    public boolean showRepairCost = true;
    public boolean alwaysShowRepairCost = false;
    public boolean showHarvestLevel = true;
    public boolean showEfficiency = true;
    public boolean showSwordEfficiency = false;
    public boolean showDurability = true;
    public boolean alwaysShowDurability = false;
    public boolean showHorseArmorProtection = true;

    public static ConfigSchema load(File configFile) {
        ConfigSchema config = new ConfigSchema();
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                config = (ConfigSchema)Constants.GSON.fromJson((Reader)reader, ConfigSchema.class);
            }
            catch (IOException e) {
                Constants.LOG.error("Could not read config file {}. Defaults will be used.", (Object)configFile.getAbsolutePath());
                Constants.LOG.catching((Throwable)e);
            }
        } else {
            Constants.LOG.info("Creating a new config file at {}.", (Object)configFile.getAbsolutePath());
            configFile.getParentFile().mkdirs();
        }
        try (FileWriter writer = new FileWriter(configFile);){
            Constants.GSON.toJson((Object)config, (Appendable)writer);
            Constants.LOG.info("Saving config to {}.", (Object)configFile.getAbsolutePath());
        }
        catch (IOException e) {
            Constants.LOG.error("Could not write config file '{}'!", (Object)configFile.getAbsolutePath());
            Constants.LOG.catching((Throwable)e);
        }
        return config;
    }
}

