/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.network;

import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.gui.LeaderboardListScreen;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class LeaderboardListResponsePacket {
    private final Map<class_2960, class_2561> leaderboards;

    public LeaderboardListResponsePacket(Map<class_2960, class_2561> leaderboards) {
        this.leaderboards = leaderboards;
    }

    public static void encode(LeaderboardListResponsePacket packet, class_2540 buf) {
        buf.method_10804(packet.leaderboards.size());
        for (Map.Entry<class_2960, class_2561> entry : packet.leaderboards.entrySet()) {
            buf.method_10812(entry.getKey());
            buf.method_10805(entry.getValue());
        }
    }

    public static LeaderboardListResponsePacket decode(class_2540 buf) {
        int size = buf.method_10816();
        LinkedHashMap<class_2960, class_2561> map = new LinkedHashMap<class_2960, class_2561>();
        for (int i = 0; i < size; ++i) {
            class_2960 id = buf.method_10810();
            class_2561 title = buf.method_10808();
            map.put(id, title);
        }
        return new LeaderboardListResponsePacket(map);
    }

    public static LeaderboardListResponsePacket fromLeaderboards(Map<class_2960, Leaderboard> leaderboards) {
        LinkedHashMap<class_2960, class_2561> map = new LinkedHashMap<class_2960, class_2561>();
        for (Map.Entry<class_2960, Leaderboard> entry : leaderboards.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getTitle());
        }
        return new LeaderboardListResponsePacket(map);
    }

    public static void handle(class_2540 buf, class_310 client) {
        LeaderboardListResponsePacket packet = LeaderboardListResponsePacket.decode(buf);
        client.execute(() -> {
            LeaderboardListScreen screen = new LeaderboardListScreen(packet.leaderboards);
            screen.openGui();
        });
    }
}

