/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.plugin.mods.immersive_engineering.trades;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IServerUtils;
import com.yanny.ali.api.ITooltipNode;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.plugin.common.nodes.MissingNode;
import com.yanny.ali.plugin.common.trades.ItemsToItemsNode;
import com.yanny.ali.plugin.mods.BaseAccessor;
import com.yanny.ali.plugin.mods.ClassAccessor;
import com.yanny.ali.plugin.mods.FieldAccessor;
import com.yanny.ali.plugin.mods.IItemListing;
import com.yanny.ali.plugin.mods.PluginUtils;
import com.yanny.ali.plugin.mods.immersive_engineering.trades.LazyItemStack;
import com.yanny.ali.plugin.mods.immersive_engineering.trades.PriceInterval;
import com.yanny.ali.plugin.server.GenericTooltipUtils;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3853;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import oshi.util.tuples.Pair;

@ClassAccessor(value="blusunrize.immersiveengineering.common.world.Villages$TradeListing")
public class TradeListing
extends BaseAccessor<class_3853.class_1652>
implements IItemListing {
    private static final Logger LOGGER;
    private static final Object EMERALD_FOR_ITEM;
    private static final Object ONE_ITEM_FOR_EMERALDS;
    private static final Object ITEMS_FOR_ONE_EMERALD;
    @FieldAccessor(clazz=PriceInterval.class)
    private PriceInterval priceInfo;
    @FieldAccessor
    private Object outline;
    @FieldAccessor(clazz=LazyItemStack.class)
    private LazyItemStack lazyItem;
    @FieldAccessor
    private int maxUses;
    @FieldAccessor
    private int xp;
    @FieldAccessor
    private float priceMultiplier;

    public TradeListing(class_3853.class_1652 parent) {
        super(parent);
    }

    @Override
    @NotNull
    public IDataNode getNode(IServerUtils utils, ITooltipNode condition) {
        Either<class_1799, class_6862<? extends class_1935>> item = this.lazyItem.getItem();
        if (this.outline == EMERALD_FOR_ITEM) {
            return new ItemsToItemsNode(utils, item, new RangeValue(this.priceInfo.min, this.priceInfo.max), (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(1.0f), this.maxUses, this.xp, this.priceMultiplier, condition);
        }
        if (this.outline == ONE_ITEM_FOR_EMERALDS) {
            return new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(this.priceInfo.min, this.priceInfo.max), item, new RangeValue(1.0f), this.maxUses, this.xp, this.priceMultiplier, condition);
        }
        if (this.outline == ITEMS_FOR_ONE_EMERALD) {
            return new ItemsToItemsNode(utils, (Either<class_1799, class_6862<? extends class_1935>>)Either.left((Object)class_1802.field_8687.method_7854()), new RangeValue(1.0f), item, new RangeValue(this.priceInfo.min, this.priceInfo.max), this.maxUses, this.xp, this.priceMultiplier, condition);
        }
        return new MissingNode(GenericTooltipUtils.getMissingItemListingTooltip(utils, (class_3853.class_1652)this.parent));
    }

    @Override
    public Pair<List<class_1792>, List<class_1792>> collectItems(IServerUtils utils) {
        List<class_1792> items = PluginUtils.getItems(utils, this.lazyItem.getItem());
        if (this.outline == EMERALD_FOR_ITEM) {
            return new Pair(items, List.of(class_1802.field_8687));
        }
        if (this.outline == ONE_ITEM_FOR_EMERALDS || this.outline == ITEMS_FOR_ONE_EMERALD) {
            return new Pair(List.of(class_1802.field_8687), items);
        }
        return new Pair(List.of(), List.of());
    }

    static {
        Field typeMapField;
        Class<?> tradesClass;
        LOGGER = LogUtils.getLogger();
        Object emeraldForItem = null;
        Object oneItemForEmeralds = null;
        Object itemsForOneEmerald = null;
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("EMERALD_FOR_ITEM");
            typeMapField.setAccessible(true);
            emeraldForItem = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline EMERALD_FOR_ITEM: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("ONE_ITEM_FOR_EMERALDS");
            typeMapField.setAccessible(true);
            oneItemForEmeralds = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline ONE_ITEM_FOR_EMERALDS: {}", (Object)e.getMessage());
        }
        try {
            tradesClass = Class.forName("blusunrize.immersiveengineering.common.world.Villages");
            typeMapField = tradesClass.getDeclaredField("ITEMS_FOR_ONE_EMERALD");
            typeMapField.setAccessible(true);
            itemsForOneEmerald = typeMapField.get(null);
        }
        catch (Throwable e) {
            e.printStackTrace();
            LOGGER.warn("Unable to obtain trade outline ITEMS_FOR_ONE_EMERALD: {}", (Object)e.getMessage());
        }
        EMERALD_FOR_ITEM = emeraldForItem;
        ONE_ITEM_FOR_EMERALDS = oneItemForEmeralds;
        ITEMS_FOR_ONE_EMERALD = itemsForOneEmerald;
    }
}

