/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.jei;

import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.IWidget;
import com.yanny.ali.api.IWidgetUtils;
import com.yanny.ali.api.RangeValue;
import com.yanny.ali.api.Rect;
import com.yanny.ali.api.RelativeRect;
import com.yanny.ali.compatibility.common.EntityLootType;
import com.yanny.ali.compatibility.common.EntityStorage;
import com.yanny.ali.compatibility.common.GenericUtils;
import com.yanny.ali.compatibility.jei.JeiBaseLoot;
import com.yanny.ali.compatibility.jei.JeiLootSlotWidget;
import com.yanny.ali.compatibility.jei.RecipeHolder;
import com.yanny.ali.configuration.LootCategory;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.platform.Services;
import com.yanny.ali.plugin.client.widget.LootTableWidget;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_638;
import net.minecraft.class_8029;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class JeiEntityLoot
extends JeiBaseLoot<EntityLootType, class_1299<?>> {
    public JeiEntityLoot(IGuiHelper guiHelper, RecipeType<RecipeHolder<EntityLootType>> recipeType, LootCategory<class_1299<?>> lootCategory, class_2561 title, IDrawable icon) {
        super(guiHelper, recipeType, lootCategory, title, icon);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<EntityLootType> recipe, IFocusGroup iFocusGroup) {
        super.setRecipe(builder, recipe, iFocusGroup);
        class_1826 spawnEgg = Services.getPlatform().getSpawnEggItem(recipe.type().entityType());
        if (spawnEgg != null) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.CATALYST).setPosition(1, 1)).setStandardSlotBackground().setSlotName("spawn_egg").addItemLike((class_1935)spawnEgg);
        }
    }

    @Override
    Pair<List<IRecipeWidget>, List<IRecipeSlotDrawable>> getWidgets(IRecipeExtrasBuilder builder, final EntityLootType recipe) {
        LinkedList<IRecipeWidget> widgets = new LinkedList<IRecipeWidget>();
        LinkedList slotDrawables = new LinkedList();
        builder.getRecipeSlots().findSlotByName("spawn_egg").ifPresent(slotDrawable -> {
            widgets.add((IRecipeWidget)new JeiLootSlotWidget((IRecipeSlotDrawable)slotDrawable, 72, 0, new RangeValue(1.0f)));
            slotDrawables.add(slotDrawable);
        });
        widgets.add(this.createTextWidget(recipe.entityType().method_5897(), 81, true));
        widgets.add(new IRecipeWidget(){
            private static final int WIDGET_SIZE = 36;
            final Rect rect = new Rect(63, 10, 36, 36);
            final class_8029 position = new class_8029(0, 0);

            public void drawWidget(class_332 guiGraphics, double mouseX, double mouseY) {
                class_638 level = class_310.method_1551().field_1687;
                if (level != null) {
                    class_1297 entity = EntityStorage.getEntity(PluginManager.COMMON_REGISTRY, recipe.entityType(), (class_1937)level, recipe.variant());
                    GenericUtils.renderEntity(entity, this.rect, 162, guiGraphics, (int)mouseX, (int)mouseY);
                }
            }

            @NotNull
            public class_8029 getPosition() {
                return this.position;
            }
        });
        return new Pair(widgets, slotDrawables);
    }

    @Override
    int getYOffset(EntityLootType recipe) {
        return 48;
    }

    @Override
    IWidget getRootWidget(IWidgetUtils utils, IDataNode entry, RelativeRect rect, int maxWidth) {
        return new LootTableWidget(utils, entry, rect, maxWidth);
    }
}

