/*
 * Decompiled with CFR 0.152.
 */
package com.yanny.ali.compatibility.common;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yanny.ali.Utils;
import com.yanny.ali.api.IDataNode;
import com.yanny.ali.api.Rect;
import com.yanny.ali.compatibility.common.QuadConsumer;
import com.yanny.ali.compatibility.common.TriConsumer;
import com.yanny.ali.configuration.AliConfig;
import com.yanny.ali.manager.AliClientRegistry;
import com.yanny.ali.manager.PluginManager;
import com.yanny.ali.plugin.common.nodes.LootTableNode;
import com.yanny.ali.plugin.common.trades.TradeNode;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import net.minecraft.class_1041;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2477;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4048;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;
import oshi.util.tuples.Pair;

public class GenericUtils {
    private static final class_2960 TEXTURE_LOC = Utils.modLoc("textures/gui/gui.png");
    private static final int WIDGET_SIZE = 36;
    private static final int DOTS_WIDTH = class_310.method_1551().field_1772.method_1727("...");

    public static void renderEntity(class_1297 entity, Rect bounds, int fullWidth, class_332 guiGraphics, int mouseX, int mouseY) {
        class_310 minecraft = class_310.method_1551();
        class_1041 window = minecraft.method_22683();
        class_4587 poseStack = guiGraphics.method_51448();
        Matrix4f modelViewMatrix = new Matrix4f((Matrix4fc)poseStack.method_23760().method_23761());
        Matrix4f projectionMatrix = new Matrix4f((Matrix4fc)RenderSystem.getProjectionMatrix());
        Matrix4f mvpMatrix = projectionMatrix.mul((Matrix4fc)modelViewMatrix);
        Vector4f topLeftWorld = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        Vector4f topLeftClip = mvpMatrix.transform(topLeftWorld);
        Vector4f topLeftNDC = new Vector4f(topLeftClip.x / topLeftClip.w, topLeftClip.y / topLeftClip.w, 0.0f, 1.0f);
        int screenX = Math.round((topLeftNDC.x + 1.0f) / 2.0f * (float)window.method_4486());
        int screenY = Math.round((1.0f - topLeftNDC.y) / 2.0f * (float)window.method_4502());
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            guiGraphics.method_51448().method_22903();
            guiGraphics.method_25293(TEXTURE_LOC, bounds.x(), bounds.y(), bounds.width(), bounds.height(), 0.0f, 36.0f, 36, 36, 256, 256);
            guiGraphics.method_44379(screenX + bounds.x() + 1, screenY + bounds.y() + 1, screenX + bounds.right() - 1, screenY + bounds.bottom() - 1);
            class_4048 dimensions = entity.method_5864().method_18386();
            class_490.method_2486((class_332)guiGraphics, (int)(bounds.x() + bounds.width() / 2), (int)(bounds.y() + 36 - 5), (int)((int)Math.min(20.0f / dimensions.field_18068, 20.0f / dimensions.field_18067)), (float)((float)(-mouseX) + (float)fullWidth / 2.0f), (float)((float)(-mouseY) + 18.0f), (class_1309)livingEntity);
            guiGraphics.method_44380();
            guiGraphics.method_51448().method_22909();
        }
    }

    @NotNull
    public static class_2561 ellipsis(String text, String fallback, int maxWidth) {
        class_327 font = class_310.method_1551().field_1772;
        text = class_2477.method_10517().method_4679(text, GenericUtils.getFallbackText(fallback));
        if (font.method_1727(text) > maxWidth) {
            int index = 20;
            while (font.method_1727(text.substring(0, index + 1) + DOTS_WIDTH) <= maxWidth) {
                ++index;
            }
            return class_2561.method_43470((String)(text.substring(0, index) + "..."));
        }
        return class_2561.method_43470((String)text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<Map<class_2960, LootData>, Map<class_2960, TradeData>> decompressLootData(byte[] fullCompressedData) {
        HashMap<class_2960, LootData> lootData = new HashMap<class_2960, LootData>();
        HashMap<class_2960, TradeData> tradeData = new HashMap<class_2960, TradeData>();
        ByteArrayInputStream bis = new ByteArrayInputStream(fullCompressedData);
        ByteBuf decompressedBuf = Unpooled.buffer();
        try (GZIPInputStream gzip = new GZIPInputStream(bis);){
            decompressedBuf.writeBytes(gzip.readAllBytes());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        class_2540 readerBuf = new class_2540(decompressedBuf);
        try {
            AliClientRegistry utils = PluginManager.CLIENT_REGISTRY;
            lootData.putAll(((ArrayList)readerBuf.method_34068(ArrayList::new, b -> {
                class_2960 location = b.method_10810();
                Object dataNode = utils.getDataNodeFactory(LootTableNode.ID).create(utils, (class_2540)b);
                List items = (List)b.method_34068(ArrayList::new, class_2540::method_10819);
                return new AbstractMap.SimpleEntry<class_2960, LootData>(location, new LootData((IDataNode)dataNode, items));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            tradeData.putAll(((ArrayList)readerBuf.method_34068(ArrayList::new, b -> {
                class_2960 location = b.method_10810();
                Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, (class_2540)b);
                List<class_1792> inputs = ((ArrayList)b.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).toList();
                List<class_1792> outputs = ((ArrayList)b.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).toList();
                return new AbstractMap.SimpleEntry<class_2960, TradeData>(location, new TradeData((IDataNode)dataNode, inputs, outputs));
            })).stream().collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue)));
            Object dataNode = utils.getDataNodeFactory(TradeNode.ID).create(utils, readerBuf);
            List<class_1792> inputs = ((ArrayList)readerBuf.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).toList();
            List<class_1792> outputs = ((ArrayList)readerBuf.method_34068(ArrayList::new, class_2540::method_10810)).stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).toList();
            tradeData.put(new class_2960("empty"), new TradeData((IDataNode)dataNode, inputs, outputs));
        }
        finally {
            readerBuf.release();
        }
        return new Pair(lootData, tradeData);
    }

    public static void processData(class_638 level, AliClientRegistry clientRegistry, AliConfig config, byte[] fullCompressedData, QuadConsumer<IDataNode, class_2960, class_2248, List<class_1799>> blockConsumer, QuadConsumer<IDataNode, class_2960, class_1299<?>, List<class_1799>> entityConsumer, TriConsumer<IDataNode, class_2960, List<class_1799>> gameplayConsumer, QuadConsumer<IDataNode, class_2960, List<class_1799>, List<class_1799>> traderConsumer, QuadConsumer<IDataNode, class_2960, List<class_1799>, List<class_1799>> wanderingTraderConsumer) {
        List<class_1799> outputs;
        List<class_1799> inputs;
        TradeData tradeEntry;
        class_2960 location;
        Pair<Map<class_2960, LootData>, Map<class_2960, TradeData>> pair = GenericUtils.decompressLootData(fullCompressedData);
        Map lootData = (Map)pair.getA();
        Map tradeData = (Map)pair.getB();
        for (class_2248 block : class_7923.field_41175) {
            Object data;
            class_2960 class_29602 = block.method_26162();
            if (class_29602 == null || (data = (LootData)lootData.get(class_29602)) == null) continue;
            blockConsumer.accept(((LootData)data).node, class_29602, block, ((LootData)data).items);
            lootData.remove(class_29602);
        }
        for (class_1299 entityType : class_7923.field_41177) {
            if (config.disabledEntities.stream().anyMatch(f -> f.equals((Object)class_7923.field_41177.method_10221((Object)entityType)))) {
                lootData.remove(entityType.method_16351());
                continue;
            }
            List<class_1297> list = clientRegistry.createEntities(entityType, (class_1937)level);
            for (class_1297 entity : list) {
                class_1308 mob;
                class_2960 location3;
                if (!(entity instanceof class_1308) || (location3 = (mob = (class_1308)entity).method_5989()) == null) continue;
                LootData data = (LootData)lootData.get(location3);
                if (data != null) {
                    entityConsumer.accept(data.node, location3, entityType, data.items);
                }
                lootData.remove(location3);
            }
        }
        for (Map.Entry entry : lootData.entrySet()) {
            gameplayConsumer.accept(((LootData)entry.getValue()).node, (class_2960)entry.getKey(), ((LootData)entry.getValue()).items());
        }
        lootData.clear();
        List<Map.Entry> entries = class_7923.field_41195.method_29722().stream().sorted(Comparator.comparing(a -> ((class_5321)a.getKey()).method_29177().method_12832())).toList();
        for (Map.Entry entry : entries) {
            location = ((class_5321)entry.getKey()).method_29177();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(class_1792::method_7854).toList();
            outputs = tradeEntry.outputs.stream().map(class_1792::method_7854).toList();
            traderConsumer.accept(tradeEntry.node, location, inputs, outputs);
            tradeData.remove(location);
        }
        for (Map.Entry entry : tradeData.entrySet()) {
            location = (class_2960)entry.getKey();
            tradeEntry = (TradeData)tradeData.get(location);
            if (tradeEntry == null) continue;
            inputs = tradeEntry.inputs.stream().map(class_1792::method_7854).toList();
            outputs = tradeEntry.outputs.stream().map(class_1792::method_7854).toList();
            wanderingTraderConsumer.accept(tradeEntry.node, location, inputs, outputs);
        }
        tradeData.clear();
    }

    private static String getFallbackText(String fallback) {
        List pathSegments = Pattern.compile("/").splitAsStream(fallback).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        Collections.reverse(pathSegments);
        return pathSegments.stream().flatMap(segment -> Arrays.stream(segment.split("_"))).filter(s -> !s.isEmpty()).map(word -> Character.toUpperCase(word.charAt(0)) + word.substring(1)).collect(Collectors.joining(" "));
    }

    public record TradeData(IDataNode node, List<class_1792> inputs, List<class_1792> outputs) {
    }

    public record LootData(IDataNode node, List<class_1799> items) {
    }
}

