/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.util;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.util.DeferredInventoryDetection;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class FTBQuestsInventoryListener
implements class_1712 {
    public final class_3222 player;
    private static final Map<class_1792, List<class_1799>> inventorySummaryCache = new HashMap<class_1792, List<class_1799>>();
    private static final List<class_1799> nonEmptyStacks = new ArrayList<class_1799>();

    public FTBQuestsInventoryListener(class_3222 p) {
        this.player = p;
    }

    public static void detect(class_3222 player, class_1799 craftedItem, long sourceTask) {
        List<Task> tasksToCheck;
        ServerQuestFile file = ServerQuestFile.INSTANCE;
        if (file == null || PlayerHooks.isFake((class_1657)player)) {
            return;
        }
        List<Task> list = tasksToCheck = craftedItem.method_7960() ? file.getSubmitTasks() : file.getCraftingTasks();
        if (!tasksToCheck.isEmpty()) {
            FTBTeamsAPI.api().getManager().getTeamForPlayer(player).ifPresent(team -> {
                TeamData data = file.getNullableTeamData(team.getId());
                if (data != null && !data.isLocked()) {
                    file.withPlayerContext(player, () -> {
                        FTBQuestsInventoryListener.buildInventorySummary(player);
                        for (Task task : tasksToCheck) {
                            if (task.id == sourceTask || !data.canStartTasks(task.getQuest())) continue;
                            task.submitTask(data, player, craftedItem);
                        }
                        inventorySummaryCache.clear();
                        nonEmptyStacks.clear();
                    });
                }
            });
        }
    }

    private static void buildInventorySummary(class_3222 player) {
        player.method_31548().field_7547.forEach(stack -> {
            if (!stack.method_7960()) {
                inventorySummaryCache.computeIfAbsent(stack.method_7909(), k -> new ArrayList()).add(stack);
                nonEmptyStacks.add((class_1799)stack);
            }
        });
    }

    public static Collection<class_1799> getStacksForPlayerOfType(class_1792 item) {
        return inventorySummaryCache.getOrDefault(item, List.of());
    }

    public static Collection<class_1799> getAllNonEmptyStacksForPlayer() {
        return nonEmptyStacks;
    }

    public void method_7633(class_1703 abstractContainerMenu, int i, int j) {
    }

    public void method_7635(class_1703 menu, int index, class_1799 stack) {
        int slotNum;
        if (!stack.method_7960() && menu.method_7611((int)index).field_7871 == this.player.method_31548() && (slotNum = menu.method_7611(index).method_34266()) >= 0 && slotNum < this.player.method_31548().field_7547.size()) {
            int delay = class_3532.method_15340((int)ServerQuestFile.INSTANCE.getDetectionDelay(), (int)0, (int)200);
            if (delay == 0) {
                FTBQuestsInventoryListener.detect(this.player, class_1799.field_8037, 0L);
            } else {
                DeferredInventoryDetection.scheduleInventoryCheck(this.player, delay);
            }
        }
    }
}

