/*
 * Decompiled with CFR 0.152.
 */
package fuzs.forgeconfigscreens.client.gui.screens;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import fuzs.forgeconfigscreens.ForgeConfigScreens;
import fuzs.forgeconfigscreens.client.gui.data.EntryData;
import fuzs.forgeconfigscreens.client.gui.data.IEntryData;
import fuzs.forgeconfigscreens.client.gui.helper.ScreenTextHelper;
import fuzs.forgeconfigscreens.client.gui.screens.EditEnumScreen;
import fuzs.forgeconfigscreens.client.gui.screens.EditListScreen;
import fuzs.forgeconfigscreens.client.gui.screens.EditStringScreen;
import fuzs.forgeconfigscreens.client.gui.widget.ConfigEditBox;
import fuzs.forgeconfigscreens.client.gui.widget.MutableIconButton;
import fuzs.forgeconfigscreens.client.helper.ServerConfigUploader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigScreen
extends class_437 {
    public static final class_2960 ICONS_LOCATION = ForgeConfigScreens.id("textures/gui/icons.png");
    public static final class_2561 SORTING_AZ_TOOLTIP = class_2561.method_43469((String)"configmenusforge.gui.tooltip.sorting", (Object[])new Object[]{class_2561.method_43471((String)"configmenusforge.gui.tooltip.sorting.az")});
    public static final class_2561 SORTING_ZA_TOOLTIP = class_2561.method_43469((String)"configmenusforge.gui.tooltip.sorting", (Object[])new Object[]{class_2561.method_43471((String)"configmenusforge.gui.tooltip.sorting.za")});
    final class_437 lastScreen;
    private final List<IEntryData> searchEntries;
    private final List<IEntryData> screenEntries;
    final Map<Object, IEntryData> valueToData;
    private ConfigList list;
    class_342 searchTextField;
    private class_4185 reverseButton;
    private class_4185 filterButton;
    private class_4185 searchFilterButton;
    private final int[] buttonData;
    @Nullable
    private ConfigEditBox activeTextField;
    @Nullable
    private List<? extends class_5481> activeTooltip;
    private int tooltipTicks;

    private ConfigScreen(class_437 lastScreen, class_2561 title, UnmodifiableConfig config, Map<Object, IEntryData> valueToData, int[] buttonData) {
        super(title);
        this.lastScreen = lastScreen;
        this.valueToData = valueToData;
        this.buttonData = buttonData;
        this.searchEntries = this.gatherEntriesRecursive(config, valueToData);
        this.screenEntries = config.valueMap().values().stream().map(valueToData::get).toList();
        this.buildSubScreens(this.screenEntries);
    }

    private List<IEntryData> gatherEntriesRecursive(UnmodifiableConfig mainConfig, Map<Object, IEntryData> allEntries) {
        ArrayList entries = Lists.newArrayList();
        this.gatherEntriesRecursive(mainConfig, entries, allEntries);
        return ImmutableList.copyOf((Collection)entries);
    }

    private void gatherEntriesRecursive(UnmodifiableConfig mainConfig, List<IEntryData> entries, Map<Object, IEntryData> allEntries) {
        mainConfig.valueMap().values().forEach(value -> {
            entries.add((IEntryData)allEntries.get(value));
            if (value instanceof UnmodifiableConfig) {
                UnmodifiableConfig config = (UnmodifiableConfig)value;
                this.gatherEntriesRecursive(config, entries, allEntries);
            }
        });
    }

    private void buildSubScreens(List<IEntryData> screenEntries) {
        for (IEntryData unit : screenEntries) {
            if (!(unit instanceof EntryData.CategoryEntryData)) continue;
            EntryData.CategoryEntryData categoryEntryData = (EntryData.CategoryEntryData)unit;
            categoryEntryData.setScreen(new Sub(this, categoryEntryData.getTitle(), categoryEntryData.getConfig()));
        }
    }

    public static ConfigScreen create(class_437 lastScreen, class_2561 title, ModConfig config, Map<Object, IEntryData> valueToData) {
        UnmodifiableConfig unmodifiableConfig = ServerConfigUploader.findForgeConfigSpec(config.getSpec()).map(ForgeConfigSpec::getValues).orElseThrow();
        return new Main(lastScreen, title, unmodifiableConfig, valueToData, () -> ServerConfigUploader.saveAndUpload(config));
    }

    protected void method_25426() {
        super.method_25426();
        boolean focus = this.searchTextField != null && this.searchTextField.method_25370();
        this.searchTextField = new class_342(this.field_22793, this.field_22789 / 2 - 121, 22, 242, 20, this.searchTextField, class_5244.field_39003){

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (this.method_1885() && button == 1) {
                    this.method_1852("");
                }
                return super.method_25402(mouseX, mouseY, button);
            }
        };
        this.searchTextField.method_1863(query -> this.updateList((String)query, true));
        this.searchTextField.method_25365(focus);
        this.list = new ConfigList(this.getConfigListEntries(this.searchTextField.method_1882()));
        this.method_25429((class_364)this.list);
        this.method_25429((class_364)this.searchTextField);
        this.reverseButton = (class_4185)this.method_37063((class_364)new MutableIconButton(this.field_22789 / 2 - 126 - 20, 22, 20, 20, this.buttonData[0] == 1 ? 20 : 0, 0, ICONS_LOCATION, button -> {
            this.buttonData[0] = (this.buttonData[0] + 1) % 2;
            this.updateList(true);
            ((MutableIconButton)button).setTexture(this.buttonData[0] == 1 ? 20 : 0, 0);
        }){

            @Override
            public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.field_22763 && this.method_25367()) {
                    guiGraphics.method_51438(ConfigScreen.this.field_22793, ConfigScreen.this.buttonData[0] == 1 ? SORTING_ZA_TOOLTIP : SORTING_AZ_TOOLTIP, mouseX, mouseY);
                }
            }
        });
        this.filterButton = (class_4185)this.method_37063((class_364)new MutableIconButton(this.field_22789 / 2 + 126, 22, 20, 20, EntryFilter.values()[this.buttonData[1]].getTextureX(), 0, ICONS_LOCATION, button -> {
            this.buttonData[1] = EntryFilter.cycle(this.buttonData[1], false, class_437.method_25442());
            this.updateList(true);
            ((MutableIconButton)button).setTexture(EntryFilter.values()[this.buttonData[1]].getTextureX(), 0);
        }){

            @Override
            public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.field_22763 && this.method_25367()) {
                    guiGraphics.method_51438(ConfigScreen.this.field_22793, EntryFilter.values()[ConfigScreen.this.buttonData[1]].getMessage(), mouseX, mouseY);
                }
            }
        });
        this.searchFilterButton = (class_4185)this.method_37063((class_364)new MutableIconButton(this.field_22789 / 2 + 126 + 24, 22, 20, 20, EntryFilter.values()[this.buttonData[2]].getTextureX(), 0, ICONS_LOCATION, button -> {
            this.buttonData[2] = EntryFilter.cycle(this.buttonData[2], true, class_437.method_25442());
            this.updateList(true);
            ((MutableIconButton)button).setTexture(EntryFilter.values()[this.buttonData[2]].getTextureX(), 0);
        }){

            @Override
            public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
                if (this.field_22763 && this.method_25367()) {
                    guiGraphics.method_51438(ConfigScreen.this.field_22793, EntryFilter.values()[ConfigScreen.this.buttonData[2]].getMessage(), mouseX, mouseY);
                }
            }
        });
    }

    public void updateList(boolean resetScroll) {
        this.updateList(this.searchTextField.method_1882(), resetScroll);
    }

    private void updateList(String query, boolean resetScroll) {
        this.list.replaceEntries(this.getConfigListEntries(query), resetScroll);
        this.onSearchFieldChanged(query.trim().isEmpty());
    }

    private List<Entry> getConfigListEntries(String query) {
        return this.getConfigListEntries(!(query = query.toLowerCase(Locale.ROOT).trim()).isEmpty() ? this.searchEntries : this.screenEntries, query);
    }

    List<Entry> getConfigListEntries(List<IEntryData> entries, String searchHighlight) {
        boolean empty = searchHighlight.isEmpty();
        return entries.stream().filter(data -> data.mayInclude(searchHighlight) && EntryFilter.values()[empty ? this.buttonData[1] : this.buttonData[2]].test((IEntryData)data, empty)).sorted(IEntryData.getSearchComparator(searchHighlight, this.buttonData[0] == 1)).map(entryData -> this.makeEntry((IEntryData)entryData, searchHighlight)).filter(Objects::nonNull).toList();
    }

    void onSearchFieldChanged(boolean isEmpty) {
        this.reverseButton.field_22764 = isEmpty;
        this.filterButton.field_22764 = isEmpty;
        this.searchFilterButton.field_22764 = !isEmpty;
    }

    public void method_25393() {
        this.searchTextField.method_1865();
        if (this.activeTextField != null) {
            this.activeTextField.method_1865();
        }
        if (this.tooltipTicks < 10) {
            ++this.tooltipTicks;
        }
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
        List<? extends class_5481> lastTooltip = this.activeTooltip;
        this.activeTooltip = null;
        this.method_25420(guiGraphics);
        this.list.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.searchTextField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        this.drawBaseTitle(guiGraphics);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.activeTooltip != lastTooltip) {
            this.tooltipTicks = 0;
        }
        if (this.activeTooltip != null && this.tooltipTicks >= 10) {
            guiGraphics.method_51447(this.field_22793, this.activeTooltip, mouseX, mouseY);
        }
    }

    void drawBaseTitle(class_332 guiGraphics) {
        guiGraphics.method_27534(this.field_22793, this.method_25440(), this.field_22789 / 2, 7, 0xFFFFFF);
    }

    public abstract void method_25419();

    void setActiveTooltip(@Nullable List<? extends class_5481> activeTooltip) {
        this.activeTooltip = activeTooltip;
    }

    Entry makeEntry(IEntryData entryData, String searchHighlight) {
        if (entryData instanceof EntryData.CategoryEntryData) {
            EntryData.CategoryEntryData categoryData = (EntryData.CategoryEntryData)entryData;
            return new CategoryEntry(categoryData, searchHighlight);
        }
        if (entryData instanceof EntryData.ConfigEntryData) {
            EntryData.ConfigEntryData configEntryData = (EntryData.ConfigEntryData)entryData;
            Object currentValue = configEntryData.getCurrentValue();
            if (currentValue instanceof Boolean) {
                return new BooleanEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof Integer) {
                return new NumberEntry<Integer>((EntryData.ConfigEntryData)entryData, searchHighlight, Integer::parseInt);
            }
            if (currentValue instanceof Double) {
                return new NumberEntry<Double>((EntryData.ConfigEntryData)entryData, searchHighlight, Double::parseDouble);
            }
            if (currentValue instanceof Long) {
                return new NumberEntry<Long>((EntryData.ConfigEntryData)entryData, searchHighlight, Long::parseLong);
            }
            if (currentValue instanceof Enum) {
                return new EnumEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof String) {
                return new StringEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
            }
            if (currentValue instanceof List) {
                List listValue = (List)currentValue;
                Object value = this.getListValue((List)((EntryData.ConfigEntryData)entryData).getDefaultValue(), listValue);
                try {
                    return this.makeListEntry(entryData, searchHighlight, value);
                }
                catch (RuntimeException e) {
                    ForgeConfigScreens.LOGGER.warn("Unable to add list entry containing class type {}", (Object)(value != null ? value.getClass().getSimpleName() : "null"), (Object)e);
                    return null;
                }
            }
            ForgeConfigScreens.LOGGER.warn("Unsupported config value of class type {}", (Object)currentValue.getClass().getSimpleName());
        }
        return null;
    }

    private ListEntry<?> makeListEntry(IEntryData entryData, String searchHighlight, Object value) throws RuntimeException {
        if (value instanceof Boolean) {
            return new ListEntry<Boolean>((EntryData.ConfigEntryData)entryData, searchHighlight, "Boolean", v -> switch (v.toLowerCase(Locale.ROOT)) {
                case "true" -> true;
                case "false" -> false;
                default -> throw new IllegalArgumentException("unable to convert boolean value");
            });
        }
        if (value instanceof Integer) {
            return new ListEntry<Integer>((EntryData.ConfigEntryData)entryData, searchHighlight, "Integer", Integer::parseInt);
        }
        if (value instanceof Double) {
            return new ListEntry<Double>((EntryData.ConfigEntryData)entryData, searchHighlight, "Double", Double::parseDouble);
        }
        if (value instanceof Long) {
            return new ListEntry<Long>((EntryData.ConfigEntryData)entryData, searchHighlight, "Long", Long::parseLong);
        }
        if (value instanceof Enum) {
            return new EnumListEntry((EntryData.ConfigEntryData)entryData, searchHighlight, value.getClass());
        }
        if (value instanceof String) {
            return new ListEntry<String>((EntryData.ConfigEntryData)entryData, searchHighlight, "String", s -> {
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("string must not be empty");
                }
                return s;
            });
        }
        return new DangerousListEntry((EntryData.ConfigEntryData)entryData, searchHighlight);
    }

    @Nullable
    private Object getListValue(List<?> defaultValue, List<?> currentValue) {
        if (!defaultValue.isEmpty()) {
            return defaultValue.get(0);
        }
        if (!currentValue.isEmpty()) {
            return currentValue.get(0);
        }
        return null;
    }

    private static class Sub
    extends ConfigScreen {
        private Sub(ConfigScreen lastScreen, class_2561 title, UnmodifiableConfig config) {
            super(lastScreen, title, config, lastScreen.valueToData, lastScreen.buttonData);
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.method_25419()).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431());
            this.makeNavigationButtons().forEach(x$0 -> {
                class_4185 cfr_ignored_0 = (class_4185)this.method_37063((class_364)x$0);
            });
            this.onSearchFieldChanged(this.searchTextField.method_1882().trim().isEmpty());
        }

        private List<class_4185> makeNavigationButtons() {
            List<class_437> lastScreens = this.getLastScreens();
            int maxSize = 5;
            LinkedList buttons = Lists.newLinkedList();
            int size = Math.min(5, lastScreens.size());
            for (int i = 0; i < size; ++i) {
                class_437 screen = lastScreens.get(size - 1 - i);
                final boolean otherScreen = screen != this;
                class_2561 title = i == 0 && lastScreens.size() > 5 ? class_2561.method_43470((String)". . .") : screen.method_25440();
                buttons.add(new class_4185(0, 1, this.field_22793.method_27525((class_5348)title) + 4, 20, title, button -> {
                    if (otherScreen) {
                        this.field_22787.method_1507(screen);
                    }
                }, Supplier::get){

                    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                        int color = otherScreen && this.method_25367() ? 0xFFFF55 : 0xFFFFFF;
                        guiGraphics.method_27534(field_22793, this.method_25369(), this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, color);
                        if (this.method_25367() && otherScreen && this.field_22763) {
                            guiGraphics.method_51438(field_22793, class_5244.field_24339, mouseX, mouseY + 24);
                        }
                    }

                    public void method_25354(class_1144 soundManager) {
                        if (otherScreen) {
                            super.method_25354(soundManager);
                        }
                    }
                });
                if (i >= size - 1) continue;
                buttons.add(new class_4185(0, 1, this.field_22793.method_1727(">") + 4, 20, (class_2561)class_2561.method_43470((String)">"), button -> {}, Supplier::get){

                    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                        guiGraphics.method_27534(field_22793, this.method_25369(), this.method_46426() + this.field_22758 / 2, this.method_46427() + (this.field_22759 - 8) / 2, 0xFFFFFF);
                    }

                    public void method_25354(class_1144 soundManager) {
                    }
                });
            }
            this.setButtonPosX(buttons);
            return buttons;
        }

        private List<class_437> getLastScreens() {
            Sub lastScreen = this;
            LinkedList lastScreens = Lists.newLinkedList();
            while (lastScreen instanceof ConfigScreen) {
                ConfigScreen configScreen = lastScreen;
                lastScreens.add(lastScreen);
                lastScreen = configScreen.lastScreen;
            }
            return lastScreens;
        }

        private void setButtonPosX(List<class_4185> buttons) {
            int posX = (this.field_22789 - buttons.stream().mapToInt(class_339::method_25368).sum()) / 2;
            for (class_4185 navigationButton : buttons) {
                navigationButton.method_46421(posX);
                posX += navigationButton.method_25368();
            }
        }

        @Override
        void drawBaseTitle(class_332 guiGraphics) {
        }

        @Override
        public void method_25419() {
            if (!this.searchTextField.method_1882().isEmpty()) {
                this.searchTextField.method_1852("");
            } else {
                this.field_22787.method_1507(this.lastScreen);
            }
        }
    }

    private static class Main
    extends ConfigScreen {
        private final Runnable onSave;
        private class_4185 doneButton;
        private class_4185 cancelButton;
        private class_4185 backButton;

        private Main(class_437 lastScreen, class_2561 title, UnmodifiableConfig config, Map<Object, IEntryData> valueToData, Runnable onSave) {
            super(lastScreen, title, config, valueToData, new int[3]);
            this.onSave = onSave;
        }

        @Override
        protected void method_25426() {
            super.method_25426();
            this.doneButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> {
                if (this.valueToData.values().stream().anyMatch(Predicate.not(IEntryData::mayDiscardChanges))) {
                    this.valueToData.values().forEach(IEntryData::saveConfigValue);
                    this.onSave.run();
                }
                this.field_22787.method_1507(this.lastScreen);
            }).method_46434(this.field_22789 / 2 - 154, this.field_22790 - 28, 150, 20).method_46431());
            this.cancelButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24335, button -> this.method_25419()).method_46434(this.field_22789 / 2 + 4, this.field_22790 - 28, 150, 20).method_46431());
            this.backButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.searchTextField.method_1852("")).method_46434(this.field_22789 / 2 - 100, this.field_22790 - 28, 200, 20).method_46431());
            this.onSearchFieldChanged(this.searchTextField.method_1882().trim().isEmpty());
        }

        @Override
        void onSearchFieldChanged(boolean empty) {
            super.onSearchFieldChanged(empty);
            this.doneButton.field_22764 = empty;
            this.cancelButton.field_22764 = empty;
            this.backButton.field_22764 = !empty;
        }

        @Override
        public void method_25419() {
            if (!this.searchTextField.method_1882().isEmpty()) {
                this.searchTextField.method_1852("");
            } else {
                Object confirmScreen = this.valueToData.values().stream().allMatch(IEntryData::mayDiscardChanges) ? this.lastScreen : new class_410(result -> {
                    if (result) {
                        this.valueToData.values().forEach(IEntryData::discardCurrentValue);
                        this.field_22787.method_1507(this.lastScreen);
                    } else {
                        this.field_22787.method_1507((class_437)this);
                    }
                }, (class_2561)class_2561.method_43471((String)"configmenusforge.gui.message.discard"), (class_2561)class_2561.method_43473());
                this.field_22787.method_1507(confirmScreen);
            }
        }
    }

    public class ConfigList
    extends class_4265<Entry> {
        public ConfigList(List<Entry> entries) {
            super(ConfigScreen.this.field_22787, ConfigScreen.this.field_22789, ConfigScreen.this.field_22790, 50, ConfigScreen.this.field_22790 - 36, 24);
            entries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
        }

        protected int method_25329() {
            return this.field_22742 / 2 + 144;
        }

        public int method_25322() {
            return 260;
        }

        protected void replaceEntries(Collection<Entry> entries, boolean resetScroll) {
            super.method_25314(entries);
            if (resetScroll) {
                this.method_25307(0.0);
            }
        }

        public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
            Entry entry;
            super.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            if (this.method_25405(mouseX, mouseY) && mouseX < ConfigScreen.this.list.method_25342() + ConfigScreen.this.list.method_25322() - 67 && (entry = (Entry)this.method_37019()) != null) {
                ConfigScreen.this.setActiveTooltip(entry.getTooltip());
            }
        }
    }

    private static enum EntryFilter {
        ALL(6, "configmenusforge.gui.tooltip.showing.all", data -> true),
        ENTRIES(2, "configmenusforge.gui.tooltip.showing.entries", Predicate.not(IEntryData::category), true),
        CATEGORIES(8, "configmenusforge.gui.tooltip.showing.categories", IEntryData::category, true),
        EDITED(3, "configmenusforge.gui.tooltip.showing.edited", Predicate.not(IEntryData::mayDiscardChanges)),
        RESETTABLE(7, "configmenusforge.gui.tooltip.showing.resettable", IEntryData::mayResetValue);

        private static final String SHOWING_TRANSLATION_KEY = "configmenusforge.gui.tooltip.showing";
        private static final int[] DEFAULT_FILTERS_INDICES;
        private final int textureX;
        private final class_2561 message;
        private final Predicate<IEntryData> predicate;
        private final boolean searchOnly;

        private EntryFilter(int textureIndex, String translationKey, Predicate<IEntryData> predicate) {
            this(textureIndex, translationKey, predicate, false);
        }

        private EntryFilter(int textureIndex, String translationKey, Predicate<IEntryData> predicate, boolean searchOnly) {
            this.textureX = textureIndex * 20;
            this.message = class_2561.method_43469((String)SHOWING_TRANSLATION_KEY, (Object[])new Object[]{class_2561.method_43471((String)translationKey)});
            this.predicate = predicate;
            this.searchOnly = searchOnly;
        }

        public int getTextureX() {
            return this.textureX;
        }

        public class_2561 getMessage() {
            return this.message;
        }

        public boolean test(IEntryData data, boolean empty) {
            return this.predicate.test(data) || empty && data.category();
        }

        private boolean searchOnly() {
            return this.searchOnly;
        }

        public static int cycle(int index, boolean search, boolean reversed) {
            if (!search) {
                for (int i = 0; i < DEFAULT_FILTERS_INDICES.length; ++i) {
                    if (DEFAULT_FILTERS_INDICES[i] != index) continue;
                    index = i;
                    break;
                }
            }
            int length = search ? EntryFilter.values().length : DEFAULT_FILTERS_INDICES.length;
            int amount = reversed ? -1 : 1;
            index = (index + amount + length) % length;
            return search ? index : DEFAULT_FILTERS_INDICES[index];
        }

        static {
            DEFAULT_FILTERS_INDICES = Stream.of(EntryFilter.values()).filter(Predicate.not(EntryFilter::searchOnly)).mapToInt(Enum::ordinal).toArray();
        }
    }

    private class CategoryEntry
    extends Entry {
        private final class_4185 button;

        public CategoryEntry(EntryData.CategoryEntryData data, String searchHighlight) {
            super(data, searchHighlight);
            this.button = class_4185.method_46430((class_2561)this.getTitle(), button -> {
                ConfigScreen.this.searchTextField.method_1852("");
                ConfigScreen.this.searchTextField.method_25365(false);
                ConfigScreen.this.field_22787.method_1507((class_437)data.getScreen());
            }).method_46434(10, 5, 260, 20).method_46431();
        }

        @Override
        void addLines(class_327 font, IEntryData data, String searchHighlight, List<class_5348> lines) {
            String comment = data.getComment();
            if (comment != null && !comment.isEmpty()) {
                lines.addAll(font.method_27527().method_27498(comment, 200, class_2583.field_24360));
            }
        }

        public List<? extends class_364> method_25396() {
            return ImmutableList.of((Object)this.button);
        }

        @Override
        boolean isHovered(int mouseX, int mouseY) {
            return this.button.method_25367();
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.button.method_46421(entryLeft - 1);
            this.button.method_46419(entryTop);
            this.button.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            super.method_25343(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, selected, partialTicks);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, CategoryEntry.this.getTitle());
                }
            }, (Object)this.button);
        }
    }

    private class BooleanEntry
    extends ConfigEntry<Boolean> {
        private final class_4185 button;

        public BooleanEntry(EntryData.ConfigEntryData<Boolean> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight);
            this.button = class_4185.method_46430((class_2561)class_5244.method_36134((boolean)configEntryData.getCurrentValue()), button -> {
                boolean newValue = (Boolean)configEntryData.getCurrentValue() == false;
                configEntryData.setCurrentValue(newValue);
                this.onConfigValueChanged(newValue, false);
            }).method_46434(10, 5, 44, 20).method_46431();
            this.method_25396().add((class_339)this.button);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.method_25343(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.button.method_46421(entryLeft + rowWidth - 67);
            this.button.method_46419(entryTop);
            this.button.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onConfigValueChanged(Boolean newValue, boolean reset) {
            super.onConfigValueChanged(newValue, reset);
            this.button.method_25355(class_5244.method_36134((boolean)newValue));
        }
    }

    private class NumberEntry<T>
    extends ConfigEntry<T> {
        private final ConfigEditBox textField;

        public NumberEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, Function<String, T> parser) {
            super(configEntryData, searchHighlight);
            this.textField = new ConfigEditBox(ConfigScreen.this.field_22793, 0, 0, 42, 18, () -> ConfigScreen.this.activeTextField, activeTextField -> {
                ConfigScreen.this.activeTextField = activeTextField;
            });
            this.textField.method_1863(input -> {
                T number = null;
                try {
                    Object parsed = parser.apply((String)input);
                    if (configEntryData.getValueSpec().test(parsed)) {
                        number = (T)parsed;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (number != null) {
                    this.textField.markInvalid(false);
                    configEntryData.setCurrentValue(number);
                    this.onConfigValueChanged(number, false);
                } else {
                    this.textField.markInvalid(true);
                    configEntryData.resetCurrentValue();
                    this.resetButton.field_22763 = true;
                }
            });
            this.textField.method_1852(configEntryData.getCurrentValue().toString());
            this.method_25396().add((class_339)this.textField);
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.method_25343(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.textField.method_46421(entryLeft + rowWidth - 66);
            this.textField.method_46419(entryTop + 1);
            this.textField.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }

        @Override
        public void onConfigValueChanged(T newValue, boolean reset) {
            super.onConfigValueChanged(newValue, reset);
            if (reset) {
                this.textField.method_1852(newValue.toString());
            }
        }
    }

    private class EnumEntry
    extends EditScreenEntry<Enum<?>> {
        public EnumEntry(EntryData.ConfigEntryData<Enum<?>> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "Enum", (class_2561)class_2561.method_43471((String)"configmenusforge.gui.select"));
        }

        @Override
        String valueToString(Enum<?> value) {
            return ScreenTextHelper.toFormattedString(value.name().toLowerCase(Locale.ROOT));
        }

        @Override
        class_437 makeEditScreen(String type, Enum<?> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<Enum<?>> onSave) {
            return new EditEnumScreen(ConfigScreen.this, (class_2561)class_2561.method_43469((String)"configmenusforge.gui.value.select", (Object[])new Object[]{type}), currentValue, (Enum[])currentValue.getDeclaringClass().getEnumConstants(), arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), onSave);
        }
    }

    private class StringEntry
    extends EditScreenEntry<String> {
        public StringEntry(EntryData.ConfigEntryData<String> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "String");
        }

        @Override
        String valueToString(String value) {
            return value;
        }

        @Override
        class_437 makeEditScreen(String type, String currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<String> onSave) {
            return new EditStringScreen(ConfigScreen.this, (class_2561)class_2561.method_43469((String)"configmenusforge.gui.value.edit", (Object[])new Object[]{type}), currentValue, arg_0 -> ((ForgeConfigSpec.ValueSpec)valueSpec).test(arg_0), onSave);
        }
    }

    private class ListEntry<T>
    extends EditScreenEntry<List<T>> {
        private final Function<String, T> fromString;

        public ListEntry(EntryData.ConfigEntryData<List<T>> configEntryData, String searchHighlight, String type, Function<String, T> fromString) {
            super(configEntryData, searchHighlight, type);
            this.fromString = fromString;
        }

        @Override
        final String valueToString(List<T> value) {
            return "[" + value.stream().map(this::listValueToString).collect(Collectors.joining(", ")) + "]";
        }

        String listValueToString(Object value) {
            return value.toString();
        }

        @Override
        class_437 makeEditScreen(String type, List<T> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<List<T>> onSave) {
            return new EditListScreen(ConfigScreen.this, (class_2561)class_2561.method_43469((String)"configmenusforge.gui.list.edit", (Object[])new Object[]{type}), currentValue.stream().map(this::listValueToString).collect(Collectors.toList()), input -> {
                try {
                    this.fromString.apply((String)input);
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    return false;
                }
            }, list -> {
                List values = list.stream().map(this.fromString).collect(Collectors.toList());
                valueSpec.correct((Object)valueSpec);
                onSave.accept(values);
            });
        }
    }

    private class EnumListEntry
    extends ListEntry<Enum<?>> {
        public <T extends Enum<T>> EnumListEntry(EntryData.ConfigEntryData<List<Enum<?>>> configEntryData, String searchHighlight, Class<Enum<?>> clazz) {
            super(configEntryData, searchHighlight, "Enum", (String v) -> Enum.valueOf(clazz, v));
        }

        @Override
        String listValueToString(Object value) {
            String string;
            if (value instanceof Enum) {
                Enum e = (Enum)value;
                string = e.name();
            } else {
                string = super.listValueToString(value);
            }
            return string;
        }
    }

    private class DangerousListEntry
    extends ListEntry<String> {
        public DangerousListEntry(EntryData.ConfigEntryData<List<String>> configEntryData, String searchHighlight) {
            super(configEntryData, searchHighlight, "String", (String s) -> {
                if (s.isEmpty()) {
                    throw new IllegalArgumentException("string must not be empty");
                }
                return s;
            });
        }

        @Override
        class_437 makeEditScreen(String type, List<String> currentValue, ForgeConfigSpec.ValueSpec valueSpec, Consumer<List<String>> onSave) {
            class_5250 component1 = class_2561.method_43471((String)"configmenusforge.gui.message.dangerous.title").method_27692(class_124.field_1061);
            return new class_410(result -> {
                if (result) {
                    ConfigScreen.this.field_22787.method_1507(super.makeEditScreen(type, currentValue, valueSpec, onSave));
                } else {
                    ConfigScreen.this.field_22787.method_1507((class_437)ConfigScreen.this);
                }
            }, (class_2561)component1, (class_2561)class_2561.method_43471((String)"configmenusforge.gui.message.dangerous.text"), class_5244.field_24338, class_5244.field_24339);
        }
    }

    public abstract class Entry
    extends class_4265.class_4266<Entry> {
        private final class_2561 title;
        @Nullable
        private final List<? extends class_5481> tooltip;

        protected Entry(IEntryData data, String searchHighlight) {
            this.title = data.getDisplayTitle(searchHighlight);
            ArrayList lines = Lists.newArrayList();
            this.addLines(ConfigScreen.this.field_22793, data, searchHighlight, lines);
            this.tooltip = lines.isEmpty() ? null : class_2477.method_10517().method_30933((List)lines);
        }

        public final class_2561 getTitle() {
            return this.title;
        }

        abstract void addLines(class_327 var1, IEntryData var2, String var3, List<class_5348> var4);

        @Nullable
        public final List<? extends class_5481> getTooltip() {
            return this.tooltip;
        }

        abstract boolean isHovered(int var1, int var2);

        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            if (this.isHovered(mouseX, mouseY)) {
                ConfigScreen.this.setActiveTooltip(this.tooltip);
            }
        }

        public List<? extends class_6379> method_37025() {
            return ImmutableList.of((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    output.method_37034(class_6381.field_33788, Entry.this.title);
                }
            });
        }
    }

    private abstract class EditScreenEntry<T>
    extends ConfigEntry<T> {
        private final class_4185 button;

        public EditScreenEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, String type) {
            this(configEntryData, searchHighlight, type, (class_2561)class_2561.method_43471((String)"configmenusforge.gui.edit"));
        }

        public EditScreenEntry(EntryData.ConfigEntryData<T> configEntryData, String searchHighlight, String type, class_2561 message) {
            super(configEntryData, searchHighlight);
            this.button = class_4185.method_46430((class_2561)message, button -> {
                try {
                    ConfigScreen.this.field_22787.method_1507(this.makeEditScreen(type, configEntryData.getCurrentValue(), configEntryData.getValueSpec(), currentValue -> {
                        configEntryData.setCurrentValue(currentValue);
                        this.onConfigValueChanged(currentValue, false);
                    }));
                }
                catch (RuntimeException e) {
                    ForgeConfigScreens.LOGGER.warn("Unable to handle list entry containing class type {}", (Object)type, (Object)e);
                    button.field_22763 = false;
                }
            }).method_46434(10, 5, 44, 20).method_46431();
            this.method_25396().add((class_339)this.button);
        }

        @Override
        abstract String valueToString(T var1);

        abstract class_437 makeEditScreen(String var1, T var2, ForgeConfigSpec.ValueSpec var3, Consumer<T> var4);

        @Override
        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            super.method_25343(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
            this.button.method_46421(entryLeft + rowWidth - 67);
            this.button.method_46419(entryTop);
            this.button.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    private abstract class ConfigEntry<T>
    extends Entry {
        private static final class_2561 RESET_TOOLTIP = class_2561.method_43471((String)"configmenusforge.gui.tooltip.reset");
        private final List<class_339> children;
        private final EntryData.ConfigEntryData<T> configEntryData;
        private final class_5481 visualTitle;
        final class_4185 resetButton;

        public ConfigEntry(EntryData.ConfigEntryData<T> data, String searchHighlight) {
            super(data, searchHighlight);
            this.children = Lists.newArrayList();
            this.configEntryData = data;
            class_5348 truncatedTitle = ScreenTextHelper.truncateText(ConfigScreen.this.field_22793, this.getTitle(), 190, class_2583.field_24360);
            this.visualTitle = class_2477.method_10517().method_30934(truncatedTitle);
            final List tooltip = ConfigScreen.this.field_22793.method_1728((class_5348)RESET_TOOLTIP, 200);
            this.resetButton = new MutableIconButton(0, 0, 20, 20, 140, 0, ICONS_LOCATION, button -> {
                data.resetCurrentValue();
                this.onConfigValueChanged(data.getCurrentValue(), true);
                ConfigScreen.this.updateList(false);
            }){

                @Override
                public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTicks) {
                    super.method_48579(guiGraphics, mouseX, mouseY, partialTicks);
                    if (this.field_22763 && this.method_25367()) {
                        ConfigScreen.this.setActiveTooltip(tooltip);
                    }
                }
            };
            this.resetButton.field_22763 = data.mayResetValue();
            this.children.add((class_339)this.resetButton);
        }

        @Override
        void addLines(class_327 font, IEntryData data, String searchHighlight, List<class_5348> lines) {
            class_5250 component = class_2561.method_43470((String)data.getPath()).method_27692(class_124.field_1054);
            lines.addAll(font.method_27527().method_27495((class_5348)component, 200, class_2583.field_24360));
            String comment = data.getComment();
            if (comment != null && !comment.isEmpty()) {
                int i;
                List splitLines = font.method_27527().method_27498(comment, 200, class_2583.field_24360);
                int rangeIndex = -1;
                for (i = 0; i < splitLines.size(); ++i) {
                    String text = ((class_5348)splitLines.get(i)).getString();
                    if (!text.startsWith("Range: ") && !text.startsWith("Allowed Values: ")) continue;
                    rangeIndex = i;
                    break;
                }
                if (rangeIndex != -1) {
                    for (i = rangeIndex; i < splitLines.size(); ++i) {
                        splitLines.set(i, class_2561.method_43470((String)((class_5348)splitLines.get(i)).getString()).method_27692(class_124.field_1080));
                    }
                }
                lines.addAll(splitLines);
            }
            EntryData.ConfigEntryData configData = (EntryData.ConfigEntryData)data;
            lines.addAll(font.method_27527().method_27495((class_5348)class_2561.method_43469((String)"configmenusforge.gui.tooltip.default", (Object[])new Object[]{this.valueToString(configData.getDefaultValue())}).method_27692(class_124.field_1080), 200, class_2583.field_24360));
            if (searchHighlight != null && !searchHighlight.isEmpty()) {
                class_2561 pathComponent = configData.getFullPath().stream().map(ScreenTextHelper::toFormattedComponent).reduce((o1, o2) -> class_2561.method_43470((String)"").method_10852(o1).method_27693(" > ").method_10852(o2)).orElse((class_2561)class_2561.method_43473());
                lines.addAll(font.method_27527().method_27495((class_5348)class_2561.method_43469((String)"configmenusforge.gui.tooltip.path", (Object[])new Object[]{pathComponent}).method_27692(class_124.field_1080), 200, class_2583.field_24360));
            }
        }

        String valueToString(T value) {
            return value.toString();
        }

        public void onConfigValueChanged(T newValue, boolean reset) {
            this.resetButton.field_22763 = this.configEntryData.mayResetValue();
        }

        public List<class_339> method_25396() {
            return this.children;
        }

        @Override
        boolean isHovered(int mouseX, int mouseY) {
            return ConfigScreen.this.list != null && this.method_25405(mouseX, mouseY) && mouseX < ConfigScreen.this.list.method_25342() + ConfigScreen.this.list.method_25322() - 67;
        }

        @Override
        public void method_25343(class_332 guiGraphics, int index, int entryTop, int entryLeft, int rowWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            int color = this.isHovered(mouseX, mouseY) ? 0xFFFF55 : 0xFFFFFF;
            guiGraphics.method_35720(ConfigScreen.this.field_22793, this.visualTitle, entryLeft, entryTop + 6, color);
            this.resetButton.method_46421(entryLeft + rowWidth - 21);
            this.resetButton.method_46419(entryTop);
            this.resetButton.method_25394(guiGraphics, mouseX, mouseY, partialTicks);
            super.method_25343(guiGraphics, index, entryTop, entryLeft, rowWidth, entryHeight, mouseX, mouseY, hovered, partialTicks);
        }

        @Override
        public List<? extends class_6379> method_37025() {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add((Object)new class_6379(){

                public class_6379.class_6380 method_37018() {
                    return class_6379.class_6380.field_33785;
                }

                public void method_37020(class_6382 output) {
                    String comment = ConfigEntry.this.configEntryData.getValueSpec().getComment();
                    if (comment != null) {
                        output.method_37034(class_6381.field_33788, (class_2561)class_2561.method_43470((String)"").method_10852(ConfigEntry.this.getTitle()).method_27693(", " + comment));
                    } else {
                        output.method_37034(class_6381.field_33788, ConfigEntry.this.getTitle());
                    }
                }
            });
            builder.addAll(this.children);
            return builder.build();
        }
    }
}

