/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.integrity;

import io.github.thecsdev.tcdcommons.api.util.integrity.IntegrityError;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;

public final class SelfDefense {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String MSG_INTEGRITY_VIOLATION_FOUND = "An integrity violation was found";

    private SelfDefense() {
    }

    public static void reportClassInitializer(Class<?> issueSource) throws ExceptionInInitializerError {
        String fullName = issueSource.getName();
        String message = MSG_INTEGRITY_VIOLATION_FOUND + LINE_SEPARATOR + "The class '" + fullName + "' has a static constructor, which isn't allowed!" + LINE_SEPARATOR + "This could be a programming mistake, or it could be a malicious code injected by a virus." + LINE_SEPARATOR + "For security reasons, the program will now terminate. Please run a virus scan in the meantime." + LINE_SEPARATOR + LINE_SEPARATOR + "[BEGIN INTEGRITY DUMP]" + LINE_SEPARATOR + SelfDefense.dumpClassInfo(issueSource) + LINE_SEPARATOR + "[END INTEGRITY DUMP]" + LINE_SEPARATOR;
        throw new ExceptionInInitializerError(new IntegrityError(message, issueSource));
    }

    public static String dumpClassInfo(Class<?> clazz) {
        StringBuilder sb = new StringBuilder();
        sb.append("c: " + clazz.getName());
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            sb.append(" extends " + superClass.getName());
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        Arrays.sort(interfaces, Comparator.comparing(Class::getName));
        if (interfaces.length > 0) {
            sb.append(" implements " + Arrays.stream(interfaces).map(Class::getName).collect(Collectors.joining(", ")));
        }
        sb.append(LINE_SEPARATOR);
        Field[] fields = clazz.getDeclaredFields();
        Arrays.sort(fields, Comparator.comparing(Field::getName));
        for (Field field : fields) {
            sb.append("\tf: " + Modifier.toString(field.getModifiers()) + " " + field.getType().getName() + " " + field.getName() + LINE_SEPARATOR);
        }
        Method[] methods = clazz.getDeclaredMethods();
        Arrays.sort(methods, Comparator.comparing(Method::getName));
        for (Method method : methods) {
            sb.append("\tm: " + Modifier.toString(method.getModifiers()) + " " + method.getReturnType().getName() + " " + method.getName() + SelfDefense.__dumpMethodParameters(method) + LINE_SEPARATOR);
        }
        sb.setLength(sb.length() - LINE_SEPARATOR.length());
        return sb.toString();
    }

    private static String __dumpMethodParameters(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        return Arrays.stream(parameterTypes).map(Class::getName).collect(Collectors.joining(", ", "(", ")"));
    }
}

