/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.world.biomes;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import net.minecraft.class_7243;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeBuilder;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeSettings;
import org.betterx.bclib.api.v2.levelgen.biomes.BiomeAPI;
import org.betterx.bclib.api.v2.levelgen.surface.SurfaceRuleBuilder;
import org.betterx.bclib.interfaces.SurfaceMaterialProvider;
import org.jetbrains.annotations.NotNull;
import paulevs.edenring.EdenRing;
import paulevs.edenring.registries.EdenBiomes;
import paulevs.edenring.registries.EdenBlocks;
import paulevs.edenring.registries.EdenSounds;
import paulevs.edenring.world.CBCLBiomeSettings;

public class EdenRingBiome
extends BCLBiome
implements SurfaceMaterialProvider {
    public static final Codec<EdenRingBiome> CODEC = RecordCodecBuilder.create(instance -> EdenRingBiome.codecWithSettings((RecordCodecBuilder.Instance)instance, (RecordCodecBuilder)SurfaceMaterialProvider.CODEC.fieldOf("surface").orElse((Object)Config.DEFAULT_MATERIAL).forGetter(o -> o.surfMatProv)).apply((Applicative)instance, EdenRingBiome::new));
    public static final class_7243<EdenRingBiome> KEY_CODEC = class_7243.method_42115(CODEC);
    protected SurfaceMaterialProvider surfMatProv = Config.DEFAULT_MATERIAL;

    public class_7243<? extends BCLBiome> codec() {
        return KEY_CODEC;
    }

    protected EdenRingBiome(float terrainHeight, float fogDensity, float genChance, int edgeSize, boolean vertical, Optional<class_2960> edge, class_2960 biomeID, Optional<List<class_6544.class_4762>> parameterPoints, Optional<class_2960> biomeParent, Optional<String> intendedType, SurfaceMaterialProvider surface) {
        super(terrainHeight, fogDensity, genChance, edgeSize, vertical, edge, biomeID, parameterPoints, biomeParent, intendedType);
        this.surfMatProv = surface;
    }

    public EdenRingBiome(class_5321<class_1959> biomeID, BCLBiomeSettings settings) {
        super(biomeID, (BCLBiomeSettings)(settings != null ? settings : new CBCLBiomeSettings()));
    }

    public static EdenRingBiome create(Config biomeConfig, BiomeAPI.BiomeType type) {
        return EdenRingBiome.create(biomeConfig, type, null);
    }

    public static EdenRingBiome createSubBiome(Config data, @NotNull BCLBiome parentBiome) {
        return EdenRingBiome.create(data, parentBiome.getIntendedType(), parentBiome);
    }

    public static EdenRingBiome create(Config biomeConfig, BiomeAPI.BiomeType type, BCLBiome parentBiome) {
        BCLBiomeBuilder builder = BCLBiomeBuilder.start((class_2960)biomeConfig.ID).music(EdenSounds.MUSIC_COMMON).waterColor(4159204).waterFogColor(329011).fogColor(183, 212, 255).skyColor(113, 178, 255).surface(biomeConfig.surfaceMaterial().surface().build()).type(type);
        if (parentBiome != null) {
            builder.parentBiome(parentBiome);
        }
        biomeConfig.addCustomBuildData(builder);
        EdenRingBiome biome = (EdenRingBiome)builder.build(biomeConfig.getSupplier()).biome();
        biome.setSurfaceMaterial(biomeConfig.surfaceMaterial());
        return biome;
    }

    protected void setSurfaceMaterial(SurfaceMaterialProvider prov) {
        this.surfMatProv = prov;
    }

    public class_2680 getTopMaterial() {
        return this.surfMatProv.getTopMaterial();
    }

    public class_2680 getUnderMaterial() {
        return this.surfMatProv.getUnderMaterial();
    }

    public class_2680 getAltTopMaterial() {
        return this.surfMatProv.getAltTopMaterial();
    }

    public boolean generateFloorRule() {
        return this.surfMatProv.generateFloorRule();
    }

    public SurfaceRuleBuilder surface() {
        return this.surfMatProv.surface();
    }

    public static class_2680 findTopMaterial(BCLBiome biome) {
        return BiomeAPI.findTopMaterial((BCLBiome)biome).orElse(Config.DEFAULT_MATERIAL.getTopMaterial());
    }

    public static class_2680 findTopMaterial(class_1959 biome) {
        return EdenRingBiome.findTopMaterial(BiomeAPI.getBiome((class_1959)biome));
    }

    public static class_2680 findTopMaterial(class_5281 world, class_2338 pos) {
        return EdenRingBiome.findTopMaterial(BiomeAPI.getBiome((class_6880)world.method_23753(pos)));
    }

    public static class_2680 findUnderMaterial(BCLBiome biome) {
        return BiomeAPI.findUnderMaterial((BCLBiome)biome).orElse(Config.DEFAULT_MATERIAL.getUnderMaterial());
    }

    public static class_2680 findUnderMaterial(class_5281 world, class_2338 pos) {
        return EdenRingBiome.findUnderMaterial(BiomeAPI.getBiome((class_6880)world.method_23753(pos)));
    }

    public static List<BCLBiome> getAllBeBiomes() {
        return BiomeAPI.getAllBiomes((BiomeAPI.BiomeType)EdenBiomes.EDEN);
    }

    public static abstract class Config {
        public static final SurfaceMaterialProvider DEFAULT_MATERIAL = new DefaultSurfaceMaterialProvider();
        public final class_2960 ID;

        protected Config(String name) {
            this.ID = EdenRing.makeID(name);
        }

        protected Config(class_2960 ID) {
            this.ID = ID;
        }

        protected abstract void addCustomBuildData(BCLBiomeBuilder var1);

        public BCLBiomeBuilder.BiomeSupplier<EdenRingBiome> getSupplier() {
            return EdenRingBiome::new;
        }

        protected SurfaceMaterialProvider surfaceMaterial() {
            return DEFAULT_MATERIAL;
        }
    }

    public static class DefaultSurfaceMaterialProvider
    implements SurfaceMaterialProvider {
        public static final class_2680 DIRT = class_2246.field_10566.method_9564();
        public static final class_2680 DRIPSTONE_BLOCK = class_2246.field_28049.method_9564();
        public static final class_2680 EDEN_GRASS_BLOCK = EdenBlocks.EDEN_GRASS_BLOCK.method_9564();
        public static final class_2680 EDEN_MOSS = EdenBlocks.EDEN_MOSS.method_9564();
        public static final class_2680 EDEN_MYCELIUM = EdenBlocks.EDEN_MYCELIUM.method_9564();
        public static final class_2680 STONE = class_2246.field_10340.method_9564();

        public class_2680 getTopMaterial() {
            return EDEN_GRASS_BLOCK;
        }

        public class_2680 getAltTopMaterial() {
            return this.getTopMaterial();
        }

        public class_2680 getUnderMaterial() {
            return DIRT;
        }

        public int subSurfaceDepth() {
            return 3;
        }

        public boolean generateFloorRule() {
            return true;
        }

        public boolean generateSubSurfaceRule() {
            return true;
        }

        public SurfaceRuleBuilder surface() {
            SurfaceRuleBuilder builder = SurfaceRuleBuilder.start();
            if (this.generateFloorRule() && this.getTopMaterial() != this.getUnderMaterial()) {
                if (this.getTopMaterial() == this.getAltTopMaterial()) {
                    builder.floor(this.getTopMaterial());
                } else {
                    builder.chancedFloor(this.getTopMaterial(), this.getAltTopMaterial());
                }
            }
            if (this.generateSubSurfaceRule()) {
                builder.subsurface(this.getUnderMaterial(), this.subSurfaceDepth());
            }
            return builder;
        }
    }
}

