/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.noise;

import java.util.function.Function;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import paulevs.edenring.world.generator.TerrainGenerator;

public class InterpolationCell {
    private final float[][][] data;
    private final class_2338 origin;
    private final short dxz;
    private final short dy;

    public InterpolationCell(Function<class_2338, Float> generator, int width, int height, int dxz, int dy, class_2338 origin) {
        this.data = new float[width][width][height];
        this.origin = origin;
        this.dxz = (short)dxz;
        this.dy = (short)dy;
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = 0; x < width; ++x) {
            pos.method_33097(origin.method_10263() + x * dxz);
            for (int z = 0; z < width; ++z) {
                pos.method_33099(origin.method_10260() + z * dxz);
                for (int y = 0; y < height; ++y) {
                    pos.method_33098(origin.method_10264() + y * dy);
                    this.data[x][z][y] = generator.apply((class_2338)pos).floatValue();
                }
            }
        }
    }

    public InterpolationCell(TerrainGenerator generator, int width, int height, int dxz, int dy, class_2338 origin) {
        this.data = new float[width][width][height];
        this.origin = origin;
        this.dxz = (short)dxz;
        this.dy = (short)dy;
        class_2338.class_2339 pos = origin.method_25503();
        for (int x = 0; x < width; ++x) {
            pos.method_33097(origin.method_10263() + x * dxz);
            for (int z = 0; z < width; ++z) {
                pos.method_33099(origin.method_10260() + z * dxz);
                generator.fillTerrainDensity(this.data[x][z], (class_2338)pos, dxz, dy);
            }
        }
    }

    public float get(class_2338 pos, boolean relative) {
        if (relative) {
            return this.get(pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
        return this.get(pos.method_10263() - this.origin.method_10263(), pos.method_10264() - this.origin.method_10264(), pos.method_10260() - this.origin.method_10260());
    }

    private float get(int x, int y, int z) {
        int x1 = x / this.dxz;
        int y1 = y / this.dy;
        int z1 = z / this.dxz;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int z2 = z1 + 1;
        float dx = (float)x / (float)this.dxz - (float)x1;
        float dy = (float)y / (float)this.dy - (float)y1;
        float dz = (float)z / (float)this.dxz - (float)z1;
        float a = class_3532.method_16439((float)dx, (float)this.data[x1][z1][y1], (float)this.data[x2][z1][y1]);
        float b = class_3532.method_16439((float)dx, (float)this.data[x1][z1][y2], (float)this.data[x2][z1][y2]);
        float c = class_3532.method_16439((float)dx, (float)this.data[x1][z2][y1], (float)this.data[x2][z2][y1]);
        float d = class_3532.method_16439((float)dx, (float)this.data[x1][z2][y2], (float)this.data[x2][z2][y2]);
        a = class_3532.method_16439((float)dy, (float)a, (float)b);
        b = class_3532.method_16439((float)dy, (float)c, (float)d);
        return class_3532.method_16439((float)dz, (float)a, (float)b);
    }

    public short getMinY() {
        short max = this.data[0][0].length;
        for (short y = 0; y < max; y = (short)(y + 1)) {
            if (!this.checkSlice(y)) continue;
            return this.getY(y - 1);
        }
        return this.getY(max - 1);
    }

    public short getMaxY() {
        for (short y = (short)(this.data[0][0].length - 1); y >= 0; y = (short)(y - 1)) {
            if (!this.checkSlice(y)) continue;
            return this.getY(y + 1);
        }
        return (short)this.origin.method_10264();
    }

    private short getY(int y) {
        return (short)(y * this.dy + this.origin.method_10264());
    }

    private boolean checkSlice(short y) {
        for (int x = 0; x < this.data.length; ++x) {
            for (int z = 0; z < this.data[0].length; ++z) {
                if (!(this.data[x][z][y] > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }
}

