/*
 * Decompiled with CFR 0.152.
 */
package paulevs.edenring.entities;

import java.util.EnumSet;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1330;
import net.minecraft.class_1333;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.betterx.bclib.entity.DespawnableAnimal;
import org.betterx.bclib.util.MHelper;
import org.jetbrains.annotations.Nullable;
import paulevs.edenring.EdenRing;
import paulevs.edenring.registries.EdenEntities;
import paulevs.edenring.registries.EdenSounds;

public class DiskwingEntity
extends DespawnableAnimal {
    private static final class_2940<Integer> VARIANT = class_2945.method_12791(DiskwingEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> SIZE = class_2945.method_12791(DiskwingEntity.class, (class_2941)class_2943.field_13327);
    private class_243 moveTargetPoint = class_243.field_1353;
    private class_2338 anchorPoint = class_2338.field_10980;

    public DiskwingEntity(class_1299<DiskwingEntity> entityType, class_1937 level) {
        super(entityType, level);
        this.field_6207 = new DiskwingMoveControl((class_1308)this);
        this.field_6206 = new DiskwingLookControl((class_1308)this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new ChangeAnchoePointGoal());
        this.field_6201.method_6277(1, (class_1352)new DiskwingCircleAroundAnchorGoal());
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityTag) {
        class_1315 data = super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
        this.field_6011.method_12778(VARIANT, (Object)world.method_8410().field_9229.method_43048(DiskwingType.VALUES.length));
        this.field_6011.method_12778(SIZE, (Object)world.method_8410().field_9229.method_43048(255));
        if (entityTag != null) {
            if (entityTag.method_10545("Variant")) {
                int variant = entityTag.method_10550("Variant");
                if (variant >= DiskwingType.VALUES.length) {
                    variant = 0;
                }
                this.field_6011.method_12778(VARIANT, (Object)variant);
            }
            if (entityTag.method_10545("Size")) {
                int size = entityTag.method_10550("Size");
                this.field_6011.method_12778(SIZE, (Object)size);
            }
        }
        this.anchorPoint = this.method_24515().method_10086(5);
        this.method_18382();
        return data;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)0);
        this.field_6011.method_12784(SIZE, (Object)0);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", ((Integer)this.field_6011.method_12789(VARIANT)).intValue());
        tag.method_10569("Size", ((Integer)this.field_6011.method_12789(SIZE)).intValue());
    }

    public void method_5749(class_2487 tag) {
        int variant;
        super.method_5749(tag);
        if (tag.method_10545("Variant")) {
            variant = tag.method_10550("Variant");
            if (variant >= DiskwingType.VALUES.length) {
                variant = 0;
            }
            this.field_6011.method_12778(VARIANT, (Object)variant);
        }
        if (tag.method_10545("Size")) {
            variant = tag.method_10550("Size");
            this.field_6011.method_12778(SIZE, (Object)variant);
        }
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        DiskwingEntity entity = (DiskwingEntity)EdenEntities.DISKWING.method_5883((class_1937)serverLevel);
        entity.setVariant(((DiskwingEntity)((Object)DiskwingEntity.class.cast(ageableMob))).getVariant());
        entity.setScale(ageableMob.method_6051().method_43048(255));
        return entity;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_5740() {
        return true;
    }

    protected void method_5623(double d, boolean bl, class_2680 blockState, class_2338 blockPos) {
    }

    public boolean method_6101() {
        return false;
    }

    protected class_3414 method_5994() {
        return EdenSounds.DISKWING_AMBIENT;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return EdenSounds.DISKWING_DAMAGE;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
    }

    public DiskwingType getVariant() {
        int type = (Integer)this.field_6011.method_12789(VARIANT);
        return DiskwingType.VALUES[type];
    }

    public void setVariant(DiskwingType variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.ordinal());
    }

    public float method_17825() {
        short size = (short)((Integer)this.field_6011.method_12789(SIZE) & 0xFF);
        float scale = this.method_6109() ? 0.5f : 1.0f;
        return scale * class_3532.method_16439((float)((float)size / 255.0f), (float)0.75f, (float)1.0f);
    }

    public void setScale(int scale) {
        this.field_6011.method_12778(SIZE, (Object)scale);
    }

    protected class_1330 method_5963() {
        return new DiskwingBodyRotationControl((class_1308)this);
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23717, 16.0).method_26868(class_5134.field_23720, 1.0).method_26868(class_5134.field_23719, 0.1);
    }

    public boolean method_5640(double d) {
        return super.method_5640(d * 0.1);
    }

    class DiskwingMoveControl
    extends class_1335 {
        private float speed;

        public DiskwingMoveControl(class_1308 mob) {
            super(mob);
            this.speed = 0.1f;
        }

        public void method_6240() {
            if (DiskwingEntity.this.field_5976) {
                DiskwingEntity.this.method_36456(DiskwingEntity.this.method_36454() + 180.0f);
                this.speed = 0.1f;
            }
            float f = (float)(DiskwingEntity.this.moveTargetPoint.field_1352 - DiskwingEntity.this.method_23317());
            float g = (float)(DiskwingEntity.this.moveTargetPoint.field_1351 - DiskwingEntity.this.method_23318());
            float h = (float)(DiskwingEntity.this.moveTargetPoint.field_1350 - DiskwingEntity.this.method_23321());
            float d = MHelper.length((float)f, (float)h);
            if (Math.abs(d) > 1.0E-5f) {
                float e = 1.0f - class_3532.method_15379((float)(g * 0.7f)) / d;
                d = MHelper.length((float)(f *= e), (float)(h *= e));
                double i = class_3532.method_15355((float)(f * f + h * h + g * g));
                float j = DiskwingEntity.this.method_36454();
                float k = (float)class_3532.method_15349((double)h, (double)f);
                float l = class_3532.method_15393((float)(DiskwingEntity.this.method_36454() + 90.0f));
                float m = class_3532.method_15393((float)(k * 57.295776f));
                DiskwingEntity.this.method_36456(class_3532.method_15388((float)l, (float)m, (float)4.0f) - 90.0f);
                DiskwingEntity.this.field_6283 = DiskwingEntity.this.method_36454();
                this.speed = class_3532.method_15356((float)j, (float)DiskwingEntity.this.method_36454()) < 3.0f ? class_3532.method_15348((float)this.speed, (float)1.8f, (float)(0.005f * (1.8f / this.speed))) : class_3532.method_15348((float)this.speed, (float)0.2f, (float)0.025f);
                float n = (float)(-(class_3532.method_15349((double)(-g), (double)d) * 57.2957763671875));
                DiskwingEntity.this.method_36457(n);
                float o = DiskwingEntity.this.method_36454() + 90.0f;
                double p = (double)(this.speed * class_3532.method_15362((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)f / i);
                double q = (double)(this.speed * class_3532.method_15374((float)(o * ((float)Math.PI / 180)))) * Math.abs((double)h / i);
                double r = (double)(this.speed * class_3532.method_15374((float)(n * ((float)Math.PI / 180)))) * Math.abs((double)g / i);
                class_243 vec3 = DiskwingEntity.this.method_18798();
                DiskwingEntity.this.method_18799(vec3.method_1019(new class_243(p, r, q).method_1020(vec3).method_1021(0.2)));
            }
        }
    }

    class DiskwingLookControl
    extends class_1333 {
        public DiskwingLookControl(class_1308 mob) {
            super(mob);
        }

        public void method_6231() {
        }
    }

    class ChangeAnchoePointGoal
    extends class_1352 {
        ChangeAnchoePointGoal() {
        }

        public boolean method_6264() {
            return DiskwingEntity.this.field_5974.method_43048(32) == 0;
        }

        public void method_6269() {
            class_5819 random = DiskwingEntity.this.field_5974;
            class_2338 point = DiskwingEntity.this.anchorPoint;
            class_1937 level = DiskwingEntity.this.method_37908();
            int x = point.method_10263() + MHelper.randRange((int)-20, (int)20, (class_5819)random);
            int y = point.method_10264() + MHelper.randRange((int)-20, (int)20, (class_5819)random);
            int z = point.method_10260() + MHelper.randRange((int)-20, (int)20, (class_5819)random);
            if (point.method_10264() - 64 < level.method_31607()) {
                y = level.method_31607() + 64;
            } else if (point.method_10264() + 64 > level.method_31600()) {
                y = level.method_31600() - 64;
            }
            point = new class_2338(x, y, z);
            if (level.method_8320(point).method_26215()) {
                DiskwingEntity.this.anchorPoint = point;
            }
        }
    }

    class DiskwingCircleAroundAnchorGoal
    extends class_1352 {
        private float angle;
        private float distance;
        private float height;
        private float clockwise;

        DiskwingCircleAroundAnchorGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        protected boolean touchingTarget() {
            return DiskwingEntity.this.moveTargetPoint.method_1028(DiskwingEntity.this.method_23317(), DiskwingEntity.this.method_23318(), DiskwingEntity.this.method_23321()) < 4.0;
        }

        public boolean method_6264() {
            return true;
        }

        public void method_6269() {
            this.distance = 5.0f + DiskwingEntity.this.field_5974.method_43057() * 10.0f;
            this.height = -4.0f + DiskwingEntity.this.field_5974.method_43057() * 9.0f;
            this.clockwise = DiskwingEntity.this.field_5974.method_43056() ? 1.0f : -1.0f;
            this.selectNext();
        }

        public void method_6268() {
            if (DiskwingEntity.this.field_5974.method_43048(this.method_38847(350)) == 0) {
                this.height = -4.0f + DiskwingEntity.this.field_5974.method_43057() * 9.0f;
            }
            if (DiskwingEntity.this.field_5974.method_43048(this.method_38847(250)) == 0) {
                this.distance += 1.0f;
                if (this.distance > 15.0f) {
                    this.distance = 5.0f;
                    this.clockwise = -this.clockwise;
                }
            }
            if (DiskwingEntity.this.field_5974.method_43048(this.method_38847(450)) == 0) {
                this.angle = DiskwingEntity.this.field_5974.method_43057() * 2.0f * (float)Math.PI;
                this.selectNext();
            }
            if (this.touchingTarget()) {
                this.selectNext();
            }
            if (DiskwingEntity.this.moveTargetPoint.field_1351 < DiskwingEntity.this.method_23318() && !DiskwingEntity.this.method_37908().method_22347(DiskwingEntity.this.method_24515().method_10087(1))) {
                this.height = Math.max(1.0f, this.height);
                this.selectNext();
            }
            if (DiskwingEntity.this.moveTargetPoint.field_1351 > DiskwingEntity.this.method_23318() && !DiskwingEntity.this.method_37908().method_22347(DiskwingEntity.this.method_24515().method_10086(1))) {
                this.height = Math.min(-1.0f, this.height);
                this.selectNext();
            }
        }

        private void selectNext() {
            if (class_2338.field_10980.equals((Object)DiskwingEntity.this.anchorPoint)) {
                DiskwingEntity.this.anchorPoint = DiskwingEntity.this.method_24515();
            }
            this.angle += this.clockwise * 15.0f * ((float)Math.PI / 180);
            DiskwingEntity.this.moveTargetPoint = class_243.method_24954((class_2382)DiskwingEntity.this.anchorPoint).method_1031((double)(this.distance * class_3532.method_15362((float)this.angle)), (double)(-4.0f + this.height), (double)(this.distance * class_3532.method_15374((float)this.angle)));
        }
    }

    public static enum DiskwingType {
        BLUE("blue"),
        GREEN("green"),
        RED("red"),
        PURPLE("purple");

        public static final DiskwingType[] VALUES;
        private final class_2960 texture;
        private final class_2960 glow;

        private DiskwingType(String texture) {
            this.texture = EdenRing.makeID("textures/entity/diskwing/diskwing_" + texture + ".png");
            this.glow = EdenRing.makeID("textures/entity/diskwing/diskwing_" + texture + "_glow.png");
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public class_2960 getGlow() {
            return this.glow;
        }

        static {
            VALUES = DiskwingType.values();
        }
    }

    class DiskwingBodyRotationControl
    extends class_1330 {
        public DiskwingBodyRotationControl(class_1308 mob) {
            super(mob);
        }

        public void method_6224() {
            DiskwingEntity.this.field_6241 = DiskwingEntity.this.field_6283;
            DiskwingEntity.this.field_6283 = DiskwingEntity.this.method_36454();
        }
    }
}

