/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.core;

import java.util.UUID;
import net.minecraft.class_1041;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_3419;
import net.minecraft.class_634;
import net.minecraft.class_640;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.core.GameContext;
import nx.pingwheel.common.core.PingData;
import nx.pingwheel.common.math.MathUtils;
import nx.pingwheel.common.math.ScreenPos;
import nx.pingwheel.common.network.PingLocationS2CPacket;
import nx.pingwheel.common.render.WorldRenderContext;
import nx.pingwheel.common.resource.ResourceConstants;
import nx.pingwheel.common.util.DirectionalSoundInstance;
import org.jetbrains.annotations.Nullable;

public class PingView
extends PingData {
    private static final ClientConfig CLIENT_CONFIG = ClientConfig.HANDLER.getConfig();
    private static final int WHITE = -1;
    private int spawnTime;
    private int age;
    @Nullable
    private class_640 playerInfo;
    @Nullable
    private class_1799 itemStack;
    private ScreenPos screenPos;
    private double distance;
    private float scale;

    private PingView(class_243 pos, @Nullable UUID entityId, @Nullable UUID authorId, int sequence, int dimension) {
        super(pos, entityId, authorId, sequence, dimension);
    }

    public static PingView of(class_243 pos, @Nullable UUID entityId, @Nullable UUID authorId, int sequence, int dimension) {
        return new PingView(pos, entityId, authorId, sequence, dimension);
    }

    public static PingView from(PingLocationS2CPacket packet) {
        return PingView.of(packet.pos(), packet.entity(), packet.author(), packet.sequence(), packet.dimension());
    }

    public void update(WorldRenderContext ctx, int gameTime) {
        class_1297 ent;
        if (this.spawnTime == 0) {
            this.spawnTime = gameTime;
        }
        this.age = gameTime - this.spawnTime;
        class_634 connection = CommonClient.Game.method_1562();
        if (connection != null && this.authorId != null) {
            this.playerInfo = connection.method_2871(this.authorId);
        }
        if (this.entityId != null && (ent = GameContext.getEntity(this.entityId)) != null) {
            if (ent.method_5864() == class_1299.field_6052 && CLIENT_CONFIG.isItemIconVisible()) {
                this.itemStack = ((class_1542)ent).method_6983().method_7972();
            }
            this.pos = ent.method_30950(ctx.tickDelta.floatValue()).method_1031(0.0, ent.method_5829().method_17940(), 0.0);
        }
        this.screenPos = MathUtils.worldToScreen(this.pos, ctx.modelViewMatrix, ctx.projectionMatrix);
        this.distance = ctx.camera.method_19326().method_1022(this.pos);
        this.calculateScale();
    }

    public void playSoundInDimension() {
        if (this.dimension != GameContext.getDimension()) {
            return;
        }
        CommonClient.Game.method_1483().method_4873((class_1113)new DirectionalSoundInstance(ResourceConstants.PING_SOUND_EVENT, class_3419.field_15250, (float)CLIENT_CONFIG.getPingVolume() / 100.0f, 1.0f, this.pos));
    }

    public boolean isExpired() {
        return this.age > CLIENT_CONFIG.getPingDuration() * 20 && CLIENT_CONFIG.getPingDuration() < 60;
    }

    public boolean isRemovable() {
        return (CLIENT_CONFIG.getCorrectionPeriod() >= 5.0f || (float)this.age > CLIENT_CONFIG.getCorrectionPeriod() * 20.0f) && this.distanceToCenter() < (float)CLIENT_CONFIG.getRemoveRadius();
    }

    public float distanceToCenter() {
        if (this.screenPos == null) {
            return 0.0f;
        }
        class_1041 wnd = CommonClient.Game.method_22683();
        class_241 center = new class_241((float)wnd.method_4486() * 0.5f, (float)wnd.method_4502() * 0.5f);
        return this.screenPos.distanceTo(center);
    }

    public boolean isCloserToCenter(@Nullable PingView b) {
        if (b == null) {
            return true;
        }
        return this.distanceToCenter() < b.distanceToCenter();
    }

    public int getTeamColor() {
        if (this.playerInfo == null || this.playerInfo.method_2955() == null) {
            return -1;
        }
        if (this.playerInfo == null) {
            return -1;
        }
        Integer teamColor = this.playerInfo.method_2955().method_1202().method_532();
        if (teamColor == null) {
            return -1;
        }
        return 0xFF000000 | teamColor;
    }

    private void calculateScale() {
        double scale = 2.0 / Math.pow(this.distance, 0.3);
        float pingSize = (float)CLIENT_CONFIG.getPingSize() / 100.0f;
        this.scale = (float)Math.max(1.0, scale) * 0.5f * pingSize;
    }

    @Nullable
    public class_640 getPlayerInfo() {
        return this.playerInfo;
    }

    @Nullable
    public class_1799 getItemStack() {
        return this.itemStack;
    }

    public ScreenPos getScreenPos() {
        return this.screenPos;
    }

    public double getDistance() {
        return this.distance;
    }

    public float getScale() {
        return this.scale;
    }
}

