/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.class_2975;
import net.minecraft.class_3003;
import net.minecraft.class_3037;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5934;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6817;
import net.minecraft.class_6819;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.potionstudios.biomeswevegone.BiomesWeveGone;

public class PlacedFeaturesUtil {
    public static final Map<class_5321<class_6796>, PlacedFeatureFactory> PLACED_FEATURE_FACTORIES = new Reference2ObjectOpenHashMap();
    private static final class_3003 CLEARING_NOISE = class_3003.method_39642((double)0.545, (int)1, (int)0);

    protected static Supplier<List<class_6797>> clearingTreePlacement(class_6797 placementModifier) {
        ArrayList<class_3003> placementModifiers = new ArrayList<class_3003>(class_6819.method_39740((class_6797)placementModifier));
        placementModifiers.add(CLEARING_NOISE);
        return () -> placementModifiers;
    }

    public static Supplier<List<class_6797>> treePlacementBaseOceanFloor(class_6797 ... $$0) {
        return PlacedFeaturesUtil.treePlacementBaseOceanFloor(OptionalInt.empty(), $$0);
    }

    public static Supplier<List<class_6797>> treePlacementBaseOceanFloor(OptionalInt maxDepth, class_6797 ... $$0) {
        ImmutableList.Builder placementModifierBuilder = ImmutableList.builder().add((Object[])$$0).add((Object)class_5450.method_39639()).add((Object)class_6817.field_36079).add((Object)class_6792.method_39614());
        if (maxDepth.isPresent()) {
            placementModifierBuilder.add((Object)class_5934.method_39662((int)maxDepth.getAsInt()));
        }
        return () -> ((ImmutableList.Builder)placementModifierBuilder).build();
    }

    public static Supplier<List<class_6797>> oceanFloorSquaredWithCount(int $$0, class_6797 ... modifiers) {
        return PlacedFeaturesUtil.oceanFloorSquaredWithCountAndMaxDepth($$0, OptionalInt.empty(), modifiers);
    }

    public static Supplier<List<class_6797>> oceanFloorSquaredWithCountAndMaxDepth(int $$0, OptionalInt maxDepth, class_6797 ... modifiers) {
        ArrayList<class_6792> placementModifiers = new ArrayList<class_6792>(List.of(class_6793.method_39623((int)$$0), class_5450.method_39639(), class_6817.field_36079, class_6792.method_39614()));
        if (maxDepth.isPresent()) {
            placementModifiers.add((class_6792)class_5934.method_39662((int)maxDepth.getAsInt()));
        }
        placementModifiers.addAll(Arrays.asList(modifiers));
        return () -> placementModifiers;
    }

    public static <FC extends class_3037> class_6880<class_6796> createPlacedFeatureDirect(class_6880<class_2975<?, ?>> feature, class_6797 ... placementModifiers) {
        return PlacedFeaturesUtil.createPlacedFeatureDirect(feature, List.of(placementModifiers));
    }

    public static <FC extends class_3037> class_6880<class_6796> createPlacedFeatureDirect(class_6880<class_2975<?, ?>> feature, List<class_6797> placementModifiers) {
        return class_6880.method_40223((Object)new class_6796(feature, placementModifiers));
    }

    protected static <FC extends class_3037> class_5321<class_6796> createPlacedFeature(String id, class_5321<class_2975<?, ?>> feature, Supplier<List<class_6797>> placementModifiers) {
        class_5321<class_6796> placedFeatureKey = PlacedFeaturesUtil.registerKey(id);
        PLACED_FEATURE_FACTORIES.put(placedFeatureKey, configuredFeatureHolderGetter -> new class_6796((class_6880)configuredFeatureHolderGetter.method_46747(feature), (List)placementModifiers.get()));
        return placedFeatureKey;
    }

    private static class_5321<class_6796> registerKey(String name) {
        return BiomesWeveGone.key(class_7924.field_41245, name);
    }

    @FunctionalInterface
    public static interface PlacedFeatureFactory {
        public class_6796 generate(class_7871<class_2975<?, ?>> var1);
    }
}

