/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.frostiful.client;

import com.github.thedeathlycow.frostiful.Frostiful;
import com.github.thedeathlycow.frostiful.config.FrostifulConfig;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2i;

public class FrozenHeartsOverlay {
    public static final class_2960 HEART_OVERLAY_TEXTURE = Frostiful.id("textures/gui/cold_heart_overlay.png");
    private static final int TEXTURE_WIDTH = 18;
    private static final int TEXTURE_HEIGHT = 10;

    public static void afterHealthBar(class_332 context, class_1657 player, Vector2i[] heartPositions, int displayHealth, int maxDisplayHealth) {
        FrostifulConfig config = Frostiful.getConfig();
        if (!config.clientConfig.doColdHeartOverlay() || player.thermoo$isWarm()) {
            return;
        }
        int frozenHealthPoints = FrozenHeartsOverlay.getNumColdPoints((class_1309)player, maxDisplayHealth);
        int frozenHealthHearts = FrozenHeartsOverlay.getNumColdHeartsFromPoints(frozenHealthPoints);
        for (int i = 0; i < frozenHealthHearts; ++i) {
            Vector2i pos = heartPositions[i];
            if (pos == null) continue;
            boolean isHalfHeart = i + 1 >= frozenHealthHearts && (frozenHealthPoints & 1) == 1;
            int u = isHalfHeart ? 9 : 0;
            context.method_25290(HEART_OVERLAY_TEXTURE, pos.x, pos.y, (float)u, 0.0f, 9, 10, 18, 10);
        }
    }

    public static void afterMountHealthBar(class_332 context, class_1657 player, class_1309 mount, Vector2i[] mountHeartPositions, int displayMountHealth, int maxDisplayMountHealth) {
        FrostifulConfig config = Frostiful.getConfig();
        if (!config.clientConfig.doColdHeartOverlay() || player.thermoo$isWarm()) {
            return;
        }
        int frozenHealthPoints = FrozenHeartsOverlay.getNumColdPoints(mount, maxDisplayMountHealth);
        int frozenHealthHearts = FrozenHeartsOverlay.getNumColdHeartsFromPoints(frozenHealthPoints);
        for (int i = 0; i < frozenHealthHearts; ++i) {
            boolean isHalfHeart;
            Vector2i pos = mountHeartPositions[i];
            if (pos == null) continue;
            boolean bl = isHalfHeart = i + 1 >= frozenHealthHearts && (frozenHealthPoints & 1) == 1;
            if (isHalfHeart) {
                context.method_25290(HEART_OVERLAY_TEXTURE, pos.x + 4, pos.y, 4.0f, 0.0f, 5, 10, 18, 10);
                continue;
            }
            context.method_25290(HEART_OVERLAY_TEXTURE, pos.x, pos.y, 0.0f, 0.0f, 9, 10, 18, 10);
        }
    }

    private static int getNumColdPoints(@NotNull class_1309 entity, int maxDisplayHealth) {
        float freezingProgress = -entity.thermoo$getTemperatureScale();
        return Math.round(freezingProgress * (float)maxDisplayHealth);
    }

    private static int getNumColdHeartsFromPoints(int frozenHealthPoints) {
        return class_3532.method_15386((float)((float)frozenHealthPoints / 2.0f));
    }

    private FrozenHeartsOverlay() {
    }
}

